/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.factory.BaseNDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNativeNDArrayFactory
extends BaseNDArrayFactory {
    private static final Logger log = LoggerFactory.getLogger(BaseNativeNDArrayFactory.class);
    protected NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();

    public BaseNativeNDArrayFactory(DataType dtype, Character order) {
        super(dtype, order);
    }

    public BaseNativeNDArrayFactory(DataType dtype, char order) {
        super(dtype, order);
    }

    public BaseNativeNDArrayFactory() {
    }

    @Override
    public Pointer convertToNumpy(INDArray array) {
        LongPointer size = new LongPointer(1L);
        Pointer header = NativeOpsHolder.getInstance().getDeviceNativeOps().numpyHeaderForNd4j(array.data().pointer(), array.shapeInfoDataBuffer().pointer(), array.data().getElementSize(), size);
        long headerSize = size.get() - 1L;
        header.capacity(headerSize);
        header.position(0L);
        BytePointer bytePointer = new BytePointer((int)(headerSize + (long)array.data().getElementSize() * array.data().length()));
        BytePointer headerCast = new BytePointer(header);
        ByteIndexer indexer = ByteIndexer.create(headerCast);
        int pos = 0;
        bytePointer.position(pos);
        Pointer.memcpy(bytePointer, headerCast, headerCast.capacity());
        pos = (int)((long)pos + headerCast.capacity());
        bytePointer.position(pos);
        Nd4j.getAffinityManager().ensureLocation(array, AffinityManager.Location.HOST);
        Pointer.memcpy(bytePointer, array.data().pointer(), (long)array.data().getElementSize() * array.data().length());
        bytePointer.position(0L);
        return bytePointer;
    }

    @Override
    public INDArray createFromNpyPointer(Pointer pointer) {
        Pointer dataPointer = this.nativeOps.dataPointForNumpy(pointer);
        int dataBufferElementSize = this.nativeOps.elementSizeForNpyArray(pointer);
        DataBuffer data = null;
        Pointer shapeBufferPointer = this.nativeOps.shapeBufferForNumpy(pointer);
        int length = this.nativeOps.lengthForShapeBufferPointer(shapeBufferPointer);
        shapeBufferPointer.capacity(8 * length);
        shapeBufferPointer.limit(8 * length);
        shapeBufferPointer.position(0L);
        LongPointer intPointer = new LongPointer(shapeBufferPointer);
        LongPointer newPointer = new LongPointer((long)length);
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        Pointer.memcpy(newPointer, intPointer, shapeBufferPointer.limit());
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, shapeBufferPointer.limit(), MemcpyDirection.HOST_TO_HOST);
        DataBuffer shapeBuffer = Nd4j.createBuffer((Pointer)newPointer, DataType.LONG, (long)length, LongIndexer.create(newPointer));
        dataPointer.position(0L);
        dataPointer.limit((long)dataBufferElementSize * Shape.length(shapeBuffer));
        dataPointer.capacity((long)dataBufferElementSize * Shape.length(shapeBuffer));
        long[] jvmShapeInfo = shapeBuffer.asLong();
        DataType dtype = ArrayOptionsHelper.dataType(jvmShapeInfo);
        switch (dtype) {
            case BOOL: {
                Pointer dPointer = new BooleanPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), BooleanIndexer.create(dPointer));
                break;
            }
            case UBYTE: {
                Pointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), UByteIndexer.create((BytePointer)dPointer));
                break;
            }
            case BYTE: {
                Pointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), ByteIndexer.create((BytePointer)dPointer));
                break;
            }
            case UINT64: 
            case LONG: {
                Pointer dPointer = new LongPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), LongIndexer.create((LongPointer)dPointer));
                break;
            }
            case UINT32: 
            case INT: {
                Pointer dPointer = new IntPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), IntIndexer.create((IntPointer)dPointer));
                break;
            }
            case UINT16: {
                Pointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), UShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case SHORT: {
                Pointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), ShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case BFLOAT16: 
            case HALF: {
                Pointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), HalfIndexer.create((ShortPointer)dPointer));
                break;
            }
            case FLOAT: {
                Pointer dPointer = new FloatPointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), FloatIndexer.create((FloatPointer)dPointer));
                break;
            }
            case DOUBLE: {
                Pointer dPointer = new DoublePointer(dataPointer.limit() / (long)dataBufferElementSize);
                long perfX = PerformanceTracker.getInstance().helperStartTransaction();
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), DoubleIndexer.create((DoublePointer)dPointer));
            }
        }
        INDArray ret = Nd4j.create(data, Shape.shape(shapeBuffer), Shape.strideArr(shapeBuffer), 0L, Shape.order(shapeBuffer));
        Nd4j.getAffinityManager().tagLocation(ret, AffinityManager.Location.DEVICE);
        return ret;
    }

    @Override
    public INDArray createFromNpyHeaderPointer(Pointer pointer) {
        DataType dtype = DataType.fromInt(this.nativeOps.dataTypeFromNpyHeader(pointer));
        Pointer dataPointer = this.nativeOps.dataPointForNumpyHeader(pointer);
        int dataBufferElementSize = this.nativeOps.elementSizeForNpyArrayHeader(pointer);
        DataBuffer data = null;
        Pointer shapeBufferPointer = this.nativeOps.shapeBufferForNumpyHeader(pointer);
        int length = this.nativeOps.lengthForShapeBufferPointer(shapeBufferPointer);
        shapeBufferPointer.capacity(8 * length);
        shapeBufferPointer.limit(8 * length);
        shapeBufferPointer.position(0L);
        LongPointer intPointer = new LongPointer(shapeBufferPointer);
        LongPointer newPointer = new LongPointer((long)length);
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        Pointer.memcpy(newPointer, intPointer, shapeBufferPointer.limit());
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfD, shapeBufferPointer.limit(), MemcpyDirection.HOST_TO_HOST);
        DataBuffer shapeBuffer = Nd4j.createBuffer((Pointer)newPointer, DataType.LONG, (long)length, LongIndexer.create(newPointer));
        dataPointer.position(0L);
        dataPointer.limit((long)dataBufferElementSize * Shape.length(shapeBuffer));
        dataPointer.capacity((long)dataBufferElementSize * Shape.length(shapeBuffer));
        long perfX = PerformanceTracker.getInstance().helperStartTransaction();
        switch (dtype) {
            case BYTE: {
                Pointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), ByteIndexer.create(dPointer));
                break;
            }
            case SHORT: {
                Pointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), ShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case INT: {
                Pointer dPointer = new IntPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), IntIndexer.create((IntPointer)dPointer));
                break;
            }
            case LONG: {
                Pointer dPointer = new LongPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), LongIndexer.create((LongPointer)dPointer));
                break;
            }
            case UBYTE: {
                Pointer dPointer = new BytePointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), UByteIndexer.create(dPointer));
                break;
            }
            case UINT16: {
                Pointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), UShortIndexer.create((ShortPointer)dPointer));
                break;
            }
            case UINT32: {
                Pointer dPointer = new IntPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), IntIndexer.create((IntPointer)dPointer));
                break;
            }
            case UINT64: {
                Pointer dPointer = new LongPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), LongIndexer.create((LongPointer)dPointer));
                break;
            }
            case HALF: {
                Pointer dPointer = new ShortPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), HalfIndexer.create((ShortPointer)dPointer));
                break;
            }
            case FLOAT: {
                Pointer dPointer = new FloatPointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), FloatIndexer.create((FloatPointer)dPointer));
                break;
            }
            case DOUBLE: {
                Pointer dPointer = new DoublePointer(dataPointer.limit() / (long)dataBufferElementSize);
                Pointer.memcpy(dPointer, dataPointer, dataPointer.limit());
                data = Nd4j.createBuffer(dPointer, dtype, Shape.length(shapeBuffer), DoubleIndexer.create((DoublePointer)dPointer));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type: [" + (Object)((Object)dtype) + "]");
            }
        }
        PerformanceTracker.getInstance().helperRegisterTransaction(0, perfX, dataPointer.limit(), MemcpyDirection.HOST_TO_HOST);
        INDArray ret = Nd4j.create(data, Shape.shape(shapeBuffer), Shape.strideArr(shapeBuffer), 0L, Shape.order(shapeBuffer));
        return ret;
    }

    @Override
    public INDArray createFromNpyFile(File file) {
        byte[] pathBytes = file.getAbsolutePath().getBytes(Charset.forName("UTF-8"));
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(pathBytes.length).order(ByteOrder.nativeOrder());
        directBuffer.put(pathBytes);
        ((Buffer)directBuffer).rewind();
        ((Buffer)directBuffer).position(0);
        Pointer pointer = this.nativeOps.numpyFromFile(new BytePointer(directBuffer));
        INDArray result = this.createFromNpyPointer(pointer);
        this.nativeOps.releaseNumpy(pointer);
        return result;
    }

    @Override
    public Map<String, INDArray> createFromNpzFile(File file) throws Exception {
        HashMap<String, INDArray> map = new HashMap<String, INDArray>();
        FileInputStream is = new FileInputStream(file);
        while (true) {
            Object[] d;
            DataType dt;
            int elemSize;
            int b;
            byte[] localHeader = new byte[30];
            ((InputStream)is).read(localHeader);
            if (localHeader[2] != 3 || localHeader[3] != 4) {
                if (!map.isEmpty()) break;
                throw new IllegalStateException("Found malformed NZP file header: File is not a npz file? " + file.getPath());
            }
            byte fNameLength = localHeader[26];
            byte[] fNameBytes = new byte[fNameLength];
            ((InputStream)is).read(fNameBytes);
            String fName = "";
            for (int i = 0; i < fNameLength - 4; ++i) {
                fName = fName + (char)fNameBytes[i];
            }
            byte extraFieldLength = localHeader[28];
            if (extraFieldLength > 0) {
                ((InputStream)is).read(new byte[extraFieldLength]);
            }
            ((InputStream)is).read(new byte[11]);
            String headerStr = "";
            while ((b = ((InputStream)is).read()) != 10) {
                headerStr = headerStr + (char)b;
            }
            int idx = headerStr.contains("<") ? headerStr.indexOf("'<") + 2 : headerStr.indexOf("'|") + 2;
            String typeStr = headerStr.substring(idx, idx + 2);
            if (typeStr.equals("f8")) {
                elemSize = 8;
                dt = DataType.DOUBLE;
            } else if (typeStr.equals("f4")) {
                elemSize = 4;
                dt = DataType.FLOAT;
            } else if (typeStr.equals("f2")) {
                elemSize = 2;
                dt = DataType.HALF;
            } else if (typeStr.equals("i8")) {
                elemSize = 8;
                dt = DataType.LONG;
            } else if (typeStr.equals("i4")) {
                elemSize = 4;
                dt = DataType.INT;
            } else if (typeStr.equals("i2")) {
                elemSize = 2;
                dt = DataType.SHORT;
            } else if (typeStr.equals("i1")) {
                elemSize = 1;
                dt = DataType.BYTE;
            } else if (typeStr.equals("u1")) {
                elemSize = 1;
                dt = DataType.UBYTE;
            } else {
                throw new Exception("Unsupported data type: " + typeStr);
            }
            idx = headerStr.indexOf("'fortran_order': ");
            char order = headerStr.charAt(idx + "'fortran_order': ".length()) == 'F' ? (char)'c' : 'f';
            String shapeStr = headerStr.substring(headerStr.indexOf("(") + 1, headerStr.indexOf(")"));
            shapeStr = shapeStr.replace(" ", "");
            String[] dims = shapeStr.split(",");
            long[] shape = new long[dims.length];
            long size = 1L;
            for (int i = 0; i < dims.length; ++i) {
                long d2;
                shape[i] = d2 = Long.parseLong(dims[i]);
                size *= d2;
            }
            int numBytes = (int)(size * (long)elemSize);
            byte[] data = new byte[numBytes];
            ((InputStream)is).read(data);
            ByteBuffer bb = ByteBuffer.wrap(data);
            if (dt == DataType.DOUBLE) {
                double[] doubleData = new double[(int)size];
                int i = 0;
                while ((long)i < size) {
                    long l = bb.getLong(8 * i);
                    l = Long.reverseBytes(l);
                    doubleData[i] = Double.longBitsToDouble(l);
                    ++i;
                }
                map.put(fName, Nd4j.create(doubleData, shape, order));
                continue;
            }
            if (dt == DataType.FLOAT) {
                float[] floatData = new float[(int)size];
                int i = 0;
                while ((long)i < size) {
                    float f;
                    int i2 = bb.getInt(4 * i);
                    i2 = Integer.reverseBytes(i2);
                    floatData[i] = f = Float.intBitsToFloat(i2);
                    ++i;
                }
                map.put(fName, Nd4j.create(floatData, shape, order));
                continue;
            }
            if (dt == DataType.HALF) {
                INDArray arr = Nd4j.create(DataType.HALF, size);
                ByteBuffer bb2 = arr.data().pointer().asByteBuffer();
                int i = 0;
                while ((long)i < size) {
                    short s = bb.getShort(2 * i);
                    bb2.put((byte)(s >> 8 & 0xFF));
                    bb2.put((byte)(s & 0xFF));
                    ++i;
                }
                Nd4j.getAffinityManager().tagLocation(arr, AffinityManager.Location.HOST);
                map.put(fName, arr.reshape(order, shape));
                continue;
            }
            if (dt == DataType.LONG) {
                d = new long[(int)size];
                int i = 0;
                while ((long)i < size) {
                    long l = bb.getLong(8 * i);
                    d[i] = l = Long.reverseBytes(l);
                    ++i;
                }
                map.put(fName, Nd4j.createFromArray(d).reshape(order, shape));
                continue;
            }
            if (dt == DataType.INT) {
                d = new int[(int)size];
                int i = 0;
                while ((long)i < size) {
                    int l = bb.getInt(4 * i);
                    l = Integer.reverseBytes(l);
                    d[i] = l;
                    ++i;
                }
                map.put(fName, Nd4j.createFromArray((int[])d).reshape(order, shape));
                continue;
            }
            if (dt == DataType.SHORT) {
                d = new short[(int)size];
                int i = 0;
                while ((long)i < size) {
                    short l = bb.getShort(2 * i);
                    l = Short.reverseBytes(l);
                    d[i] = l;
                    ++i;
                }
                map.put(fName, Nd4j.createFromArray((short[])d).reshape(order, shape));
                continue;
            }
            if (dt == DataType.BYTE) {
                map.put(fName, Nd4j.createFromArray(data).reshape(order, shape));
                continue;
            }
            if (dt != DataType.UBYTE) continue;
            d = new short[(int)size];
            int i = 0;
            while ((long)i < size) {
                short l = (short)(bb.get(i) & 0xFF);
                d[i] = l;
                ++i;
            }
            map.put(fName, Nd4j.createFromArray((short[])d).reshape(order, shape).castTo(DataType.UBYTE));
        }
        return map;
    }

    public Map<String, INDArray> _createFromNpzFile(File file) throws Exception {
        byte[] pathBytes = file.getAbsolutePath().getBytes(Charset.forName("UTF-8"));
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(pathBytes.length).order(ByteOrder.nativeOrder());
        directBuffer.put(pathBytes);
        ((Buffer)directBuffer).rewind();
        ((Buffer)directBuffer).position(0);
        Pointer pointer = this.nativeOps.mapFromNpzFile(new BytePointer(directBuffer));
        int n = this.nativeOps.getNumNpyArraysInMap(pointer);
        HashMap<String, INDArray> map = new HashMap<String, INDArray>();
        for (int i = 0; i < n; ++i) {
            INDArray arr;
            DataBuffer data;
            Pointer dPointer;
            String arrName = this.nativeOps.getNpyArrayNameFromMap(pointer, i);
            Pointer arrPtr = this.nativeOps.getNpyArrayFromMap(pointer, i);
            int ndim = this.nativeOps.getNpyArrayRank(arrPtr);
            long[] shape = new long[ndim];
            LongPointer shapePtr = this.nativeOps.getNpyArrayShape(arrPtr);
            long length = 1L;
            for (int j = 0; j < ndim; ++j) {
                shape[j] = shapePtr.get(j);
                length *= shape[j];
            }
            int numBytes = this.nativeOps.getNpyArrayElemSize(arrPtr);
            int elemSize = numBytes * 8;
            char order = this.nativeOps.getNpyArrayOrder(arrPtr);
            Pointer dataPointer = this.nativeOps.dataPointForNumpyStruct(arrPtr);
            dataPointer.position(0L);
            long size = (long)elemSize * length;
            dataPointer.limit(size);
            dataPointer.capacity(size);
            if (elemSize == 32) {
                dPointer = new FloatPointer(dataPointer.limit() / (long)elemSize);
                data = Nd4j.createBuffer(dPointer, DataType.FLOAT, length, FloatIndexer.create(dPointer));
                arr = Nd4j.create(data, shape, Nd4j.getStrides(shape, order), 0L, order, DataType.FLOAT);
            } else if (elemSize == 64) {
                dPointer = new DoublePointer(dataPointer.limit() / (long)elemSize);
                data = Nd4j.createBuffer(dPointer, DataType.DOUBLE, length, DoubleIndexer.create((DoublePointer)dPointer));
                arr = Nd4j.create(data, shape, Nd4j.getStrides(shape, order), 0L, order, DataType.DOUBLE);
            } else {
                throw new Exception("Unsupported data type: " + String.valueOf(elemSize));
            }
            map.put(arrName, arr);
        }
        return map;
    }
}

