/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.systeminfo.GPUInfo;
import org.nd4j.systeminfo.GPUInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOpsGPUInfoProvider
implements GPUInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(NativeOpsGPUInfoProvider.class);

    @Override
    public List<GPUInfo> getGPUs() {
        NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        ArrayList<GPUInfo> gpus = new ArrayList<GPUInfo>();
        int nDevices = nativeOps.getAvailableDevices();
        if (nDevices > 0) {
            for (int i = 0; i < nDevices; ++i) {
                try {
                    String name = nativeOps.getDeviceName(i);
                    long total = nativeOps.getDeviceTotalMemory(i);
                    long free = nativeOps.getDeviceFreeMemory(i);
                    int major = nativeOps.getDeviceMajor(i);
                    int minor = nativeOps.getDeviceMinor(i);
                    gpus.add(new GPUInfo(name, total, free, major, minor));
                    continue;
                }
                catch (Exception e) {
                    log.warn("Can't add GPU", e);
                }
            }
        }
        return gpus;
    }
}

