/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class XavierInitScheme
extends BaseWeightInitScheme {
    private double fanIn;
    private double fanOut;

    public XavierInitScheme(char order, double fanIn, double fanOut) {
        super(order);
        this.fanIn = fanIn;
        this.fanOut = fanOut;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        return Nd4j.randn(dataType, this.order(), shape).muli(FastMath.sqrt(2.0 / (this.fanIn + this.fanOut)));
    }

    @Override
    public WeightInit type() {
        return WeightInit.XAVIER;
    }

    public static XavierInitSchemeBuilder builder() {
        return new XavierInitSchemeBuilder();
    }

    public static class XavierInitSchemeBuilder {
        private char order;
        private double fanIn;
        private double fanOut;

        XavierInitSchemeBuilder() {
        }

        public XavierInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public XavierInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public XavierInitSchemeBuilder fanOut(double fanOut) {
            this.fanOut = fanOut;
            return this;
        }

        public XavierInitScheme build() {
            return new XavierInitScheme(this.order, this.fanIn, this.fanOut);
        }

        public String toString() {
            return "XavierInitScheme.XavierInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ", fanOut=" + this.fanOut + ")";
        }
    }
}

