/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.COM.EnumWbemClassObject;
import oshi.jna.platform.windows.COM.WbemClassObject;
import oshi.jna.platform.windows.COM.WbemLocator;
import oshi.jna.platform.windows.COM.WbemServices;
import oshi.jna.platform.windows.Ole32;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;

public class WmiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WmiUtil.class);
    public static final String DEFAULT_NAMESPACE = "ROOT\\CIMV2";
    private static boolean comInitialized = false;
    private static boolean securityInitialized = false;
    private static final ValueType[] STRING_TYPE = new ValueType[]{ValueType.STRING};
    private static final ValueType[] UINT32_TYPE = new ValueType[]{ValueType.UINT32};
    private static final ValueType[] FLOAT_TYPE = new ValueType[]{ValueType.FLOAT};

    public static boolean hasNamespace(String namespace) {
        Map<String, List<String>> nsMap = WmiUtil.selectStringsFrom("ROOT", "__NAMESPACE", "Name", null);
        for (String s : nsMap.get("Name")) {
            if (!s.equals(namespace)) continue;
            return true;
        }
        return false;
    }

    public static Long selectUint32From(String namespace, String wmiClass, String property, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, property, wmiClass, whereClause, UINT32_TYPE);
        if (result.containsKey(property) && !result.get(property).isEmpty()) {
            return (Long)result.get(property).get(0);
        }
        return 0L;
    }

    public static Map<String, List<Long>> selectUint32sFrom(String namespace, String wmiClass, String properties, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, UINT32_TYPE);
        HashMap<String, List<Long>> longMap = new HashMap<String, List<Long>>();
        for (Map.Entry<String, List<Object>> entry : result.entrySet()) {
            ArrayList<Long> longList = new ArrayList<Long>();
            for (Object obj : entry.getValue()) {
                longList.add((Long)obj);
            }
            longMap.put(entry.getKey(), longList);
        }
        return longMap;
    }

    public static Float selectFloatFrom(String namespace, String wmiClass, String property, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, property, wmiClass, whereClause, FLOAT_TYPE);
        if (result.containsKey(property) && !result.get(property).isEmpty()) {
            return (Float)result.get(property).get(0);
        }
        return Float.valueOf(0.0f);
    }

    public static Map<String, List<Float>> selectFloatsFrom(String namespace, String wmiClass, String properties, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, FLOAT_TYPE);
        HashMap<String, List<Float>> floatMap = new HashMap<String, List<Float>>();
        for (Map.Entry<String, List<Object>> entry : result.entrySet()) {
            ArrayList<Float> floatList = new ArrayList<Float>();
            for (Object obj : entry.getValue()) {
                floatList.add((Float)obj);
            }
            floatMap.put(entry.getKey(), floatList);
        }
        return floatMap;
    }

    public static String selectStringFrom(String namespace, String wmiClass, String property, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, property, wmiClass, whereClause, STRING_TYPE);
        if (result.containsKey(property) && !result.get(property).isEmpty()) {
            return (String)result.get(property).get(0);
        }
        return "";
    }

    public static Map<String, List<String>> selectStringsFrom(String namespace, String wmiClass, String properties, String whereClause) {
        Map<String, List<Object>> result = WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, STRING_TYPE);
        HashMap<String, List<String>> strMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<Object>> entry : result.entrySet()) {
            ArrayList<String> strList = new ArrayList<String>();
            for (Object obj : entry.getValue()) {
                strList.add((String)obj);
            }
            strMap.put(entry.getKey(), strList);
        }
        return strMap;
    }

    public static Map<String, List<Object>> selectObjectsFrom(String namespace, String wmiClass, String properties, String whereClause, ValueType[] propertyTypes) {
        return WmiUtil.queryWMI(namespace == null ? DEFAULT_NAMESPACE : namespace, properties, wmiClass, whereClause, propertyTypes);
    }

    private static Map<String, List<Object>> queryWMI(String namespace, String properties, String wmiClass, String whereClause, ValueType[] propertyTypes) {
        PointerByReference pEnumerator;
        HashMap<String, List<Object>> values = new HashMap<String, List<Object>>();
        String[] props = properties.split(",");
        for (int i = 0; i < props.length; ++i) {
            if ("__PATH".equals(props[i])) {
                values.put(propertyTypes[i].name(), new ArrayList());
                continue;
            }
            values.put(props[i], new ArrayList());
        }
        if (!WmiUtil.initCOM()) {
            WmiUtil.unInitCOM();
            return values;
        }
        PointerByReference pSvc = new PointerByReference();
        if (!WmiUtil.connectServer(namespace, pSvc)) {
            WmiUtil.unInitCOM();
            return values;
        }
        WbemServices svc = new WbemServices(pSvc.getValue());
        if (!WmiUtil.selectProperties(svc, pEnumerator = new PointerByReference(), properties, wmiClass, whereClause)) {
            svc.Release();
            WmiUtil.unInitCOM();
            return values;
        }
        EnumWbemClassObject enumerator = new EnumWbemClassObject(pEnumerator.getValue());
        WmiUtil.enumerateProperties(values, enumerator, props, propertyTypes, svc);
        enumerator.Release();
        svc.Release();
        WmiUtil.unInitCOM();
        return values;
    }

    private static boolean initCOM() {
        WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeEx(null, 0);
        if (COMUtils.FAILED(hres)) {
            if (hres.intValue() == -2147417850) {
                LOG.debug("COM already initialized.");
                securityInitialized = true;
                return true;
            }
            LOG.error(String.format("Failed to initialize COM library. Error code = 0x%08x", hres.intValue()));
            return false;
        }
        comInitialized = true;
        if (securityInitialized) {
            return true;
        }
        hres = Ole32.INSTANCE.CoInitializeSecurity(null, new NativeLong(-1L), null, null, 0, 3, null, 0, null);
        if (COMUtils.FAILED(hres) && hres.intValue() != -2147417831) {
            LOG.error(String.format("Failed to initialize security. Error code = 0x%08x", hres.intValue()));
            Ole32.INSTANCE.CoUninitialize();
            return false;
        }
        securityInitialized = true;
        return true;
    }

    private static boolean connectServer(String namespace, PointerByReference pSvc) {
        WbemLocator loc = WbemLocator.create();
        if (loc == null) {
            return false;
        }
        WinNT.HRESULT hres = loc.ConnectServer(new WTypes.BSTR(namespace), null, null, null, null, null, null, pSvc);
        if (COMUtils.FAILED(hres)) {
            LOG.error(String.format("Could not connect to namespace %s. Error code = 0x%08x", namespace, hres.intValue()));
            loc.Release();
            WmiUtil.unInitCOM();
            return false;
        }
        LOG.debug("Connected to {} WMI namespace", (Object)namespace);
        loc.Release();
        hres = Ole32.INSTANCE.CoSetProxyBlanket(pSvc.getValue(), 10, 0, null, 3, 3, null, 0);
        if (COMUtils.FAILED(hres)) {
            LOG.error(String.format("Could not set proxy blanket. Error code = 0x%08x", hres.intValue()));
            new WbemServices(pSvc.getValue()).Release();
            WmiUtil.unInitCOM();
            return false;
        }
        return true;
    }

    private static boolean selectProperties(WbemServices svc, PointerByReference pEnumerator, String properties, String wmiClass, String whereClause) {
        String query = String.format("SELECT %s FROM %s %s", properties, wmiClass, whereClause != null ? whereClause : "");
        LOG.debug("Query: {}", (Object)query);
        WinNT.HRESULT hres = svc.ExecQuery(new WTypes.BSTR("WQL"), new WTypes.BSTR(query), new NativeLong(48L), null, pEnumerator);
        if (COMUtils.FAILED(hres)) {
            LOG.error(String.format("Query '%s' failed. Error code = 0x%08x", query, hres.intValue()));
            svc.Release();
            WmiUtil.unInitCOM();
            return false;
        }
        return true;
    }

    private static void enumerateProperties(Map<String, List<Object>> values, EnumWbemClassObject enumerator, String[] properties, ValueType[] propertyTypes, WbemServices svc) {
        if (propertyTypes.length > 1 && properties.length != propertyTypes.length) {
            throw new IllegalArgumentException("Property type array size must be 1 or equal to properties array size.");
        }
        PointerByReference pclsObj = new PointerByReference();
        LongByReference uReturn = new LongByReference(0L);
        while (enumerator.getPointer() != Pointer.NULL) {
            WinNT.HRESULT hres = enumerator.Next(new NativeLong(-1L), new NativeLong(1L), pclsObj, uReturn);
            if (0L == uReturn.getValue() || COMUtils.FAILED(hres)) {
                return;
            }
            Variant.VARIANT.ByReference vtProp = new Variant.VARIANT.ByReference();
            WbemClassObject clsObj = new WbemClassObject(pclsObj.getValue());
            for (int p = 0; p < properties.length; ++p) {
                String property = properties[p];
                hres = clsObj.Get(new WTypes.BSTR(property), new NativeLong(0L), vtProp, null, null);
                ValueType propertyType = propertyTypes.length > 1 ? propertyTypes[p] : propertyTypes[0];
                switch (propertyType) {
                    case STRING: {
                        values.get(property).add(vtProp.getValue() == null ? "unknown" : vtProp.stringValue());
                        break;
                    }
                    case UINT16: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : (long)vtProp.intValue());
                        break;
                    }
                    case UINT32: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : vtProp.longValue());
                        break;
                    }
                    case UINT64: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : ParseUtil.parseLongOrDefault(vtProp.stringValue(), 0L));
                        break;
                    }
                    case FLOAT: {
                        values.get(property).add(Float.valueOf(vtProp.getValue() == null ? 0.0f : vtProp.floatValue()));
                        break;
                    }
                    case DATETIME: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : ParseUtil.cimDateTimeToMillis(vtProp.stringValue()));
                        break;
                    }
                    case BOOLEAN: {
                        values.get(property).add(vtProp.getValue() == null ? (Constable)Long.valueOf(0L) : (Constable)Boolean.valueOf(vtProp.booleanValue()));
                        break;
                    }
                    case PROCESS_GETOWNER: {
                        String owner = FormatUtil.join((CharSequence)"\\", WmiUtil.execMethod(svc, vtProp.stringValue(), "GetOwner", "Domain", "User"));
                        values.get(propertyType.name()).add("\\".equals(owner) ? "N/A" : owner);
                        break;
                    }
                    case PROCESS_GETOWNERSID: {
                        String[] ownerSid = WmiUtil.execMethod(svc, vtProp.stringValue(), "GetOwnerSid", "Sid");
                        values.get(propertyType.name()).add(ownerSid.length < 1 ? "" : ownerSid[0]);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unimplemented enum type: " + propertyType.toString());
                    }
                }
                OleAuto.INSTANCE.VariantClear(vtProp);
            }
            clsObj.Release();
        }
    }

    private static void unInitCOM() {
        if (comInitialized) {
            Ole32.INSTANCE.CoUninitialize();
            comInitialized = false;
        }
    }

    private static String[] execMethod(WbemServices svc, String clsObj, String method, String ... properties) {
        ArrayList<String> result = new ArrayList<String>();
        PointerByReference ppOutParams = new PointerByReference();
        WinNT.HRESULT hres = svc.ExecMethod(new WTypes.BSTR(clsObj), new WTypes.BSTR(method), new NativeLong(0L), null, null, ppOutParams, null);
        if (COMUtils.FAILED(hres)) {
            return new String[0];
        }
        WbemClassObject obj = new WbemClassObject(ppOutParams.getValue());
        Variant.VARIANT.ByReference vtProp = new Variant.VARIANT.ByReference();
        for (String prop : properties) {
            hres = obj.Get(new WTypes.BSTR(prop), new NativeLong(0L), vtProp, null, null);
            if (COMUtils.FAILED(hres)) continue;
            result.add(vtProp.getValue() == null ? "" : vtProp.stringValue());
        }
        obj.Release();
        return result.toArray(new String[result.size()]);
    }

    public static enum ValueType {
        STRING,
        UINT32,
        FLOAT,
        DATETIME,
        BOOLEAN,
        UINT64,
        UINT16,
        PROCESS_GETOWNER,
        PROCESS_GETOWNERSID;

    }
}

