/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceUpdate;

public class DeviceReference {
    public final int deviceNumber;
    public final InetAddress address;
    private static final Map<InetAddress, Map<Integer, DeviceReference>> instances = new HashMap<InetAddress, Map<Integer, DeviceReference>>();

    private DeviceReference(int number, InetAddress addr) {
        this.deviceNumber = number;
        this.address = addr;
    }

    public static synchronized DeviceReference getDeviceReference(int number, InetAddress address) {
        DeviceReference result;
        Map<Integer, DeviceReference> playerMap = instances.get(address);
        if (playerMap == null) {
            playerMap = new HashMap<Integer, DeviceReference>();
            instances.put(address, playerMap);
        }
        if ((result = playerMap.get(number)) == null) {
            result = new DeviceReference(number, address);
            playerMap.put(number, result);
        }
        return result;
    }

    public static DeviceReference getDeviceReference(DeviceAnnouncement announcement) {
        return DeviceReference.getDeviceReference(announcement.getDeviceNumber(), announcement.getAddress());
    }

    public static DeviceReference getDeviceReference(DeviceUpdate update) {
        return DeviceReference.getDeviceReference(update.deviceNumber, update.address);
    }

    public String toString() {
        return "DeckReference[deviceNumber:" + this.deviceNumber + ", address:" + this.address + "]";
    }
}

