/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.util.HashMap;
import java.util.Map;

public class DeckReference {
    public final int player;
    public final int hotCue;
    private static final Map<Integer, Map<Integer, DeckReference>> instances = new HashMap<Integer, Map<Integer, DeckReference>>();

    private DeckReference(int player, int hotCue) {
        this.player = player;
        this.hotCue = hotCue;
    }

    public static synchronized DeckReference getDeckReference(int player, int hotCue) {
        DeckReference result;
        Map<Integer, DeckReference> playerMap = instances.get(player);
        if (playerMap == null) {
            playerMap = new HashMap<Integer, DeckReference>();
            instances.put(player, playerMap);
        }
        if ((result = playerMap.get(hotCue)) == null) {
            result = new DeckReference(player, hotCue);
            playerMap.put(hotCue, result);
        }
        return result;
    }

    public String toString() {
        return "DeckReference[player:" + this.player + ", hotCue:" + this.hotCue + "]";
    }
}

