/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.deepsymmetry.beatlink.dbserver.StringField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuLoader {
    private static final Logger logger = LoggerFactory.getLogger(MenuLoader.class);
    private static final MenuLoader ourInstance = new MenuLoader();

    public List<Message> requestRootMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        MediaDetails details = MetadataFinder.getInstance().getMediaDetailsFor(slotReference);
                        CdjStatus.TrackType mediaType = details == null ? CdjStatus.TrackType.REKORDBOX : details.mediaType;
                        Message response = client.menuRequestTyped(Message.KnownType.ROOT_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, mediaType, new NumberField(sortOrder), new NumberField(0xFFFFFFL));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, mediaType, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting root menu");
    }

    public List<Message> requestPlaylistMenuFrom(SlotReference slotReference, int sortOrder) throws Exception {
        return MetadataFinder.getInstance().requestPlaylistItemsFrom(slotReference.player, slotReference.slot, sortOrder, 0, true);
    }

    public List<Message> requestHistoryMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting History menu.");
                        Message response = client.menuRequest(Message.KnownType.HISTORY_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting history menu");
    }

    public List<Message> requestHistoryPlaylistFrom(final SlotReference slotReference, final int sortOrder, final int historyId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting History playlist.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_HISTORY_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(historyId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting history playlist");
    }

    public List<Message> requestTrackMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            @Override
            public List<Message> useClient(Client client) throws Exception {
                return MetadataFinder.getInstance().getFullTrackList(slotReference.slot, client, sortOrder);
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting track menu");
    }

    public List<Message> requestArtistMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Artist menu.");
                        Message response = client.menuRequest(Message.KnownType.ARTIST_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist menu");
    }

    public List<Message> requestArtistAlbumMenuFrom(final SlotReference slotReference, final int sortOrder, final int artistId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Artist Album menu.");
                        Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_ARTIST_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album menu");
    }

    public List<Message> requestArtistAlbumTrackMenuFrom(final SlotReference slotReference, final int sortOrder, final int artistId, final int albumId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Artist Album Track menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId), new NumberField(albumId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album tracks menu");
    }

    public List<Message> requestOriginalArtistMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Original Artist menu.");
                        Message response = client.menuRequest(Message.KnownType.ORIGINAL_ARTIST_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist menu");
    }

    public List<Message> requestOriginalArtistAlbumMenuFrom(final SlotReference slotReference, final int sortOrder, final int artistId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Original Artist Album menu.");
                        Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_ORIGINAL_ARTIST_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album menu");
    }

    public List<Message> requestOriginalArtistAlbumTrackMenuFrom(final SlotReference slotReference, final int sortOrder, final int artistId, final int albumId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Original Artist Album Track menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_ORIGINAL_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId), new NumberField(albumId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album tracks menu");
    }

    public List<Message> requestRemixerMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Remixer menu.");
                        Message response = client.menuRequest(Message.KnownType.REMIXER_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist menu");
    }

    public List<Message> requestRemixerAlbumMenuFrom(final SlotReference slotReference, final int sortOrder, final int artistId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Remixer Album menu.");
                        Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_REMIXER_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album menu");
    }

    public List<Message> requestRemixerAlbumTrackMenuFrom(final SlotReference slotReference, final int sortOrder, final int artistId, final int albumId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Remixer Album Track menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_REMIXER_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(artistId), new NumberField(albumId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting artist album tracks menu");
    }

    public List<Message> requestAlbumTrackMenuFrom(final SlotReference slotReference, final int sortOrder, final int albumId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Album Track menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_ALBUM_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(albumId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting album tracks menu");
    }

    public List<Message> requestGenreMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Genre menu.");
                        Message response = client.menuRequest(Message.KnownType.GENRE_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre menu");
    }

    public List<Message> requestGenreArtistMenuFrom(final SlotReference slotReference, final int sortOrder, final int genreId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Genre Artist menu.");
                        Message response = client.menuRequest(Message.KnownType.ARTIST_MENU_FOR_GENRE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(genreId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artists menu");
    }

    public List<Message> requestGenreArtistAlbumMenuFrom(final SlotReference slotReference, final int sortOrder, final int genreId, final int artistId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Genre Artist Album menu.");
                        Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_GENRE_AND_ARTIST, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(genreId), new NumberField(artistId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist albums menu");
    }

    public List<Message> requestGenreArtistAlbumTrackMenuFrom(final SlotReference slotReference, final int sortOrder, final int genreId, final int artistId, final int albumId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Genre Artist Album Track menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_GENRE_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(genreId), new NumberField(artistId), new NumberField(albumId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist album tracks menu");
    }

    public List<Message> requestLabelMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Label menu.");
                        Message response = client.menuRequest(Message.KnownType.LABEL_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre menu");
    }

    public List<Message> requestLabelArtistMenuFrom(final SlotReference slotReference, final int sortOrder, final int labelId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Genre Artist menu.");
                        Message response = client.menuRequest(Message.KnownType.ARTIST_MENU_FOR_LABEL_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(labelId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artists menu");
    }

    public List<Message> requestLabelArtistAlbumMenuFrom(final SlotReference slotReference, final int sortOrder, final int labelId, final int artistId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Genre Artist Album menu.");
                        Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_FOR_LABEL_AND_ARTIST, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(labelId), new NumberField(artistId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist albums menu");
    }

    public List<Message> requestLabelArtistAlbumTrackMenuFrom(final SlotReference slotReference, final int sortOrder, final int labelId, final int artistId, final int albumId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Genre Artist Album Track menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_LABEL_ARTIST_AND_ALBUM, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(labelId), new NumberField(artistId), new NumberField(albumId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre artist album tracks menu");
    }

    public List<Message> requestAlbumMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Album menu.");
                        Message response = client.menuRequest(Message.KnownType.ALBUM_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting album menu");
    }

    public List<Message> requestKeyMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Key menu.");
                        Message response = client.menuRequest(Message.KnownType.KEY_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting key menu");
    }

    public List<Message> requestKeyNeighborMenuFrom(final SlotReference slotReference, final int sortOrder, final int keyId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.NEIGHBOR_MENU_FOR_KEY, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(keyId));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting key neighbor menu");
    }

    public List<Message> requestTracksByKeyAndDistanceFrom(final SlotReference slotReference, final int sortOrder, final int keyId, final int distance) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_KEY_AND_DISTANCE, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(keyId), new NumberField(distance));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by key and distance menu");
    }

    public List<Message> requestBpmMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting BPM menu.");
                        Message response = client.menuRequest(Message.KnownType.BPM_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting BPM menu");
    }

    public List<Message> requestBpmRangeMenuFrom(final SlotReference slotReference, final int sortOrder, final int bpm) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting tempo neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.BPM_RANGE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(bpm));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tempo range menu");
    }

    public List<Message> requestTracksByBpmRangeFrom(final SlotReference slotReference, final int sortOrder, final int bpm, final int range) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting tempo neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_BPM_AND_DISTANCE, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(bpm), new NumberField(range));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks within tempo range menu");
    }

    public List<Message> requestRatingMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Rating menu.");
                        Message response = client.menuRequest(Message.KnownType.RATING_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting rating menu");
    }

    public List<Message> requestTracksByRatingFrom(final SlotReference slotReference, final int sortOrder, final int rating) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_RATING_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(rating));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by rating menu");
    }

    public List<Message> requestColorMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Rating menu.");
                        Message response = client.menuRequest(Message.KnownType.COLOR_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting color menu");
    }

    public List<Message> requestTracksByColorFrom(final SlotReference slotReference, final int sortOrder, final int color) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_COLOR_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(color));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by color menu");
    }

    public List<Message> requestTimeMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Rating menu.");
                        Message response = client.menuRequest(Message.KnownType.TIME_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting time menu");
    }

    public List<Message> requestTracksByTimeFrom(final SlotReference slotReference, final int sortOrder, final int time) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_TIME_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(time));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by time menu");
    }

    public List<Message> requestBitRateMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Label menu.");
                        Message response = client.menuRequest(Message.KnownType.BIT_RATE_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting genre menu");
    }

    public List<Message> requestTracksByBitRateFrom(final SlotReference slotReference, final int sortOrder, final int bitRate) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_BIT_RATE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(bitRate));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by time menu");
    }

    public List<Message> requestYearMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Rating menu.");
                        Message response = client.menuRequest(Message.KnownType.YEAR_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting year menu");
    }

    public List<Message> requestYearsByDecadeFrom(final SlotReference slotReference, final int sortOrder, final int decade) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.YEAR_MENU_FOR_DECADE_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(decade));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting years by decade menu");
    }

    public List<Message> requestTracksByDecadeAndYear(final SlotReference slotReference, final int sortOrder, final int decade, final int year) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting key neighbor menu.");
                        Message response = client.menuRequest(Message.KnownType.TRACK_MENU_FOR_DECADE_YEAR_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder), new NumberField(decade), new NumberField(year));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting tracks by decade and year menu");
    }

    public List<Message> requestFilenameMenuFrom(final SlotReference slotReference, final int sortOrder) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Rating menu.");
                        Message response = client.menuRequest(Message.KnownType.FILENAME_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, new NumberField(sortOrder));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.REKORDBOX, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting filename menu");
    }

    public List<Message> requestFolderMenuFrom(final SlotReference slotReference, final int sortOrder, final int folderId) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> useClient(Client client) throws Exception {
                if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
                    try {
                        logger.debug("Requesting Key menu.");
                        Message response = client.menuRequestTyped(Message.KnownType.FOLDER_MENU_REQ, Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.UNANALYZED, new NumberField(sortOrder), new NumberField(folderId), new NumberField(0xFFFFFFL));
                        List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slotReference.slot, CdjStatus.TrackType.UNANALYZED, response);
                        return list;
                    }
                    finally {
                        client.unlockForMenuOperations();
                    }
                }
                throw new TimeoutException("Unable to lock player for menu operations.");
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(slotReference.player, task, "requesting folder menu");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> getSearchItems(CdjStatus.TrackSourceSlot slot, int sortOrder, String text, AtomicInteger count, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                StringField textField = new StringField(text);
                Message response = client.menuRequest(Message.KnownType.SEARCH_MENU, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder), new NumberField(textField.getSize()), textField, NumberField.WORD_0);
                int actualCount = (int)response.getMenuResultsCount();
                if ((long)actualCount == 0xFFFFFFFFL || actualCount == 0) {
                    if (count != null) {
                        count.set(0);
                    }
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                if (count == null) {
                    List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, response);
                    return list;
                }
                int desiredCount = Math.min(count.get(), actualCount);
                count.set(actualCount);
                if (desiredCount < 1) {
                    List<Message> list = Collections.emptyList();
                    return list;
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, 0, desiredCount);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock player for menu operations.");
    }

    public List<Message> requestSearchResultsFrom(int player, final CdjStatus.TrackSourceSlot slot, final int sortOrder, final String text, final AtomicInteger count) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            @Override
            public List<Message> useClient(Client client) throws Exception {
                return MenuLoader.this.getSearchItems(slot, sortOrder, text.toUpperCase(), count, client);
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(player, task, "performing search");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> getMoreSearchItems(CdjStatus.TrackSourceSlot slot, int sortOrder, String text, int offset, int count, Client client) throws IOException, InterruptedException, TimeoutException {
        if (client.tryLockingForMenuOperations(20L, TimeUnit.SECONDS)) {
            try {
                StringField textField = new StringField(text);
                Message response = client.menuRequest(Message.KnownType.SEARCH_MENU, Message.MenuIdentifier.MAIN_MENU, slot, new NumberField(sortOrder), new NumberField(textField.getSize()), textField, NumberField.WORD_0);
                int actualCount = (int)response.getMenuResultsCount();
                if (offset + count > actualCount) {
                    throw new IllegalArgumentException("Cannot request items past the end of the menu.");
                }
                List<Message> list = client.renderMenuItems(Message.MenuIdentifier.MAIN_MENU, slot, CdjStatus.TrackType.REKORDBOX, offset, count);
                return list;
            }
            finally {
                client.unlockForMenuOperations();
            }
        }
        throw new TimeoutException("Unable to lock player for menu operations.");
    }

    public List<Message> requestMoreSearchResultsFrom(int player, final CdjStatus.TrackSourceSlot slot, final int sortOrder, final String text, final int offset, final int count) throws Exception {
        ConnectionManager.ClientTask<List<Message>> task = new ConnectionManager.ClientTask<List<Message>>(){

            @Override
            public List<Message> useClient(Client client) throws Exception {
                return MenuLoader.this.getMoreSearchItems(slot, sortOrder, text.toUpperCase(), offset, count, client);
            }
        };
        return ConnectionManager.getInstance().invokeWithClientSession(player, task, "performing search");
    }

    public static MenuLoader getInstance() {
        return ourInstance;
    }

    private MenuLoader() {
    }
}

