/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import org.deepsymmetry.beatlink.data.BeatGrid;

public class TrackPositionUpdate {
    public final long timestamp;
    public final long milliseconds;
    public final int beatNumber;
    public final boolean definitive;
    public final boolean precise;
    public final boolean fromBeat;
    public final boolean playing;
    public final double pitch;
    public final boolean reverse;
    public final BeatGrid beatGrid;

    public int getBeatWithinBar() {
        if (this.beatGrid != null) {
            return this.beatGrid.getBeatWithinBar(this.beatNumber);
        }
        return 0;
    }

    public TrackPositionUpdate(long timestamp, long milliseconds, int beatNumber, boolean definitive, boolean playing, double pitch, boolean reverse, BeatGrid beatGrid) {
        this(timestamp, milliseconds, beatNumber, definitive, playing, pitch, reverse, beatGrid, false, false);
    }

    public TrackPositionUpdate(long timestamp, long milliseconds, int beatNumber, boolean definitive, boolean playing, double pitch, boolean reverse, BeatGrid beatGrid, boolean precise, boolean fromBeat) {
        this.timestamp = timestamp;
        this.milliseconds = milliseconds;
        this.beatNumber = beatNumber;
        this.definitive = definitive;
        this.playing = playing;
        this.pitch = pitch;
        this.reverse = reverse;
        this.beatGrid = beatGrid;
        this.precise = precise;
        this.fromBeat = fromBeat;
    }

    public String toString() {
        return "TrackPositionUpdate[timestamp:" + this.timestamp + ", milliseconds:" + this.milliseconds + ", beatNumber:" + this.beatNumber + ", definitive:" + this.definitive + ", playing:" + this.playing + ", pitch:" + String.format("%.2f", this.pitch) + ", reverse:" + this.reverse + ", beatGrid:" + this.beatGrid + ", precise:" + this.precise + ", fromBeat:" + this.fromBeat + "]";
    }
}

