/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.MediaDetails;
import org.deepsymmetry.beatlink.data.AlbumArt;
import org.deepsymmetry.beatlink.data.AlbumArtListener;
import org.deepsymmetry.beatlink.data.AlbumArtUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.DeckReference;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.MountListener;
import org.deepsymmetry.beatlink.data.SlotReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Client;
import org.deepsymmetry.beatlink.dbserver.ConnectionManager;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.beatlink.dbserver.NumberField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(ArtFinder.class);
    private final Map<DeckReference, AlbumArt> hotCache = new ConcurrentHashMap<DeckReference, AlbumArt>();
    private final LinkedBlockingDeque<TrackMetadataUpdate> pendingUpdates = new LinkedBlockingDeque(100);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            logger.debug("Received metadata update {}", (Object)update);
            if (!ArtFinder.this.pendingUpdates.offerLast(update)) {
                logger.warn("Discarding metadata update because our queue is backed up.");
            }
        }
    };
    private final MountListener mountListener = new MountListener(){

        @Override
        public void mediaMounted(SlotReference slot) {
            logger.debug("ArtFinder doesn't yet need to do anything in response to a media mount.");
        }

        @Override
        public void mediaUnmounted(SlotReference slot) {
            HashSet keys = new HashSet(ArtFinder.this.artCache.keySet());
            for (DataReference artReference : keys) {
                if (SlotReference.getSlotReference(artReference) != slot) continue;
                logger.debug("Evicting cached artwork in response to unmount report {}", (Object)artReference);
                ArtFinder.this.removeArtFromCache(artReference);
            }
            HashSet copy = new HashSet(ArtFinder.this.hotCache.entrySet());
            for (Map.Entry entry : copy) {
                if (slot != SlotReference.getSlotReference(((AlbumArt)entry.getValue()).artReference)) continue;
                logger.debug("Evicting hot cached artwork in response to unmount report {}", entry.getValue());
                ArtFinder.this.hotCache.remove(entry.getKey());
            }
        }
    };
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for ArtFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            logger.info("Clearing artwork in response to the loss of a device, {}", (Object)announcement);
            ArtFinder.this.clearArt(announcement);
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread queueHandler;
    public static final int DEFAULT_ART_CACHE_SIZE = 100;
    private final ConcurrentHashMap<DataReference, AlbumArt> artCache = new ConcurrentHashMap();
    private final LinkedList<DataReference> artCacheEvictionQueue = new LinkedList();
    private final HashSet<DataReference> artCacheRecentlyUsed = new HashSet();
    private final AtomicInteger artCacheSize = new AtomicInteger(100);
    private final AtomicBoolean requestHighResolutionArt = new AtomicBoolean(true);
    private final Set<Integer> activeRequests = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<AlbumArtListener> artListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The ArtFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (ArtFinder.this.isRunning()) {
                logger.info("ArtFinder stopping because {} has.", (Object)sender);
                ArtFinder.this.stop();
            }
        }
    };
    private static final ArtFinder ourInstance = new ArtFinder();

    private synchronized void removeArtFromCache(DataReference artReference) {
        this.artCache.remove(artReference);
        this.artCacheRecentlyUsed.remove(artReference);
        this.artCacheEvictionQueue.remove(artReference);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private void clearDeck(TrackMetadataUpdate update) {
        if (this.hotCache.remove(DeckReference.getDeckReference(update.player, 0)) != null) {
            this.deliverAlbumArtUpdate(update.player, null);
        }
    }

    private void clearArt(DeviceAnnouncement announcement) {
        int player = announcement.getDeviceNumber();
        for (DeckReference deck : new HashSet<DeckReference>(this.hotCache.keySet())) {
            if (deck.player != player) continue;
            this.hotCache.remove(deck);
            if (deck.hotCue != 0) continue;
            this.deliverAlbumArtUpdate(player, null);
        }
        for (DataReference art : new HashSet(this.artCache.keySet())) {
            if (art.player != player) continue;
            this.removeArtFromCache(art);
        }
    }

    private void updateArt(TrackMetadataUpdate update, AlbumArt art) {
        this.hotCache.put(DeckReference.getDeckReference(update.player, 0), art);
        if (update.metadata.getCueList() != null) {
            for (CueList.Entry entry : update.metadata.getCueList().entries) {
                if (entry.hotCueNumber == 0) continue;
                this.hotCache.put(DeckReference.getDeckReference(update.player, entry.hotCueNumber), art);
            }
        }
        this.deliverAlbumArtUpdate(update.player, art);
    }

    public Map<DeckReference, AlbumArt> getLoadedArt() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<DeckReference, AlbumArt>(this.hotCache));
    }

    public AlbumArt getLatestArtFor(int player) {
        this.ensureRunning();
        return this.hotCache.get(DeckReference.getDeckReference(player, 0));
    }

    public AlbumArt getLatestArtFor(DeviceUpdate update) {
        return this.getLatestArtFor(update.getDeviceNumber());
    }

    public long getArtCacheSize() {
        return this.artCacheSize.get();
    }

    private void evictFromArtCache() {
        boolean evicted = false;
        while (!evicted && !this.artCacheEvictionQueue.isEmpty()) {
            DataReference candidate = this.artCacheEvictionQueue.removeFirst();
            if (this.artCacheRecentlyUsed.remove(candidate)) {
                this.artCacheEvictionQueue.addLast(candidate);
                continue;
            }
            this.artCache.remove(candidate);
            evicted = true;
        }
    }

    public synchronized void setArtCacheSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        this.artCacheSize.set(size);
        while (this.artCache.size() > size) {
            this.evictFromArtCache();
        }
    }

    public boolean getRequestHighResolutionArt() {
        return this.requestHighResolutionArt.get();
    }

    public void setRequestHighResolutionArt(boolean shouldRequest) {
        this.requestHighResolutionArt.set(shouldRequest);
    }

    private synchronized void addArtToCache(DataReference artReference, AlbumArt art) {
        while (this.artCache.size() >= this.artCacheSize.get()) {
            this.evictFromArtCache();
        }
        this.artCache.put(artReference, art);
        this.artCacheEvictionQueue.addLast(artReference);
    }

    private AlbumArt requestArtworkInternal(final DataReference artReference, final CdjStatus.TrackType trackType, boolean failIfPassive) {
        AlbumArt provided;
        MediaDetails sourceDetails = MetadataFinder.getInstance().getMediaDetailsFor(artReference.getSlotReference());
        if (sourceDetails != null && (provided = MetadataFinder.getInstance().allMetadataProviders.getAlbumArt(sourceDetails, artReference)) != null) {
            this.addArtToCache(artReference, provided);
            return provided;
        }
        if (MetadataFinder.getInstance().isPassive() && failIfPassive && artReference.slot != CdjStatus.TrackSourceSlot.COLLECTION) {
            return null;
        }
        ConnectionManager.ClientTask<AlbumArt> task = new ConnectionManager.ClientTask<AlbumArt>(){

            @Override
            public AlbumArt useClient(Client client) throws Exception {
                return ArtFinder.this.getArtwork(artReference.rekordboxId, SlotReference.getSlotReference(artReference), trackType, client);
            }
        };
        try {
            AlbumArt artwork = ConnectionManager.getInstance().invokeWithClientSession(artReference.player, task, "requesting artwork");
            if (artwork != null) {
                this.addArtToCache(artReference, artwork);
            }
            return artwork;
        }
        catch (Exception e) {
            logger.error("Problem requesting album art, returning null", (Throwable)e);
            return null;
        }
    }

    public AlbumArt requestArtworkFrom(DataReference artReference, CdjStatus.TrackType trackType) {
        this.ensureRunning();
        AlbumArt artwork = this.findArtInMemoryCaches(artReference);
        if (artwork == null) {
            artwork = this.requestArtworkInternal(artReference, trackType, false);
        }
        return artwork;
    }

    AlbumArt getArtwork(int artworkId, SlotReference slot, CdjStatus.TrackType trackType, Client client) throws IOException {
        Message response = this.getRequestHighResolutionArt() ? client.simpleRequest(Message.KnownType.ALBUM_ART_REQ, Message.KnownType.ALBUM_ART, client.buildRMST(Message.MenuIdentifier.DATA, slot.slot, trackType), new NumberField(artworkId), new NumberField(1L)) : client.simpleRequest(Message.KnownType.ALBUM_ART_REQ, Message.KnownType.ALBUM_ART, client.buildRMST(Message.MenuIdentifier.DATA, slot.slot, trackType), new NumberField(artworkId));
        return new AlbumArt(new DataReference(slot, artworkId), ((BinaryField)response.arguments.get(3)).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlbumArt findArtInMemoryCaches(DataReference artReference) {
        for (AlbumArt cached : this.hotCache.values()) {
            if (!cached.artReference.equals(artReference)) continue;
            return cached;
        }
        ArtFinder artFinder = this;
        synchronized (artFinder) {
            AlbumArt found = this.artCache.get(artReference);
            if (found != null) {
                this.artCacheRecentlyUsed.add(artReference);
            }
            return found;
        }
    }

    public void addAlbumArtListener(AlbumArtListener listener) {
        if (listener != null) {
            this.artListeners.add(listener);
        }
    }

    public void removeAlbumArtListener(AlbumArtListener listener) {
        if (listener != null) {
            this.artListeners.remove(listener);
        }
    }

    public Set<AlbumArtListener> getAlbumArtListeners() {
        return Collections.unmodifiableSet(new HashSet<AlbumArtListener>(this.artListeners));
    }

    private void deliverAlbumArtUpdate(int player, AlbumArt art) {
        if (!this.getAlbumArtListeners().isEmpty()) {
            AlbumArtUpdate update = new AlbumArtUpdate(player, art);
            for (AlbumArtListener listener : this.getAlbumArtListeners()) {
                try {
                    listener.albumArtChanged(update);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering album art update to listener", t);
                }
            }
        }
    }

    private void handleUpdate(final TrackMetadataUpdate update) {
        if (update.metadata == null || update.metadata.getArtworkId() == 0) {
            this.clearDeck(update);
        } else {
            AlbumArt lastArt = this.hotCache.get(DeckReference.getDeckReference(update.player, 0));
            final DataReference artReference = new DataReference(update.metadata.trackReference.player, update.metadata.trackReference.slot, update.metadata.getArtworkId());
            if (lastArt == null || !lastArt.artReference.equals(artReference)) {
                AlbumArt cached = this.findArtInMemoryCaches(artReference);
                if (cached != null) {
                    this.updateArt(update, cached);
                    return;
                }
                if (this.activeRequests.add(update.player)) {
                    this.clearDeck(update);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AlbumArt art = ArtFinder.this.requestArtworkInternal(artReference, update.metadata.trackType, true);
                                if (art != null) {
                                    ArtFinder.this.updateArt(update, art);
                                }
                            }
                            catch (Exception e) {
                                logger.warn("Problem requesting album art from update" + update, (Throwable)e);
                            }
                            finally {
                                ArtFinder.this.activeRequests.remove(update.player);
                            }
                        }
                    }).start();
                }
            }
        }
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            ConnectionManager.getInstance().addLifecycleListener(this.lifecycleListener);
            ConnectionManager.getInstance().start();
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            MetadataFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            MetadataFinder.getInstance().start();
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            MetadataFinder.getInstance().addMountListener(this.mountListener);
            this.queueHandler = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (ArtFinder.this.isRunning()) {
                        try {
                            ArtFinder.this.handleUpdate((TrackMetadataUpdate)ArtFinder.this.pendingUpdates.take());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
            this.running.set(true);
            this.queueHandler.start();
            this.deliverLifecycleAnnouncement(logger, true);
            for (Map.Entry<DeckReference, TrackMetadata> entry : MetadataFinder.getInstance().getLoadedTracks().entrySet()) {
                if (entry.getKey().hotCue != 0) continue;
                this.handleUpdate(new TrackMetadataUpdate(entry.getKey().player, entry.getValue()));
            }
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            this.running.set(false);
            this.pendingUpdates.clear();
            this.queueHandler.interrupt();
            this.queueHandler = null;
            final HashSet<DeckReference> dyingCache = new HashSet<DeckReference>(this.hotCache.keySet());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (DeckReference deck : dyingCache) {
                        if (deck.hotCue != 0) continue;
                        ArtFinder.this.deliverAlbumArtUpdate(deck.player, null);
                    }
                }
            });
            this.hotCache.clear();
            this.artCache.clear();
            this.artCacheRecentlyUsed.clear();
            this.artCacheEvictionQueue.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static ArtFinder getInstance() {
        return ourInstance;
    }

    private ArtFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArtFinder[running:").append(this.isRunning()).append(", passive:");
        sb.append(MetadataFinder.getInstance().isPassive()).append(", artCacheSize:").append(this.getArtCacheSize());
        if (this.isRunning()) {
            sb.append(", loadedArt:").append(this.getLoadedArt()).append(", cached art:").append(this.artCache.size());
        }
        return sb.append("]").toString();
    }
}

