/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import org.deepsymmetry.beatlink.data.SearchableItem;

public class ColorItem
extends SearchableItem {
    public final Color color;
    public final String colorName;

    public ColorItem(int id, String label) {
        super(id, label);
        this.color = ColorItem.colorForId(id);
        this.colorName = ColorItem.colorNameForId(id);
    }

    @Override
    public String toString() {
        return "ColorItem[id:" + this.id + ", label:" + this.label + ", colorName:" + this.colorName + ", color:" + this.color + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.color.hashCode();
        result = 31 * result + this.colorName.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ColorItem other = (ColorItem)obj;
        return other.id == this.id && other.label.equals(this.label) && other.colorName.equals(this.colorName) && other.color.equals(this.color);
    }

    public static boolean isNoColor(Color color) {
        return color.getAlpha() == 0;
    }

    public static Color colorForId(int colorId) {
        switch (colorId) {
            case 1: {
                return Color.PINK;
            }
            case 2: {
                return Color.RED;
            }
            case 3: {
                return Color.ORANGE;
            }
            case 4: {
                return Color.YELLOW;
            }
            case 5: {
                return Color.GREEN;
            }
            case 6: {
                return Color.CYAN;
            }
            case 7: {
                return Color.BLUE;
            }
            case 8: {
                return new Color(128, 0, 128);
            }
        }
        return new Color(0, 0, 0, 0);
    }

    public static String colorNameForId(int colorId) {
        switch (colorId) {
            case 0: {
                return "No Color";
            }
            case 1: {
                return "Pink";
            }
            case 2: {
                return "Red";
            }
            case 3: {
                return "Orange";
            }
            case 4: {
                return "Yellow";
            }
            case 5: {
                return "Green";
            }
            case 6: {
                return "Aqua";
            }
            case 7: {
                return "Blue";
            }
            case 8: {
                return "Purple";
            }
        }
        return "Unknown Color";
    }
}

