/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.data.SlotReference;

public class DataReference {
    public final int player;
    public final CdjStatus.TrackSourceSlot slot;
    public final int rekordboxId;
    private final int hash;

    public DataReference(int player, CdjStatus.TrackSourceSlot slot, int rekordboxId) {
        this.player = player;
        this.slot = slot;
        this.rekordboxId = rekordboxId;
        int scratch = 7;
        scratch = scratch * 31 + player;
        scratch = scratch * 31 + slot.hashCode();
        this.hash = scratch * 31 + rekordboxId;
    }

    public DataReference(SlotReference slot, int rekordboxId) {
        this(slot.player, slot.slot, rekordboxId);
    }

    public SlotReference getSlotReference() {
        return SlotReference.getSlotReference(this);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataReference) {
            DataReference other = (DataReference)obj;
            return other.player == this.player && other.slot == this.slot && other.rekordboxId == this.rekordboxId;
        }
        return false;
    }

    public String toString() {
        return "DataReference[player:" + this.player + ", slot:" + (Object)((Object)this.slot) + ", rekordboxId:" + this.rekordboxId + "]";
    }
}

