/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.deepsymmetry.beatlink.Beat;
import org.deepsymmetry.beatlink.BeatFinder;
import org.deepsymmetry.beatlink.BeatListener;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceAnnouncement;
import org.deepsymmetry.beatlink.DeviceAnnouncementListener;
import org.deepsymmetry.beatlink.DeviceFinder;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.LifecycleListener;
import org.deepsymmetry.beatlink.LifecycleParticipant;
import org.deepsymmetry.beatlink.PrecisePosition;
import org.deepsymmetry.beatlink.PrecisePositionListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackPositionBeatListener;
import org.deepsymmetry.beatlink.data.TrackPositionListener;
import org.deepsymmetry.beatlink.data.TrackPositionUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFinder
extends LifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(TimeFinder.class);
    private final ConcurrentHashMap<Integer, TrackPositionUpdate> positions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, DeviceUpdate> updates = new ConcurrentHashMap();
    private final DeviceAnnouncementListener announcementListener = new DeviceAnnouncementListener(){

        @Override
        public void deviceFound(DeviceAnnouncement announcement) {
            logger.debug("Currently nothing for TimeFinder to do when devices appear.");
        }

        @Override
        public void deviceLost(DeviceAnnouncement announcement) {
            logger.info("Clearing position information in response to the loss of a device, {}", (Object)announcement);
            TimeFinder.this.positions.remove(announcement.getDeviceNumber());
            TimeFinder.this.updates.remove(announcement.getDeviceNumber());
        }
    };
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ConcurrentHashMap<TrackPositionListener, TrackPositionUpdate> trackPositionListeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<TrackPositionListener, Integer> listenerPlayerNumbers = new ConcurrentHashMap();
    private final TrackPositionUpdate NO_INFORMATION = new TrackPositionUpdate(0L, 0L, 0, false, false, 0.0, false, null, false, false);
    private final AtomicLong slack = new AtomicLong(50L);
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            int device = update.getDeviceNumber();
            TrackPositionUpdate lastPosition = (TrackPositionUpdate)TimeFinder.this.positions.get(device);
            if (update instanceof CdjStatus && (lastPosition == null || !lastPosition.precise)) {
                TimeFinder.this.updates.put(device, update);
                BeatGrid beatGrid = BeatGridFinder.getInstance().getLatestBeatGridFor(update);
                int beatNumber = ((CdjStatus)update).getBeatNumber();
                if (beatGrid != null && beatNumber >= 0) {
                    boolean done = false;
                    while (!(done || lastPosition != null && lastPosition.timestamp >= update.getTimestamp())) {
                        TrackPositionUpdate newPosition;
                        if (lastPosition == null || lastPosition.beatGrid != beatGrid) {
                            long timeGuess = TimeFinder.this.timeOfBeat(beatGrid, beatNumber, update);
                            CueList.Entry likelyCue = TimeFinder.this.findAdjacentCue((CdjStatus)update, beatGrid);
                            if (likelyCue != null) {
                                timeGuess = likelyCue.cueTime;
                            }
                            newPosition = new TrackPositionUpdate(update.getTimestamp(), timeGuess, beatNumber, false, ((CdjStatus)update).isPlaying(), Util.pitchToMultiplier(update.getPitch()), ((CdjStatus)update).isPlayingBackwards(), beatGrid, false, false);
                        } else {
                            long newTime = TimeFinder.this.interpolateTimeFromUpdate(lastPosition, (CdjStatus)update, beatGrid);
                            boolean newReverse = ((CdjStatus)update).isPlayingBackwards();
                            boolean newPlaying = ((CdjStatus)update).isPlaying() && (!newReverse || newTime > 0L);
                            newPosition = new TrackPositionUpdate(update.getTimestamp(), newTime, beatNumber, false, newPlaying, Util.pitchToMultiplier(update.getPitch()), newReverse, beatGrid, false, false);
                        }
                        done = lastPosition == null ? TimeFinder.this.positions.putIfAbsent(device, newPosition) == null : TimeFinder.this.positions.replace(device, lastPosition, newPosition);
                        if (done) {
                            TimeFinder.this.updateListenersIfNeeded(device, newPosition, null);
                            continue;
                        }
                        lastPosition = (TrackPositionUpdate)TimeFinder.this.positions.get(device);
                    }
                } else {
                    TimeFinder.this.positions.remove(device);
                    TimeFinder.this.updateListenersIfNeeded(device, null, null);
                }
            }
        }
    };
    private final BeatListener beatListener = new BeatListener(){

        @Override
        public void newBeat(Beat beat) {
            int device = beat.getDeviceNumber();
            if (device < 16) {
                TimeFinder.this.updates.put(device, beat);
                BeatGrid beatGrid = BeatGridFinder.getInstance().getLatestBeatGridFor(beat);
                if (beatGrid != null) {
                    long farEnough;
                    TrackPositionUpdate lastPosition = (TrackPositionUpdate)TimeFinder.this.positions.get(device);
                    if (lastPosition == null || lastPosition.beatGrid != beatGrid) {
                        return;
                    }
                    long distanceIntoBeat = lastPosition.milliseconds - beatGrid.getTimeWithinTrack(lastPosition.beatNumber);
                    int beatNumber = distanceIntoBeat >= (farEnough = (long)(6000000 / beat.getBpm() / 5)) ? Math.min(lastPosition.beatNumber + 1, beatGrid.beatCount) : lastPosition.beatNumber;
                    TrackPositionUpdate newPosition = new TrackPositionUpdate(beat.getTimestamp(), TimeFinder.this.timeOfBeat(beatGrid, beatNumber, beat), beatNumber, true, true, Util.pitchToMultiplier(beat.getPitch()), false, beatGrid, lastPosition.precise, true);
                    TimeFinder.this.positions.put(device, newPosition);
                    TimeFinder.this.updateListenersIfNeeded(device, newPosition, beat);
                } else {
                    TimeFinder.this.positions.remove(device);
                    TimeFinder.this.updateListenersIfNeeded(device, null, beat);
                }
            }
        }
    };
    private final PrecisePositionListener positionListener = new PrecisePositionListener(){

        @Override
        public void positionReported(PrecisePosition position) {
            int device = position.getDeviceNumber();
            if (device < 16) {
                TimeFinder.this.updates.put(device, position);
                DeviceUpdate lastStatus = VirtualCdj.getInstance().getLatestStatusFor(device);
                boolean playing = lastStatus instanceof CdjStatus && ((CdjStatus)lastStatus).isPlaying();
                boolean reverse = lastStatus instanceof CdjStatus && ((CdjStatus)lastStatus).isPlayingBackwards();
                BeatGrid beatGrid = BeatGridFinder.getInstance().getLatestBeatGridFor(position);
                int beatNumber = beatGrid == null ? 0 : beatGrid.findBeatAtTime(position.getPlaybackPosition());
                TrackPositionUpdate newPosition = new TrackPositionUpdate(position.getTimestamp(), position.getPlaybackPosition(), beatNumber, true, playing, Util.pitchToMultiplier(position.getPitch()), reverse, beatGrid, true, false);
                TimeFinder.this.positions.put(device, newPosition);
                TimeFinder.this.updateListenersIfNeeded(device, newPosition, null);
            }
        }
    };
    private final LifecycleListener lifecycleListener = new LifecycleListener(){

        @Override
        public void started(LifecycleParticipant sender) {
            logger.debug("The TimeFinder does not auto-start when {} does.", (Object)sender);
        }

        @Override
        public void stopped(LifecycleParticipant sender) {
            if (TimeFinder.this.isRunning()) {
                logger.info("TimeFinder stopping because {} has.", (Object)sender);
                TimeFinder.this.stop();
            }
        }
    };
    private static final TimeFinder ourInstance = new TimeFinder();

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    public Map<Integer, TrackPositionUpdate> getLatestPositions() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<Integer, TrackPositionUpdate>(this.positions));
    }

    public Map<Integer, DeviceUpdate> getLatestUpdates() {
        this.ensureRunning();
        return Collections.unmodifiableMap(new HashMap<Integer, DeviceUpdate>(this.updates));
    }

    public TrackPositionUpdate getLatestPositionFor(int player) {
        this.ensureRunning();
        return this.positions.get(player);
    }

    public TrackPositionUpdate getLatestPositionFor(DeviceUpdate update) {
        return this.getLatestPositionFor(update.getDeviceNumber());
    }

    public DeviceUpdate getLatestUpdateFor(int player) {
        this.ensureRunning();
        return this.updates.get(player);
    }

    private long interpolateTimeSinceUpdate(TrackPositionUpdate update, long currentTimestamp) {
        if (!update.playing) {
            return update.milliseconds;
        }
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(currentTimestamp - update.timestamp);
        long moved = Math.round(update.pitch * (double)elapsedMillis);
        if (update.reverse) {
            return update.milliseconds - moved;
        }
        return update.milliseconds + moved;
    }

    private CueList.Entry findAdjacentCue(CdjStatus update, BeatGrid beatGrid) {
        if (!MetadataFinder.getInstance().isRunning()) {
            return null;
        }
        TrackMetadata metadata = MetadataFinder.getInstance().getLatestMetadataFor(update);
        int newBeat = update.getBeatNumber();
        if (metadata != null && metadata.getCueList() != null) {
            for (CueList.Entry entry : metadata.getCueList().entries) {
                int entryBeat = beatGrid.findBeatAtTime(entry.cueTime);
                if (Math.abs(newBeat - entryBeat) < 2) {
                    return entry;
                }
                if (entryBeat <= newBeat) continue;
                break;
            }
        }
        return null;
    }

    private long interpolateTimeFromUpdate(TrackPositionUpdate lastTrackUpdate, CdjStatus newDeviceUpdate, BeatGrid beatGrid) {
        long interpolated;
        CueList.Entry jumpedTo;
        boolean noLongerPlaying;
        int beatNumber = newDeviceUpdate.getBeatNumber();
        boolean bl = noLongerPlaying = !newDeviceUpdate.isPlaying();
        if (lastTrackUpdate.playing && noLongerPlaying && (jumpedTo = this.findAdjacentCue(newDeviceUpdate, beatGrid)) != null) {
            return jumpedTo.cueTime;
        }
        if (!lastTrackUpdate.playing) {
            if (lastTrackUpdate.beatNumber == beatNumber && noLongerPlaying) {
                return lastTrackUpdate.milliseconds;
            }
            if (noLongerPlaying) {
                if (beatNumber < 0) {
                    return -1L;
                }
                return this.timeOfBeat(beatGrid, beatNumber, newDeviceUpdate);
            }
        }
        long elapsedMillis = (newDeviceUpdate.getTimestamp() - lastTrackUpdate.timestamp) / 1000000L;
        long moved = Math.round(lastTrackUpdate.pitch * (double)elapsedMillis);
        long l = interpolated = lastTrackUpdate.reverse ? Math.max(lastTrackUpdate.milliseconds - moved, 0L) : lastTrackUpdate.milliseconds + moved;
        if (Math.abs(beatGrid.findBeatAtTime(interpolated) - beatNumber) < 2) {
            return interpolated;
        }
        if (newDeviceUpdate.isPlayingForwards()) {
            return this.timeOfBeat(beatGrid, beatNumber, newDeviceUpdate);
        }
        return beatGrid.getTimeWithinTrack(Math.min(beatNumber + 1, beatGrid.beatCount));
    }

    public long getTimeFor(int player) {
        TrackPositionUpdate update = this.positions.get(player);
        if (update != null) {
            return this.interpolateTimeSinceUpdate(update, System.nanoTime());
        }
        return -1L;
    }

    public long getTimeFor(DeviceUpdate update) {
        return this.getTimeFor(update.getDeviceNumber());
    }

    public void addTrackPositionListener(int player, TrackPositionListener listener) {
        this.listenerPlayerNumbers.put(listener, player);
        TrackPositionUpdate currentPosition = this.positions.get(player);
        this.trackPositionListeners.put(listener, currentPosition == null ? this.NO_INFORMATION : currentPosition);
        listener.movementChanged(currentPosition);
    }

    public void removeTrackPositionListener(TrackPositionListener listener) {
        this.trackPositionListeners.remove(listener);
        this.listenerPlayerNumbers.remove(listener);
    }

    public long getSlack() {
        return this.slack.get();
    }

    public void setSlack(long slack) {
        this.slack.set(slack);
    }

    private boolean interpolationsDisagree(TrackPositionUpdate lastUpdate, TrackPositionUpdate currentUpdate) {
        long tolerance;
        long now = System.nanoTime();
        long skew = Math.abs(this.interpolateTimeSinceUpdate(lastUpdate, now) - this.interpolateTimeSinceUpdate(currentUpdate, now));
        long l = tolerance = lastUpdate.playing ? this.slack.get() : 0L;
        if (tolerance > 0L && skew > tolerance && logger.isDebugEnabled()) {
            logger.debug("interpolationsDisagree: updates arrived {} ms apart, last {}interpolates to {}, current {}interpolates to {}, skew {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(currentUpdate.timestamp - lastUpdate.timestamp), lastUpdate.fromBeat ? "(beat) " : "", this.interpolateTimeSinceUpdate(lastUpdate, now), currentUpdate.fromBeat ? "(beat) " : "", this.interpolateTimeSinceUpdate(currentUpdate, now), skew});
        }
        return skew > tolerance;
    }

    private boolean pitchesDiffer(TrackPositionUpdate lastUpdate, TrackPositionUpdate currentUpdate) {
        double delta = Math.abs(lastUpdate.pitch - currentUpdate.pitch);
        if (lastUpdate.precise && lastUpdate.fromBeat != currentUpdate.fromBeat) {
            return delta > 0.001;
        }
        return delta > 1.0E-6;
    }

    private void updateListenersIfNeeded(int player, TrackPositionUpdate update, Beat beat) {
        for (Map.Entry<TrackPositionListener, TrackPositionUpdate> entry : new HashMap<TrackPositionListener, TrackPositionUpdate>(this.trackPositionListeners).entrySet()) {
            if (player != this.listenerPlayerNumbers.get(entry.getKey())) continue;
            if (update == null) {
                if (entry.getValue() == this.NO_INFORMATION || !this.trackPositionListeners.replace(entry.getKey(), entry.getValue(), this.NO_INFORMATION)) continue;
                try {
                    entry.getKey().movementChanged(null);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering null movementChanged update", t);
                }
                continue;
            }
            TrackPositionUpdate lastUpdate = entry.getValue();
            if ((lastUpdate == this.NO_INFORMATION || lastUpdate.playing != update.playing || this.pitchesDiffer(lastUpdate, update) || this.interpolationsDisagree(lastUpdate, update)) && this.trackPositionListeners.replace(entry.getKey(), entry.getValue(), update)) {
                try {
                    entry.getKey().movementChanged(update);
                }
                catch (Throwable t) {
                    logger.warn("Problem delivering movementChanged update", t);
                }
            }
            if (!update.fromBeat || !(entry.getKey() instanceof TrackPositionBeatListener)) continue;
            try {
                ((TrackPositionBeatListener)entry.getKey()).newBeat(beat, update);
            }
            catch (Throwable t) {
                logger.warn("Problem delivering newBeat update", t);
            }
        }
    }

    private long timeOfBeat(BeatGrid beatGrid, int beatNumber, DeviceUpdate update) {
        if (beatNumber <= beatGrid.beatCount) {
            return beatGrid.getTimeWithinTrack(beatNumber);
        }
        logger.warn("Received beat number " + beatNumber + " from " + update.getDeviceName() + " " + update.getDeviceNumber() + ", but beat grid only goes up to beat " + beatGrid.beatCount + ". Packet: " + update);
        if (beatGrid.beatCount < 2) {
            return beatGrid.getTimeWithinTrack(1);
        }
        long lastTime = beatGrid.getTimeWithinTrack(beatGrid.beatCount);
        long lastInterval = lastTime - beatGrid.getTimeWithinTrack(beatGrid.beatCount - 1);
        return lastTime + lastInterval * (long)(beatNumber - beatGrid.beatCount);
    }

    public boolean isOwnBeatListener(BeatListener listener) {
        return listener == this.beatListener;
    }

    public synchronized void start() throws Exception {
        if (!this.isRunning()) {
            DeviceFinder.getInstance().addDeviceAnnouncementListener(this.announcementListener);
            BeatGridFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            BeatGridFinder.getInstance().start();
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            VirtualCdj.getInstance().addLifecycleListener(this.lifecycleListener);
            VirtualCdj.getInstance().start();
            BeatFinder.getInstance().addLifecycleListener(this.lifecycleListener);
            BeatFinder.getInstance().addBeatListener(this.beatListener);
            BeatFinder.getInstance().addPrecisePositionListener(this.positionListener);
            BeatFinder.getInstance().start();
            this.running.set(true);
            this.deliverLifecycleAnnouncement(logger, true);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            BeatFinder.getInstance().removePrecisePositionListener(this.positionListener);
            BeatFinder.getInstance().removeBeatListener(this.beatListener);
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            this.running.set(false);
            this.positions.clear();
            this.updates.clear();
            this.deliverLifecycleAnnouncement(logger, false);
        }
    }

    public static TimeFinder getInstance() {
        return ourInstance;
    }

    private TimeFinder() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TimeFinder[running:").append(this.isRunning());
        sb.append(", listener count:").append(this.trackPositionListeners.size());
        if (this.isRunning()) {
            sb.append(", latestPositions:").append(this.getLatestPositions());
            sb.append(", latestUpdates:").append(this.getLatestUpdates());
        }
        return sb.append("]").toString();
    }
}

