/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.Color;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.DataReference;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.WaveformDetailComponent;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.dbserver.BinaryField;
import org.deepsymmetry.beatlink.dbserver.Message;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformDetail {
    private final Logger logger = LoggerFactory.getLogger(WaveformDetail.class);
    public static final int LEADING_DBSERVER_JUNK_BYTES = 19;
    public static final int LEADING_DBSERVER_COLOR_JUNK_BYTES = 28;
    public final DataReference dataReference;
    public final Message rawMessage;
    private final ByteBuffer detailBuffer;
    public final boolean isColor;
    public static final Color[] COLOR_MAP = new Color[]{new Color(0, 104, 144), new Color(0, 136, 176), new Color(0, 168, 232), new Color(0, 184, 216), new Color(120, 184, 216), new Color(136, 192, 232), new Color(136, 192, 232), new Color(200, 224, 232)};

    public ByteBuffer getData() {
        this.detailBuffer.rewind();
        return this.detailBuffer.slice();
    }

    public int getFrameCount() {
        int bytes = this.getData().remaining();
        if (this.isColor) {
            return bytes / 2;
        }
        return bytes;
    }

    public long getTotalTime() {
        return Util.halfFrameToTime(this.getFrameCount());
    }

    public JComponent createViewComponent(TrackMetadata metadata, BeatGrid beatGrid) {
        return new WaveformDetailComponent(this, metadata, beatGrid);
    }

    public WaveformDetail(DataReference reference, Message message) {
        this.isColor = message.knownType == Message.KnownType.ANLZ_TAG;
        this.dataReference = reference;
        this.rawMessage = message;
        ByteBuffer rawBuffer = ((BinaryField)this.rawMessage.arguments.get(3)).getValue();
        rawBuffer.position(this.isColor ? 28 : 19);
        this.detailBuffer = rawBuffer.slice();
    }

    public WaveformDetail(DataReference reference, RekordboxAnlz anlzFile) {
        this.dataReference = reference;
        this.rawMessage = null;
        ByteBuffer found = null;
        boolean colorFound = false;
        for (RekordboxAnlz.TaggedSection section : anlzFile.sections()) {
            RekordboxAnlz.WaveColorScrollTag tag;
            if (WaveformFinder.getInstance().isColorPreferred() && section.body() instanceof RekordboxAnlz.WaveColorScrollTag) {
                tag = (RekordboxAnlz.WaveColorScrollTag)section.body();
                found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
                colorFound = true;
                break;
            }
            if (!(section.body() instanceof RekordboxAnlz.WaveScrollTag)) continue;
            tag = (RekordboxAnlz.WaveScrollTag)section.body();
            found = ByteBuffer.wrap(tag.entries()).asReadOnlyBuffer();
        }
        this.detailBuffer = found;
        this.isColor = colorFound;
        if (this.detailBuffer == null) {
            throw new IllegalStateException("Could not construct WaveformDetail, missing from ANLZ file " + anlzFile);
        }
    }

    public WaveformDetail(DataReference reference, ByteBuffer data, boolean isColor) {
        this.dataReference = reference;
        this.rawMessage = null;
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        this.detailBuffer = ByteBuffer.wrap(bytes).asReadOnlyBuffer();
        this.isColor = isColor;
    }

    private int getColorWaveformBits(ByteBuffer waveBytes, int segment) {
        int base = segment * 2;
        int big = Util.unsign(waveBytes.get(base));
        int small = Util.unsign(waveBytes.get(base + 1));
        return big * 256 + small;
    }

    public int segmentHeight(int segment, int scale) {
        ByteBuffer waveBytes = this.getData();
        int limit = this.getFrameCount();
        int sum = 0;
        for (int i = segment; i < segment + scale && i < limit; ++i) {
            if (this.isColor) {
                sum += this.getColorWaveformBits(waveBytes, segment) >> 2 & 0x1F;
                continue;
            }
            sum += waveBytes.get(i) & 0x1F;
        }
        return sum / scale;
    }

    public Color segmentColor(int segment, int scale) {
        ByteBuffer waveBytes = this.getData();
        int limit = this.getFrameCount();
        if (this.isColor) {
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int i = segment; i < segment + scale && i < limit; ++i) {
                int bits = this.getColorWaveformBits(waveBytes, segment);
                red += bits >> 13 & 7;
                green += bits >> 10 & 7;
                blue += bits >> 7 & 7;
            }
            return new Color(red * 255 / (scale * 7), blue * 255 / (scale * 7), green * 255 / (scale * 7));
        }
        int sum = 0;
        for (int i = segment; i < segment + scale && i < limit; ++i) {
            sum += (waveBytes.get(i) & 0xE0) >> 5;
        }
        return COLOR_MAP[sum / scale];
    }

    public String toString() {
        return "WaveformDetail[dataReference=" + this.dataReference + ", size:" + this.getData().remaining() + "]";
    }
}

