/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.data;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.deepsymmetry.beatlink.CdjStatus;
import org.deepsymmetry.beatlink.DeviceUpdate;
import org.deepsymmetry.beatlink.DeviceUpdateListener;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.VirtualCdj;
import org.deepsymmetry.beatlink.data.AnalysisTagFinder;
import org.deepsymmetry.beatlink.data.AnalysisTagListener;
import org.deepsymmetry.beatlink.data.AnalysisTagUpdate;
import org.deepsymmetry.beatlink.data.BeatGrid;
import org.deepsymmetry.beatlink.data.BeatGridFinder;
import org.deepsymmetry.beatlink.data.BeatGridListener;
import org.deepsymmetry.beatlink.data.BeatGridUpdate;
import org.deepsymmetry.beatlink.data.CueList;
import org.deepsymmetry.beatlink.data.MetadataFinder;
import org.deepsymmetry.beatlink.data.OverlayPainter;
import org.deepsymmetry.beatlink.data.PlaybackState;
import org.deepsymmetry.beatlink.data.TimeFinder;
import org.deepsymmetry.beatlink.data.TrackMetadata;
import org.deepsymmetry.beatlink.data.TrackMetadataListener;
import org.deepsymmetry.beatlink.data.TrackMetadataUpdate;
import org.deepsymmetry.beatlink.data.WaveformDetail;
import org.deepsymmetry.beatlink.data.WaveformDetailUpdate;
import org.deepsymmetry.beatlink.data.WaveformFinder;
import org.deepsymmetry.beatlink.data.WaveformListener;
import org.deepsymmetry.beatlink.data.WaveformPreviewUpdate;
import org.deepsymmetry.cratedigger.pdb.RekordboxAnlz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformDetailComponent
extends JComponent {
    private static final Logger logger = LoggerFactory.getLogger(WaveformDetailComponent.class);
    private static final int BEAT_MARKER_HEIGHT = 4;
    private static final int CUE_MARKER_HEIGHT = 4;
    private static final int VERTICAL_MARGIN = 15;
    private static final int PLAYBACK_MARKER_WIDTH = 2;
    static final Color PLAYBACK_MARKER_PLAYING = new Color(255, 0, 0, 235);
    static final Color PLAYBACK_MARKER_STOPPED = new Color(255, 255, 255, 235);
    private static final Color LOOP_BACKGROUND = new Color(204, 121, 29);
    private static final Color INACTIVE_LOOP_BACKGROUND = new Color(80, 80, 80);
    private static final Color PHRASE_TRANSPARENCY = new Color(255, 255, 255, 220);
    private final AtomicInteger monitoredPlayer = new AtomicInteger(0);
    private final AtomicBoolean autoScroll = new AtomicBoolean(true);
    private final AtomicReference<Color> backgroundColor = new AtomicReference<Color>(Color.BLACK);
    private final AtomicReference<Color> indicatorColor = new AtomicReference<Color>(Color.WHITE);
    private final AtomicReference<Color> emphasisColor = new AtomicReference<Color>(Color.RED);
    private final AtomicReference<Font> labelFont = new AtomicReference<Font>(UIManager.getDefaults().getFont("Label.font"));
    private final AtomicReference<WaveformDetail> waveform = new AtomicReference();
    private final Map<Integer, PlaybackState> playbackStateMap = new ConcurrentHashMap<Integer, PlaybackState>(4);
    private final AtomicInteger scale = new AtomicInteger(1);
    private final AtomicReference<CueList> cueList = new AtomicReference();
    private final AtomicReference<BeatGrid> beatGrid = new AtomicReference();
    private final AtomicBoolean fetchSongStructures = new AtomicBoolean(true);
    private final AtomicReference<RekordboxAnlz.SongStructureTag> songStructure = new AtomicReference();
    private final AtomicReference<OverlayPainter> overlayPainter = new AtomicReference();
    private final AtomicBoolean animating = new AtomicBoolean(false);
    private final TrackMetadataListener metadataListener = new TrackMetadataListener(){

        @Override
        public void metadataChanged(TrackMetadataUpdate update) {
            if (update.player == WaveformDetailComponent.this.getMonitoredPlayer()) {
                if (update.metadata != null) {
                    WaveformDetailComponent.this.cueList.set(update.metadata.getCueList());
                } else {
                    WaveformDetailComponent.this.cueList.set(null);
                }
                WaveformDetailComponent.this.repaint();
            }
        }
    };
    private final WaveformListener waveformListener = new WaveformListener(){

        @Override
        public void previewChanged(WaveformPreviewUpdate update) {
        }

        @Override
        public void detailChanged(WaveformDetailUpdate update) {
            logger.debug("Got waveform detail update: {}", (Object)update);
            if (update.player == WaveformDetailComponent.this.getMonitoredPlayer()) {
                WaveformDetailComponent.this.waveform.set(update.detail);
                if (!WaveformDetailComponent.this.autoScroll.get()) {
                    WaveformDetailComponent.this.invalidate();
                }
                WaveformDetailComponent.this.repaint();
            }
        }
    };
    private final BeatGridListener beatGridListener = new BeatGridListener(){

        @Override
        public void beatGridChanged(BeatGridUpdate update) {
            if (update.player == WaveformDetailComponent.this.getMonitoredPlayer()) {
                WaveformDetailComponent.this.beatGrid.set(update.beatGrid);
                WaveformDetailComponent.this.repaint();
            }
        }
    };
    private final DeviceUpdateListener updateListener = new DeviceUpdateListener(){

        @Override
        public void received(DeviceUpdate update) {
            if (update instanceof CdjStatus && update.getDeviceNumber() == WaveformDetailComponent.this.getMonitoredPlayer() && WaveformDetailComponent.this.cueList.get() != null && WaveformDetailComponent.this.beatGrid.get() != null) {
                CdjStatus status = (CdjStatus)update;
                WaveformDetailComponent.this.setPlaying(status.isPlaying());
            }
        }
    };
    private final AnalysisTagListener analysisTagListener = new AnalysisTagListener(){

        @Override
        public void analysisChanged(AnalysisTagUpdate update) {
            if (update.player == WaveformDetailComponent.this.getMonitoredPlayer()) {
                WaveformDetailComponent.this.setSongStructureWrapper(update.taggedSection);
            }
        }
    };
    private static final int MAX_BEAT_SCALE = 9;
    private static final BasicStroke fillStroke = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);

    public void setAutoScroll(boolean auto) {
        if (this.autoScroll.getAndSet(auto) != auto) {
            this.setSize(this.getPreferredSize());
            this.repaint();
        }
    }

    public boolean getAutoScroll() {
        return this.autoScroll.get();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor.set(color);
    }

    public Color getIndicatorColor() {
        return this.indicatorColor.get();
    }

    public void setIndicatorColor(Color color) {
        this.indicatorColor.set(color);
    }

    public Color getEmphasisColor() {
        return this.emphasisColor.get();
    }

    public void setEmphasisColor(Color color) {
        this.emphasisColor.set(color);
    }

    public void setLabelFont(Font font) {
        this.labelFont.set(font);
        this.repaint();
    }

    public Font getLabelFont() {
        return this.labelFont.get();
    }

    public void setSongStructure(RekordboxAnlz.SongStructureTag songStructure) {
        this.songStructure.set(songStructure);
        this.repaint();
    }

    private void setSongStructureWrapper(RekordboxAnlz.TaggedSection taggedSection) {
        if (taggedSection == null) {
            this.setSongStructure(null);
        } else if (taggedSection.fourcc() == RekordboxAnlz.SectionTags.SONG_STRUCTURE) {
            this.setSongStructure((RekordboxAnlz.SongStructureTag)taggedSection.body());
        } else {
            logger.warn("Received unexpected analysis tag type:" + taggedSection);
        }
    }

    public synchronized void setFetchSongStructures(boolean fetchSongStructures) {
        this.fetchSongStructures.set(fetchSongStructures);
        if (fetchSongStructures && this.monitoredPlayer.get() > 0) {
            AnalysisTagFinder.getInstance().addAnalysisTagListener(this.analysisTagListener, ".EXT", "PSSI");
            if (AnalysisTagFinder.getInstance().isRunning()) {
                this.setSongStructureWrapper(AnalysisTagFinder.getInstance().getLatestTrackAnalysisFor(this.monitoredPlayer.get(), ".EXT", "PSSI"));
            }
        } else {
            AnalysisTagFinder.getInstance().removeAnalysisTagListener(this.analysisTagListener, ".EXT", "PSSI");
        }
    }

    public boolean getFetchSongStructures() {
        return this.fetchSongStructures.get();
    }

    public void setOverlayPainter(OverlayPainter painter) {
        this.overlayPainter.set(painter);
    }

    private void repaintDueToPlaybackStateChange(PlaybackState oldState, PlaybackState newState, PlaybackState oldFurthestState) {
        int right;
        if (this.autoScroll.get()) {
            long oldFurthest = 0L;
            if (oldFurthestState != null) {
                oldFurthest = oldFurthestState.position;
            }
            long newFurthest = 0L;
            PlaybackState newFurthestState = this.getFurthestPlaybackState();
            if (newFurthestState != null) {
                newFurthest = newFurthestState.position;
            }
            if (oldFurthest != newFurthest) {
                this.repaint();
                return;
            }
        }
        if (oldState != null) {
            int left = this.millisecondsToX(oldState.position) - 6;
            right = this.millisecondsToX(oldState.position) + 6;
            this.repaint(left, 0, right - left, this.getHeight());
        }
        if (newState != null) {
            int left = this.millisecondsToX(newState.position) - 6;
            right = this.millisecondsToX(newState.position) + 6;
            this.repaint(left, 0, right - left, this.getHeight());
        }
    }

    public synchronized void setPlaybackState(int player, long position, boolean playing) {
        if (this.getMonitoredPlayer() != 0 && player != this.getMonitoredPlayer()) {
            throw new IllegalStateException("Cannot setPlaybackState for another player when monitoring player " + this.getMonitoredPlayer());
        }
        if (player < 1) {
            throw new IllegalArgumentException("player must be positive");
        }
        PlaybackState oldFurthestState = this.getFurthestPlaybackState();
        PlaybackState newState = new PlaybackState(player, position, playing);
        PlaybackState oldState = this.playbackStateMap.put(player, newState);
        if (oldState == null || oldState.position != newState.position || oldState.playing != newState.playing) {
            this.repaintDueToPlaybackStateChange(oldState, newState, oldFurthestState);
        }
    }

    public synchronized void clearPlaybackState(int player) {
        PlaybackState oldFurthestState = this.getFurthestPlaybackState();
        PlaybackState oldState = this.playbackStateMap.remove(player);
        this.repaintDueToPlaybackStateChange(oldState, null, oldFurthestState);
    }

    public synchronized void clearPlaybackState() {
        for (PlaybackState state : this.playbackStateMap.values()) {
            this.clearPlaybackState(state.player);
        }
    }

    public PlaybackState getPlaybackState(int player) {
        return this.playbackStateMap.get(player);
    }

    public Set<PlaybackState> getPlaybackState() {
        HashSet<PlaybackState> result = new HashSet<PlaybackState>(this.playbackStateMap.values());
        return Collections.unmodifiableSet(result);
    }

    private PlaybackState currentSimpleState() {
        if (!this.playbackStateMap.isEmpty()) {
            return this.playbackStateMap.values().iterator().next();
        }
        return null;
    }

    private void setPlaybackPosition(long milliseconds) {
        PlaybackState oldState = this.currentSimpleState();
        if (oldState != null && oldState.position != milliseconds) {
            this.setPlaybackState(oldState.player, milliseconds, oldState.playing);
        }
    }

    public void setScale(int scale) {
        if (scale < 1 || scale > 256) {
            throw new IllegalArgumentException("Scale must be between 1 and 256");
        }
        int oldScale = this.scale.getAndSet(scale);
        if (oldScale != scale) {
            this.repaint();
            if (!this.autoScroll.get()) {
                this.setSize(this.getPreferredSize());
            }
        }
    }

    public int getScale() {
        return this.scale.get();
    }

    private void setPlaying(boolean playing) {
        PlaybackState oldState = this.currentSimpleState();
        if (oldState != null && oldState.playing != playing) {
            this.setPlaybackState(oldState.player, oldState.position, playing);
        }
    }

    public void setWaveform(WaveformDetail waveform, TrackMetadata metadata, BeatGrid beatGrid) {
        this.waveform.set(waveform);
        if (metadata != null) {
            this.cueList.set(metadata.getCueList());
        } else {
            this.cueList.set(null);
        }
        this.beatGrid.set(beatGrid);
        this.clearPlaybackState();
        this.repaint();
        if (!this.autoScroll.get()) {
            this.invalidate();
        }
    }

    public void setWaveform(WaveformDetail waveform, CueList cueList, BeatGrid beatGrid) {
        this.waveform.set(waveform);
        this.cueList.set(cueList);
        this.beatGrid.set(beatGrid);
        this.clearPlaybackState();
        this.repaint();
        if (!this.autoScroll.get()) {
            this.invalidate();
        }
    }

    public WaveformDetail getWaveform() {
        return this.waveform.get();
    }

    public synchronized void setMonitoredPlayer(int player) {
        if (player < 0) {
            throw new IllegalArgumentException("player cannot be negative");
        }
        this.clearPlaybackState();
        this.monitoredPlayer.set(player);
        if (player > 0) {
            TrackMetadata metadata;
            this.setPlaybackState(player, 0L, false);
            VirtualCdj.getInstance().addUpdateListener(this.updateListener);
            MetadataFinder.getInstance().addTrackMetadataListener(this.metadataListener);
            this.cueList.set(null);
            if (MetadataFinder.getInstance().isRunning() && (metadata = MetadataFinder.getInstance().getLatestMetadataFor(player)) != null) {
                this.cueList.set(metadata.getCueList());
            }
            WaveformFinder.getInstance().addWaveformListener(this.waveformListener);
            if (WaveformFinder.getInstance().isRunning() && WaveformFinder.getInstance().isFindingDetails()) {
                this.waveform.set(WaveformFinder.getInstance().getLatestDetailFor(player));
            } else {
                this.waveform.set(null);
            }
            BeatGridFinder.getInstance().addBeatGridListener(this.beatGridListener);
            if (BeatGridFinder.getInstance().isRunning()) {
                this.beatGrid.set(BeatGridFinder.getInstance().getLatestBeatGridFor(player));
            } else {
                this.beatGrid.set(null);
            }
            if (this.fetchSongStructures.get()) {
                AnalysisTagFinder.getInstance().addAnalysisTagListener(this.analysisTagListener, ".EXT", "PSSI");
                if (AnalysisTagFinder.getInstance().isRunning()) {
                    this.setSongStructureWrapper(AnalysisTagFinder.getInstance().getLatestTrackAnalysisFor(player, ".EXT", "PSSI"));
                }
            }
            try {
                TimeFinder.getInstance().start();
                if (!this.animating.getAndSet(true)) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (WaveformDetailComponent.this.animating.get()) {
                                try {
                                    Thread.sleep(33L);
                                }
                                catch (InterruptedException e) {
                                    logger.warn("Waveform animation thread interrupted; ending");
                                    WaveformDetailComponent.this.animating.set(false);
                                }
                                WaveformDetailComponent.this.setPlaybackPosition(TimeFinder.getInstance().getTimeFor(WaveformDetailComponent.this.getMonitoredPlayer()));
                            }
                        }
                    }).start();
                }
            }
            catch (Exception e) {
                logger.error("Unable to start the TimeFinder to animate the waveform detail view");
                this.animating.set(false);
            }
        } else {
            this.animating.set(false);
            VirtualCdj.getInstance().removeUpdateListener(this.updateListener);
            MetadataFinder.getInstance().removeTrackMetadataListener(this.metadataListener);
            WaveformFinder.getInstance().removeWaveformListener(this.waveformListener);
            AnalysisTagFinder.getInstance().removeAnalysisTagListener(this.analysisTagListener, ".EXT", "PSSI");
            this.cueList.set(null);
            this.waveform.set(null);
            this.beatGrid.set(null);
            this.songStructure.set(null);
        }
        if (!this.autoScroll.get()) {
            this.invalidate();
        }
        this.repaint();
    }

    public int getMonitoredPlayer() {
        return this.monitoredPlayer.get();
    }

    public WaveformDetailComponent(int player) {
        this.setMonitoredPlayer(player);
    }

    public WaveformDetailComponent(WaveformDetail waveform, TrackMetadata metadata, BeatGrid beatGrid) {
        this.waveform.set(waveform);
        if (metadata != null) {
            this.cueList.set(metadata.getCueList());
        }
        this.beatGrid.set(beatGrid);
    }

    public WaveformDetailComponent(WaveformDetail waveform, CueList cueList, BeatGrid beatGrid) {
        this.waveform.set(waveform);
        this.cueList.set(cueList);
        this.beatGrid.set(beatGrid);
    }

    @Override
    public Dimension getMinimumSize() {
        WaveformDetail detail = this.waveform.get();
        if (this.autoScroll.get() || detail == null) {
            return new Dimension(300, 92);
        }
        return new Dimension(detail.getFrameCount() / this.scale.get(), 92);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public PlaybackState getFurthestPlaybackState() {
        PlaybackState result = null;
        for (PlaybackState state : this.playbackStateMap.values()) {
            if (result != null && (result.playing || !state.playing) && (result.position >= state.position || !state.playing && result.playing)) continue;
            result = state;
        }
        return result;
    }

    public long getFurthestPlaybackPosition() {
        PlaybackState state = this.getFurthestPlaybackState();
        if (state != null) {
            return state.position;
        }
        return 0L;
    }

    private int getSegmentForX(int x) {
        if (this.autoScroll.get()) {
            int playHead = x - this.getWidth() / 2;
            int offset = Util.timeToHalfFrame(this.getFurthestPlaybackPosition()) / this.scale.get();
            return (playHead + offset) * this.scale.get();
        }
        return x * this.scale.get();
    }

    public long getTimeForX(int x) {
        return Util.halfFrameToTime(this.getSegmentForX(x));
    }

    public int getBeatForX(int x) {
        BeatGrid grid = this.beatGrid.get();
        if (grid != null) {
            return grid.findBeatAtTime(this.getTimeForX(x));
        }
        return -1;
    }

    public int getXForBeat(int beat) {
        BeatGrid grid = this.beatGrid.get();
        if (grid != null) {
            return this.millisecondsToX(grid.getTimeWithinTrack(beat));
        }
        return 0;
    }

    public int millisecondsToX(long milliseconds) {
        if (this.autoScroll.get()) {
            int playHead = this.getWidth() / 2 + 2;
            long offset = milliseconds - this.getFurthestPlaybackPosition();
            return playHead + Util.timeToHalfFrame(offset) / this.scale.get();
        }
        return Util.timeToHalfFrame(milliseconds) / this.scale.get();
    }

    @Deprecated
    public static Color cueColor(CueList.Entry entry) {
        return entry.getColor();
    }

    public boolean isDynamicLoopDataAvailable() {
        if (!VirtualCdj.getInstance().isRunning()) {
            return false;
        }
        for (PlaybackState state : this.playbackStateMap.values()) {
            CdjStatus status = (CdjStatus)VirtualCdj.getInstance().getLatestStatusFor(state.player);
            if (!status.canReportLooping()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clipRect = g.getClipBounds();
        g.setColor(this.backgroundColor.get());
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        CueList currentCueList = this.cueList.get();
        RekordboxAnlz.SongStructureTag currentSongStructure = this.songStructure.get();
        boolean drawingDynamicLoops = this.isDynamicLoopDataAvailable();
        int axis = this.getHeight() / 2;
        int maxHeight = axis - 15;
        if (currentCueList != null) {
            g.setColor(drawingDynamicLoops ? INACTIVE_LOOP_BACKGROUND : LOOP_BACKGROUND);
            for (CueList.Entry entry : currentCueList.entries) {
                if (!entry.isLoop) continue;
                int start = this.millisecondsToX(entry.cueTime);
                int end = this.millisecondsToX(entry.loopTime);
                g.fillRect(start, axis - maxHeight, end - start, maxHeight * 2);
            }
        }
        if (drawingDynamicLoops) {
            g.setColor(LOOP_BACKGROUND);
            for (PlaybackState state : this.playbackStateMap.values()) {
                CdjStatus status = (CdjStatus)VirtualCdj.getInstance().getLatestStatusFor(state.player);
                if (status.getLoopEnd() <= 0L) continue;
                int start = this.millisecondsToX(status.getLoopStart());
                int end = this.millisecondsToX(status.getLoopEnd());
                g.fillRect(start, axis - maxHeight, end - start, maxHeight * 2);
            }
        }
        int lastBeat = 0;
        if (this.beatGrid.get() != null) {
            lastBeat = this.beatGrid.get().findBeatAtTime(Util.halfFrameToTime(this.getSegmentForX(clipRect.x - 1)));
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke standardStroke = g2.getStroke();
        BasicStroke wideStroke = new BasicStroke(2.0f);
        for (int x = clipRect.x; x <= clipRect.x + clipRect.width; ++x) {
            int inBeat;
            int segment = this.getSegmentForX(x);
            if (this.waveform.get() != null && segment >= 0 && segment < this.waveform.get().getFrameCount()) {
                g.setColor(this.waveform.get().segmentColor(segment, this.scale.get()));
                int height = this.waveform.get().segmentHeight(segment, this.scale.get()) * maxHeight / 31;
                g.drawLine(x, axis - height, x, axis + height);
            }
            if (this.beatGrid.get() == null || (inBeat = this.beatGrid.get().findBeatAtTime(Util.halfFrameToTime(segment))) <= 0 || inBeat == lastBeat) continue;
            int beatWithinBar = this.beatGrid.get().getBeatWithinBar(inBeat);
            if (this.scale.get() <= 9 || beatWithinBar == 1) {
                g.setColor(beatWithinBar == 1 ? this.emphasisColor.get() : this.indicatorColor.get());
                g2.setStroke(beatWithinBar == 1 ? wideStroke : standardStroke);
                g.drawLine(x, axis - maxHeight - 2 - 4, x, axis - maxHeight - 2);
                g.drawLine(x, axis + maxHeight + 2, x, axis + maxHeight + 4 + 2);
                g2.setStroke(standardStroke);
            }
            lastBeat = inBeat;
        }
        if (currentCueList != null) {
            this.paintCueList(g, clipRect, currentCueList, axis, maxHeight);
        }
        if (currentSongStructure != null) {
            this.paintPhrases(g, clipRect, currentSongStructure, axis, maxHeight);
        }
        g.setColor(Util.buildColor(this.indicatorColor.get(), PLAYBACK_MARKER_STOPPED));
        for (PlaybackState state : this.playbackStateMap.values()) {
            if (state.playing) continue;
            g.fillRect(this.millisecondsToX(state.position) - 1, 0, 2, this.getHeight());
        }
        g.setColor(Util.buildColor(this.emphasisColor.get(), PLAYBACK_MARKER_PLAYING));
        for (PlaybackState state : this.playbackStateMap.values()) {
            if (!state.playing) continue;
            g.fillRect(this.millisecondsToX(state.position) - 1, 0, 2, this.getHeight());
        }
        OverlayPainter painter = this.overlayPainter.get();
        if (painter != null) {
            painter.paintOverlay(this, g);
        }
    }

    private String buildCueLabel(CueList.Entry entry) {
        if (entry.hotCueNumber > 0) {
            String label = String.valueOf((char)(64 + entry.hotCueNumber));
            if (entry.comment.isEmpty()) {
                return label;
            }
            return label + ": " + entry.comment;
        }
        return entry.comment;
    }

    private void paintCueList(Graphics g, Rectangle clipRect, CueList cueList, int axis, int maxHeight) {
        for (CueList.Entry entry : cueList.entries) {
            int x = this.millisecondsToX(entry.cueTime);
            if (x <= clipRect.x - 4 || x >= clipRect.x + clipRect.width + 4) continue;
            g.setColor(entry.getColor());
            for (int i = 0; i < 4; ++i) {
                g.drawLine(x - 3 + i, axis - maxHeight - 4 - 4 + i, x + 3 - i, axis - maxHeight - 4 - 4 + i);
            }
            String label = this.buildCueLabel(entry);
            Font font = this.labelFont.get();
            if (font == null || label.isEmpty()) continue;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(font);
            FontRenderContext renderContext = g2.getFontRenderContext();
            LineMetrics metrics = g2.getFont().getLineMetrics(label, renderContext);
            Rectangle2D bounds = g2.getFont().getStringBounds(label, renderContext);
            int textWidth = (int)Math.ceil(bounds.getWidth());
            int textHeight = (int)Math.ceil(metrics.getAscent() + metrics.getDescent());
            g2.fillRect(x, axis - maxHeight - 2, textWidth + 4, textHeight + 2);
            g2.setColor(Color.black);
            g2.drawString(label, (float)(x + 2), (float)(axis - maxHeight - 1) + metrics.getAscent());
        }
    }

    private void paintPhrases(Graphics g, Rectangle clipRect, RekordboxAnlz.SongStructureTag songStructure, int axis, int maxHeight) {
        if (songStructure == null) {
            return;
        }
        int scrolledX = 0;
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof JScrollPane) {
                scrolledX = ((JScrollPane)parent).getViewport().getViewPosition().x;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        for (int i = 0; i < songStructure.lenEntries(); ++i) {
            RekordboxAnlz.SongStructureEntry entry = (RekordboxAnlz.SongStructureEntry)songStructure.body().entries().get(i);
            int endBeat = i == songStructure.lenEntries() - 1 ? songStructure.body().endBeat() : ((RekordboxAnlz.SongStructureEntry)songStructure.body().entries().get(i + 1)).beat();
            int x1 = this.getXForBeat(entry.beat());
            int x2 = this.getXForBeat(endBeat) - 1;
            if (!(x1 >= clipRect.x && x1 <= clipRect.x + clipRect.width || x2 >= clipRect.x && x2 <= clipRect.x + clipRect.width) && (x1 >= clipRect.x || x2 <= clipRect.x + clipRect.width)) continue;
            g.setColor(Util.buildColor(Util.phraseColor(entry), PHRASE_TRANSPARENCY));
            String label = Util.phraseLabel(entry);
            Font font = this.labelFont.get();
            if (font == null || label.isEmpty()) continue;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(font);
            FontRenderContext renderContext = g2.getFontRenderContext();
            LineMetrics metrics = g2.getFont().getLineMetrics(label, renderContext);
            int textHeight = (int)Math.ceil(metrics.getAscent() + metrics.getDescent());
            Shape oldClip = g2.getClip();
            g2.clipRect(x1, axis + maxHeight + 2 - textHeight, x2 - x1, textHeight + 2);
            Rectangle2D.Double phraseRect = new Rectangle2D.Double(x1, axis + maxHeight + 2 - textHeight, x2 - x1, textHeight + 2);
            g2.fill(phraseRect);
            g2.setColor(Util.buildColor(Util.phraseTextColor(entry), PHRASE_TRANSPARENCY));
            int labelX = x1;
            if (scrolledX > labelX) {
                labelX += scrolledX - labelX;
            }
            g2.drawString(label, labelX + 2, axis + maxHeight);
            if (entry.fill() != 0) {
                int xFill = this.getXForBeat(entry.beatFill());
                g2.setColor(Util.buildColor(Color.white, PHRASE_TRANSPARENCY));
                Stroke oldStroke = g2.getStroke();
                g2.setStroke(fillStroke);
                g2.drawLine(xFill, axis + maxHeight - 1, x2, axis + maxHeight - 1);
                g2.setStroke(oldStroke);
            }
            g2.setClip(oldClip);
        }
    }

    @Override
    public String toString() {
        return "WaveformDetailComponent[cueList=" + this.cueList.get() + ", waveform=" + this.waveform.get() + ", beatGrid=" + this.beatGrid.get() + ", playbackStateMap=" + this.playbackStateMap + ", monitoredPlayer=" + this.getMonitoredPlayer() + "fetchSongStructures=" + this.fetchSongStructures.get() + "]";
    }
}

