/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.beatlink.dbserver;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.deepsymmetry.beatlink.Util;
import org.deepsymmetry.beatlink.dbserver.Field;

public class NumberField
extends Field {
    private final byte typeTag;
    private final int size;
    private final long value;
    private final ByteBuffer buffer;
    public static final NumberField WORD_0 = new NumberField(0L);
    public static final NumberField WORD_1 = new NumberField(1L);

    public NumberField(byte typeTag, DataInputStream is) throws IOException {
        this.typeTag = typeTag;
        switch (typeTag) {
            case 15: {
                this.size = 1;
                break;
            }
            case 16: {
                this.size = 2;
                break;
            }
            case 17: {
                this.size = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("NumberField cannot have tag " + typeTag);
            }
        }
        byte[] bufBytes = new byte[this.size + 1];
        bufBytes[0] = typeTag;
        is.readFully(bufBytes, 1, this.size);
        this.buffer = ByteBuffer.wrap(bufBytes).asReadOnlyBuffer();
        this.value = Util.bytesToNumber(bufBytes, 1, this.size);
    }

    public NumberField(long value, int size) {
        this.value = value & 0xFFFFFFFFL;
        this.size = size;
        byte[] bufBytes = new byte[size + 1];
        switch (size) {
            case 1: {
                this.typeTag = (byte)15;
                bufBytes[1] = (byte)(value & 0xFFL);
                break;
            }
            case 2: {
                this.typeTag = (byte)16;
                bufBytes[1] = (byte)((value & 0xFF00L) >> 8);
                bufBytes[2] = (byte)(value & 0xFFL);
                break;
            }
            case 4: {
                this.typeTag = (byte)17;
                bufBytes[1] = (byte)((value & 0xFFFFFFFFFF000000L) >> 24);
                bufBytes[2] = (byte)((value & 0xFF0000L) >> 16);
                bufBytes[3] = (byte)((value & 0xFF00L) >> 8);
                bufBytes[4] = (byte)(value & 0xFFL);
                break;
            }
            default: {
                throw new IllegalArgumentException("NumberField cannot have size " + size);
            }
        }
        bufBytes[0] = this.typeTag;
        this.buffer = ByteBuffer.wrap(bufBytes).asReadOnlyBuffer();
    }

    public NumberField(long value) {
        this(value, 4);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public byte getTypeTag() {
        return this.typeTag;
    }

    @Override
    public byte getArgumentTag() {
        return 6;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public ByteBuffer getBytes() {
        this.buffer.rewind();
        return this.buffer.slice();
    }

    public String toString() {
        return "NumberField[ size: " + this.size + ", value: " + this.value + ", bytes: " + this.getHexString() + "]";
    }
}

