/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.cratedigger;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import org.deepsymmetry.cratedigger.Database;
import org.deepsymmetry.cratedigger.pdb.RekordboxPdb;

public class Archivist {
    private static final Archivist instance = new Archivist();

    public static Archivist getInstance() {
        return instance;
    }

    private Archivist() {
    }

    public void createArchive(Database database, File file) throws IOException {
        this.createArchive(database, file, null);
    }

    public void createArchive(Database database, File archiveFile, ArchiveListener listener) throws IOException {
        Path archivePath = archiveFile.toPath();
        Path mediaPath = database.sourceFile.getParentFile().getParentFile().getParentFile().toPath();
        Files.deleteIfExists(archivePath);
        URI fileUri = archivePath.toUri();
        int totalTracks = database.trackIndex.size();
        boolean failed = false;
        try (FileSystem fileSystem = FileSystems.newFileSystem(new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null), Map.of("create", "true"));){
            Files.copy(database.sourceFile.toPath(), fileSystem.getPath("/export.pdb", new String[0]), new CopyOption[0]);
            Iterator<Map.Entry<Long, RekordboxPdb.TrackRow>> iterator = database.trackIndex.entrySet().iterator();
            int completed = 0;
            while ((listener == null || listener.continueCreating(completed, totalTracks)) && iterator.hasNext()) {
                RekordboxPdb.ArtworkRow artwork;
                Map.Entry<Long, RekordboxPdb.TrackRow> entry = iterator.next();
                RekordboxPdb.TrackRow track = entry.getValue();
                String anlzPathString = Database.getText(track.analyzePath());
                Path anlzPath = mediaPath.resolve(anlzPathString.substring(1));
                Path destPath = fileSystem.getPath(anlzPathString, new String[0]);
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                Files.copy(anlzPath, destPath, new CopyOption[0]);
                String extPathString = anlzPathString.substring(0, anlzPathString.length() - 3) + "EXT";
                Path extPath = mediaPath.resolve(extPathString.substring(1));
                if (extPath.toFile().canRead()) {
                    destPath = fileSystem.getPath(extPathString, new String[0]);
                    Files.copy(extPath, destPath, new CopyOption[0]);
                }
                if ((artwork = database.artworkIndex.get(track.artworkId())) != null) {
                    String highResArtPathString;
                    Path highResArtPath;
                    String artPathString = Database.getText(artwork.path());
                    Path artPath = mediaPath.resolve(artPathString.substring(1));
                    if (artPath.toFile().canRead()) {
                        destPath = fileSystem.getPath(artPathString, new String[0]);
                        Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                        Files.copy(artPath, destPath, new CopyOption[0]);
                    }
                    if ((highResArtPath = mediaPath.resolve((highResArtPathString = artPathString.replaceFirst("(\\.\\w+$)", "_m$1")).substring(1))).toFile().canRead()) {
                        destPath = fileSystem.getPath(highResArtPathString, new String[0]);
                        Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                        Files.copy(highResArtPath, destPath, new CopyOption[0]);
                    }
                }
                ++completed;
            }
            if (iterator.hasNext()) {
                failed = true;
            }
        }
        catch (URISyntaxException e) {
            failed = true;
            throw new IOException("Unable to create jar filesystem at file location", e);
        }
        catch (IOException e) {
            failed = true;
            throw e;
        }
        finally {
            if (failed) {
                Files.deleteIfExists(archivePath);
            }
        }
    }

    public static interface ArchiveListener {
        public boolean continueCreating(int var1, int var2);
    }
}

