/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.cratedigger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcUdpClient;
import org.acplt.oncrpc.XdrAble;
import org.deepsymmetry.cratedigger.rpc.DirOpArgs;
import org.deepsymmetry.cratedigger.rpc.DirOpRes;
import org.deepsymmetry.cratedigger.rpc.DirOpResBody;
import org.deepsymmetry.cratedigger.rpc.DirPath;
import org.deepsymmetry.cratedigger.rpc.FHStatus;
import org.deepsymmetry.cratedigger.rpc.FHandle;
import org.deepsymmetry.cratedigger.rpc.Filename;
import org.deepsymmetry.cratedigger.rpc.ReadArgs;
import org.deepsymmetry.cratedigger.rpc.ReadRes;

public class FileFetcher {
    public static final Charset CHARSET = Charset.forName("UTF-16LE");
    public static final int DEFAULT_READ_SIZE = 2048;
    public static final int DEFAULT_RPC_RETRANSMIT_TIMEOUT = 250;
    private static final FileFetcher instance = new FileFetcher();
    private int readSize = 2048;
    private int retransmitTimeout = 250;
    private final Map<InetAddress, Map<String, FHandle>> mounts = new ConcurrentHashMap<InetAddress, Map<String, FHandle>>();
    private final Map<InetAddress, OncRpcUdpClient> nfsClients = new ConcurrentHashMap<InetAddress, OncRpcUdpClient>();

    public static FileFetcher getInstance() {
        return instance;
    }

    private FileFetcher() {
    }

    public int getReadSize() {
        return this.readSize;
    }

    public void setReadSize(int readSize) {
        if (readSize < 1024 || readSize > 8192) {
            throw new IllegalArgumentException("readSize must be between 1024 and 8192, inclusive.");
        }
        this.readSize = readSize;
    }

    public int getRetransmitTimeout() {
        return this.retransmitTimeout;
    }

    public void setRetransmitTimeout(int retransmitTimeout) {
        if (retransmitTimeout < 1 || retransmitTimeout > 30000) {
            throw new IllegalArgumentException("retransmitTimeout must be between 1 and 30000, inclusive.");
        }
        this.retransmitTimeout = retransmitTimeout;
    }

    private FHStatus mount(InetAddress player, String path) throws IOException, OncRpcException {
        OncRpcUdpClient client = (OncRpcUdpClient)OncRpcUdpClient.newOncRpcClient((InetAddress)player, (int)100005, (int)1, (int)17);
        client.setRetransmissionTimeout(this.retransmitTimeout);
        client.setRetransmissionMode(0);
        DirPath mountPath = new DirPath(path.getBytes(CHARSET));
        FHStatus result = new FHStatus();
        client.call(1, (XdrAble)mountPath, (XdrAble)result);
        return result;
    }

    private FHandle findRoot(InetAddress player, String path) throws IOException, OncRpcException {
        FHandle cached;
        Map<String, FHandle> playerMap = this.mounts.get(player);
        if (playerMap != null && (cached = playerMap.get(path)) != null) {
            return cached;
        }
        FHStatus mountResult = this.mount(player, path);
        if (mountResult.status != 0) {
            throw new IOException("Unable to mount path \"" + path + "\" on player " + player.getHostAddress() + ", mount command returned " + mountResult.status);
        }
        if (playerMap == null) {
            playerMap = new ConcurrentHashMap<String, FHandle>();
            this.mounts.put(player, playerMap);
        }
        playerMap.put(path, mountResult.directory);
        return mountResult.directory;
    }

    public void removePlayer(InetAddress player) {
        this.mounts.remove(player);
        this.nfsClients.remove(player);
    }

    private OncRpcUdpClient getNfsClient(InetAddress player) throws OncRpcException, IOException {
        OncRpcUdpClient client = this.nfsClients.get(player);
        if (client == null) {
            client = (OncRpcUdpClient)OncRpcClient.newOncRpcClient((InetAddress)player, (int)100003, (int)2, (int)17);
            this.nfsClients.put(player, client);
            client.setRetransmissionMode(0);
        }
        client.setRetransmissionTimeout(this.retransmitTimeout);
        return client;
    }

    private DirOpResBody find(InetAddress player, String mountPath, String filePath) throws IOException, OncRpcException {
        FHandle root = this.findRoot(player, mountPath);
        OncRpcUdpClient client = this.getNfsClient(player);
        String[] elements = filePath.split("/");
        FHandle fileHandle = root;
        DirOpRes result = null;
        for (String element : elements) {
            if (element.length() <= 0) continue;
            DirOpArgs args = new DirOpArgs();
            args.dir = fileHandle;
            args.name = new Filename(element.getBytes(CHARSET));
            result = new DirOpRes();
            client.call(4, (XdrAble)args, (XdrAble)result);
            if (result.status != 0) {
                String message = "Unable to find file \"" + filePath + "\", lookup of element \"" + element + "\" returned status of " + result.status;
                if (result.status == 2) {
                    throw new FileNotFoundException(message);
                }
                throw new IOException(message);
            }
            fileHandle = result.diropok.file;
        }
        if (result == null) {
            throw new IllegalArgumentException("Must supply at least one non-empty mountPath element to look up.");
        }
        return result.diropok;
    }

    public void fetch(InetAddress player, String mountPath, String sourcePath, File destination) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(destination);){
            byte[] data;
            DirOpResBody found = this.find(player, mountPath, sourcePath);
            if (found.attributes.type != 1) {
                throw new IOException("Path \"" + sourcePath + "\" is not a normal file.");
            }
            OncRpcUdpClient client = this.getNfsClient(player);
            ReadArgs args = new ReadArgs();
            args.file = found.file;
            args.offset = 0;
            ReadRes result = new ReadRes();
            for (int bytesLeft = found.attributes.size; bytesLeft > 0; bytesLeft -= data.length) {
                args.count = bytesLeft < 2048 ? bytesLeft : 2048;
                client.call(6, (XdrAble)args, (XdrAble)result);
                if (result.status != 0) {
                    throw new IOException("Problem reading \"" + sourcePath + "\": NFS read call returned status: " + result.status);
                }
                data = result.readResOk.data.value;
                if (data.length != args.count) {
                    throw new IOException("Problem reading \"" + sourcePath + "\": tried to read " + args.count + " bytes but only received " + data.length);
                }
                outputStream.write(data);
                args.offset += data.length;
            }
        }
    }
}

