/*
 * Decompiled with CFR 0.152.
 */
package org.deepsymmetry.cratedigger.pdb;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class RekordboxAnlz
extends KaitaiStruct {
    private byte[] magic;
    private long lenHeader;
    private long lenFile;
    private byte[] _unnamed3;
    private ArrayList<TaggedSection> sections;
    private RekordboxAnlz _root;
    private KaitaiStruct _parent;

    public static RekordboxAnlz fromFile(String fileName) throws IOException {
        return new RekordboxAnlz((KaitaiStream)new ByteBufferKaitaiStream(fileName));
    }

    public RekordboxAnlz(KaitaiStream _io) {
        this(_io, null, null);
    }

    public RekordboxAnlz(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public RekordboxAnlz(KaitaiStream _io, KaitaiStruct _parent, RekordboxAnlz _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
        this._read();
    }

    private void _read() {
        this.magic = this._io.readBytes(4L);
        if (!Arrays.equals(this.magic(), new byte[]{80, 77, 65, 73})) {
            throw new KaitaiStream.ValidationNotEqualError(new byte[]{80, 77, 65, 73}, this.magic(), this._io(), "/seq/0");
        }
        this.lenHeader = this._io.readU4be();
        this.lenFile = this._io.readU4be();
        this._unnamed3 = this._io.readBytes(this.lenHeader() - (long)this._io().pos());
        this.sections = new ArrayList();
        int i = 0;
        while (!this._io.isEof()) {
            this.sections.add(new TaggedSection(this._io, this, this._root));
            ++i;
        }
    }

    public byte[] magic() {
        return this.magic;
    }

    public long lenHeader() {
        return this.lenHeader;
    }

    public long lenFile() {
        return this.lenFile;
    }

    public byte[] _unnamed3() {
        return this._unnamed3;
    }

    public ArrayList<TaggedSection> sections() {
        return this.sections;
    }

    public RekordboxAnlz _root() {
        return this._root;
    }

    public KaitaiStruct _parent() {
        return this._parent;
    }

    public static class CueTag
    extends KaitaiStruct {
        private CueListType type;
        private byte[] _unnamed1;
        private int numCues;
        private long memoryCount;
        private ArrayList<CueEntry> cues;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static CueTag fromFile(String fileName) throws IOException {
            return new CueTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public CueTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public CueTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.type = CueListType.byId(this._io.readU4be());
            this._unnamed1 = this._io.readBytes(2L);
            this.numCues = this._io.readU2be();
            this.memoryCount = this._io.readU4be();
            this.cues = new ArrayList();
            for (int i = 0; i < this.numCues(); ++i) {
                this.cues.add(new CueEntry(this._io, this, this._root));
            }
        }

        public CueListType type() {
            return this.type;
        }

        public byte[] _unnamed1() {
            return this._unnamed1;
        }

        public int numCues() {
            return this.numCues;
        }

        public long memoryCount() {
            return this.memoryCount;
        }

        public ArrayList<CueEntry> cues() {
            return this.cues;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class WaveColorScrollTag
    extends KaitaiStruct {
        private long lenEntryBytes;
        private long lenEntries;
        private long _unnamed2;
        private byte[] entries;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static WaveColorScrollTag fromFile(String fileName) throws IOException {
            return new WaveColorScrollTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public WaveColorScrollTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WaveColorScrollTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WaveColorScrollTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU4be();
            this._unnamed2 = this._io.readU4be();
            this.entries = this._io.readBytes(this.lenEntries() * this.lenEntryBytes());
        }

        public long lenEntryBytes() {
            return this.lenEntryBytes;
        }

        public long lenEntries() {
            return this.lenEntries;
        }

        public long _unnamed2() {
            return this._unnamed2;
        }

        public byte[] entries() {
            return this.entries;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class TaggedSection
    extends KaitaiStruct {
        private SectionTags fourcc;
        private long lenHeader;
        private long lenTag;
        private KaitaiStruct body;
        private RekordboxAnlz _root;
        private RekordboxAnlz _parent;
        private byte[] _raw_body;

        public static TaggedSection fromFile(String fileName) throws IOException {
            return new TaggedSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public TaggedSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public TaggedSection(KaitaiStream _io, RekordboxAnlz _parent) {
            this(_io, _parent, null);
        }

        public TaggedSection(KaitaiStream _io, RekordboxAnlz _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.fourcc = SectionTags.byId(this._io.readS4be());
            this.lenHeader = this._io.readU4be();
            this.lenTag = this._io.readU4be();
            SectionTags on = this.fourcc();
            if (on != null) {
                switch (this.fourcc()) {
                    case WAVE_COLOR_SCROLL: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new WaveColorScrollTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case WAVE_SCROLL: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new WaveScrollTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case VBR: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new VbrTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case CUES_2: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new CueExtendedTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case CUES: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new CueTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case SONG_STRUCTURE: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new SongStructureTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case BEAT_GRID: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new BeatGridTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case WAVE_PREVIEW: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new WavePreviewTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case WAVE_COLOR_PREVIEW: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new WaveColorPreviewTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case PATH: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new PathTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    case WAVE_TINY: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new WavePreviewTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                    default: {
                        this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                        ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                        this.body = new UnknownTag((KaitaiStream)_io__raw_body, this, this._root);
                        break;
                    }
                }
            } else {
                this._raw_body = this._io.readBytes(this.lenTag() - 12L);
                ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
                this.body = new UnknownTag((KaitaiStream)_io__raw_body, this, this._root);
            }
        }

        public SectionTags fourcc() {
            return this.fourcc;
        }

        public long lenHeader() {
            return this.lenHeader;
        }

        public long lenTag() {
            return this.lenTag;
        }

        public KaitaiStruct body() {
            return this.body;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public RekordboxAnlz _parent() {
            return this._parent;
        }

        public byte[] _raw_body() {
            return this._raw_body;
        }
    }

    public static class UnknownTag
    extends KaitaiStruct {
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static UnknownTag fromFile(String fileName) throws IOException {
            return new UnknownTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public UnknownTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public UnknownTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public UnknownTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class PhraseLow
    extends KaitaiStruct {
        private MoodLowPhrase id;
        private RekordboxAnlz _root;
        private SongStructureEntry _parent;

        public static PhraseLow fromFile(String fileName) throws IOException {
            return new PhraseLow((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public PhraseLow(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PhraseLow(KaitaiStream _io, SongStructureEntry _parent) {
            this(_io, _parent, null);
        }

        public PhraseLow(KaitaiStream _io, SongStructureEntry _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = MoodLowPhrase.byId(this._io.readU2be());
        }

        public MoodLowPhrase id() {
            return this.id;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public SongStructureEntry _parent() {
            return this._parent;
        }
    }

    public static class CueExtendedTag
    extends KaitaiStruct {
        private CueListType type;
        private int numCues;
        private byte[] _unnamed2;
        private ArrayList<CueExtendedEntry> cues;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static CueExtendedTag fromFile(String fileName) throws IOException {
            return new CueExtendedTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public CueExtendedTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueExtendedTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public CueExtendedTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.type = CueListType.byId(this._io.readU4be());
            this.numCues = this._io.readU2be();
            this._unnamed2 = this._io.readBytes(2L);
            this.cues = new ArrayList();
            for (int i = 0; i < this.numCues(); ++i) {
                this.cues.add(new CueExtendedEntry(this._io, this, this._root));
            }
        }

        public CueListType type() {
            return this.type;
        }

        public int numCues() {
            return this.numCues;
        }

        public byte[] _unnamed2() {
            return this._unnamed2;
        }

        public ArrayList<CueExtendedEntry> cues() {
            return this.cues;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class BeatGridBeat
    extends KaitaiStruct {
        private int beatNumber;
        private int tempo;
        private long time;
        private RekordboxAnlz _root;
        private BeatGridTag _parent;

        public static BeatGridBeat fromFile(String fileName) throws IOException {
            return new BeatGridBeat((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public BeatGridBeat(KaitaiStream _io) {
            this(_io, null, null);
        }

        public BeatGridBeat(KaitaiStream _io, BeatGridTag _parent) {
            this(_io, _parent, null);
        }

        public BeatGridBeat(KaitaiStream _io, BeatGridTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.beatNumber = this._io.readU2be();
            this.tempo = this._io.readU2be();
            this.time = this._io.readU4be();
        }

        public int beatNumber() {
            return this.beatNumber;
        }

        public int tempo() {
            return this.tempo;
        }

        public long time() {
            return this.time;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public BeatGridTag _parent() {
            return this._parent;
        }
    }

    public static class CueEntry
    extends KaitaiStruct {
        private byte[] magic;
        private long lenHeader;
        private long lenEntry;
        private long hotCue;
        private CueEntryStatus status;
        private long _unnamed5;
        private int orderFirst;
        private int orderLast;
        private CueEntryType type;
        private byte[] _unnamed9;
        private long time;
        private long loopTime;
        private byte[] _unnamed12;
        private RekordboxAnlz _root;
        private CueTag _parent;

        public static CueEntry fromFile(String fileName) throws IOException {
            return new CueEntry((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public CueEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueEntry(KaitaiStream _io, CueTag _parent) {
            this(_io, _parent, null);
        }

        public CueEntry(KaitaiStream _io, CueTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.magic = this._io.readBytes(4L);
            if (!Arrays.equals(this.magic(), new byte[]{80, 67, 80, 84})) {
                throw new KaitaiStream.ValidationNotEqualError(new byte[]{80, 67, 80, 84}, this.magic(), this._io(), "/types/cue_entry/seq/0");
            }
            this.lenHeader = this._io.readU4be();
            this.lenEntry = this._io.readU4be();
            this.hotCue = this._io.readU4be();
            this.status = CueEntryStatus.byId(this._io.readU4be());
            this._unnamed5 = this._io.readU4be();
            this.orderFirst = this._io.readU2be();
            this.orderLast = this._io.readU2be();
            this.type = CueEntryType.byId(this._io.readU1());
            this._unnamed9 = this._io.readBytes(3L);
            this.time = this._io.readU4be();
            this.loopTime = this._io.readU4be();
            this._unnamed12 = this._io.readBytes(16L);
        }

        public byte[] magic() {
            return this.magic;
        }

        public long lenHeader() {
            return this.lenHeader;
        }

        public long lenEntry() {
            return this.lenEntry;
        }

        public long hotCue() {
            return this.hotCue;
        }

        public CueEntryStatus status() {
            return this.status;
        }

        public long _unnamed5() {
            return this._unnamed5;
        }

        public int orderFirst() {
            return this.orderFirst;
        }

        public int orderLast() {
            return this.orderLast;
        }

        public CueEntryType type() {
            return this.type;
        }

        public byte[] _unnamed9() {
            return this._unnamed9;
        }

        public long time() {
            return this.time;
        }

        public long loopTime() {
            return this.loopTime;
        }

        public byte[] _unnamed12() {
            return this._unnamed12;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public CueTag _parent() {
            return this._parent;
        }
    }

    public static class SongStructureEntry
    extends KaitaiStruct {
        private int index;
        private int beat;
        private KaitaiStruct kind;
        private byte[] _unnamed3;
        private int k1;
        private byte[] _unnamed5;
        private int k2;
        private byte[] _unnamed7;
        private int b;
        private int beat2;
        private int beat3;
        private int beat4;
        private byte[] _unnamed12;
        private int k3;
        private byte[] _unnamed14;
        private int fill;
        private int beatFill;
        private RekordboxAnlz _root;
        private SongStructureBody _parent;

        public static SongStructureEntry fromFile(String fileName) throws IOException {
            return new SongStructureEntry((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SongStructureEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SongStructureEntry(KaitaiStream _io, SongStructureBody _parent) {
            this(_io, _parent, null);
        }

        public SongStructureEntry(KaitaiStream _io, SongStructureBody _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.index = this._io.readU2be();
            this.beat = this._io.readU2be();
            TrackMood on = this._parent().mood();
            if (on != null) {
                switch (this._parent().mood()) {
                    case HIGH: {
                        this.kind = new PhraseHigh(this._io, this, this._root);
                        break;
                    }
                    case MID: {
                        this.kind = new PhraseMid(this._io, this, this._root);
                        break;
                    }
                    case LOW: {
                        this.kind = new PhraseLow(this._io, this, this._root);
                        break;
                    }
                    default: {
                        this.kind = new PhraseMid(this._io, this, this._root);
                        break;
                    }
                }
            } else {
                this.kind = new PhraseMid(this._io, this, this._root);
            }
            this._unnamed3 = this._io.readBytes(1L);
            this.k1 = this._io.readU1();
            this._unnamed5 = this._io.readBytes(1L);
            this.k2 = this._io.readU1();
            this._unnamed7 = this._io.readBytes(1L);
            this.b = this._io.readU1();
            this.beat2 = this._io.readU2be();
            this.beat3 = this._io.readU2be();
            this.beat4 = this._io.readU2be();
            this._unnamed12 = this._io.readBytes(1L);
            this.k3 = this._io.readU1();
            this._unnamed14 = this._io.readBytes(1L);
            this.fill = this._io.readU1();
            this.beatFill = this._io.readU2be();
        }

        public int index() {
            return this.index;
        }

        public int beat() {
            return this.beat;
        }

        public KaitaiStruct kind() {
            return this.kind;
        }

        public byte[] _unnamed3() {
            return this._unnamed3;
        }

        public int k1() {
            return this.k1;
        }

        public byte[] _unnamed5() {
            return this._unnamed5;
        }

        public int k2() {
            return this.k2;
        }

        public byte[] _unnamed7() {
            return this._unnamed7;
        }

        public int b() {
            return this.b;
        }

        public int beat2() {
            return this.beat2;
        }

        public int beat3() {
            return this.beat3;
        }

        public int beat4() {
            return this.beat4;
        }

        public byte[] _unnamed12() {
            return this._unnamed12;
        }

        public int k3() {
            return this.k3;
        }

        public byte[] _unnamed14() {
            return this._unnamed14;
        }

        public int fill() {
            return this.fill;
        }

        public int beatFill() {
            return this.beatFill;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public SongStructureBody _parent() {
            return this._parent;
        }
    }

    public static class VbrTag
    extends KaitaiStruct {
        private long _unnamed0;
        private ArrayList<Long> index;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static VbrTag fromFile(String fileName) throws IOException {
            return new VbrTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public VbrTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public VbrTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public VbrTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this._unnamed0 = this._io.readU4be();
            this.index = new ArrayList();
            for (int i = 0; i < 400; ++i) {
                this.index.add(this._io.readU4be());
            }
        }

        public long _unnamed0() {
            return this._unnamed0;
        }

        public ArrayList<Long> index() {
            return this.index;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class CueExtendedEntry
    extends KaitaiStruct {
        private byte[] magic;
        private long lenHeader;
        private long lenEntry;
        private long hotCue;
        private CueEntryType type;
        private byte[] _unnamed5;
        private long time;
        private long loopTime;
        private int colorId;
        private byte[] _unnamed9;
        private int loopNumerator;
        private int loopDenominator;
        private Long lenComment;
        private String comment;
        private Integer colorCode;
        private Integer colorRed;
        private Integer colorGreen;
        private Integer colorBlue;
        private byte[] _unnamed18;
        private RekordboxAnlz _root;
        private CueExtendedTag _parent;

        public static CueExtendedEntry fromFile(String fileName) throws IOException {
            return new CueExtendedEntry((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public CueExtendedEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CueExtendedEntry(KaitaiStream _io, CueExtendedTag _parent) {
            this(_io, _parent, null);
        }

        public CueExtendedEntry(KaitaiStream _io, CueExtendedTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.magic = this._io.readBytes(4L);
            if (!Arrays.equals(this.magic(), new byte[]{80, 67, 80, 50})) {
                throw new KaitaiStream.ValidationNotEqualError(new byte[]{80, 67, 80, 50}, this.magic(), this._io(), "/types/cue_extended_entry/seq/0");
            }
            this.lenHeader = this._io.readU4be();
            this.lenEntry = this._io.readU4be();
            this.hotCue = this._io.readU4be();
            this.type = CueEntryType.byId(this._io.readU1());
            this._unnamed5 = this._io.readBytes(3L);
            this.time = this._io.readU4be();
            this.loopTime = this._io.readU4be();
            this.colorId = this._io.readU1();
            this._unnamed9 = this._io.readBytes(7L);
            this.loopNumerator = this._io.readU2be();
            this.loopDenominator = this._io.readU2be();
            if (this.lenEntry() > 43L) {
                this.lenComment = this._io.readU4be();
            }
            if (this.lenEntry() > 43L) {
                this.comment = new String(this._io.readBytes(this.lenComment().longValue()), Charset.forName("utf-16be"));
            }
            if (this.lenEntry() - this.lenComment() > 44L) {
                this.colorCode = this._io.readU1();
            }
            if (this.lenEntry() - this.lenComment() > 45L) {
                this.colorRed = this._io.readU1();
            }
            if (this.lenEntry() - this.lenComment() > 46L) {
                this.colorGreen = this._io.readU1();
            }
            if (this.lenEntry() - this.lenComment() > 47L) {
                this.colorBlue = this._io.readU1();
            }
            if (this.lenEntry() - this.lenComment() > 48L) {
                this._unnamed18 = this._io.readBytes(this.lenEntry() - 48L - this.lenComment());
            }
        }

        public byte[] magic() {
            return this.magic;
        }

        public long lenHeader() {
            return this.lenHeader;
        }

        public long lenEntry() {
            return this.lenEntry;
        }

        public long hotCue() {
            return this.hotCue;
        }

        public CueEntryType type() {
            return this.type;
        }

        public byte[] _unnamed5() {
            return this._unnamed5;
        }

        public long time() {
            return this.time;
        }

        public long loopTime() {
            return this.loopTime;
        }

        public int colorId() {
            return this.colorId;
        }

        public byte[] _unnamed9() {
            return this._unnamed9;
        }

        public int loopNumerator() {
            return this.loopNumerator;
        }

        public int loopDenominator() {
            return this.loopDenominator;
        }

        public Long lenComment() {
            return this.lenComment;
        }

        public String comment() {
            return this.comment;
        }

        public Integer colorCode() {
            return this.colorCode;
        }

        public Integer colorRed() {
            return this.colorRed;
        }

        public Integer colorGreen() {
            return this.colorGreen;
        }

        public Integer colorBlue() {
            return this.colorBlue;
        }

        public byte[] _unnamed18() {
            return this._unnamed18;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public CueExtendedTag _parent() {
            return this._parent;
        }
    }

    public static class SongStructureTag
    extends KaitaiStruct {
        private Integer c;
        private byte[] mask;
        private Integer rawMood;
        private Boolean isMasked;
        private long lenEntryBytes;
        private int lenEntries;
        private SongStructureBody body;
        private RekordboxAnlz _root;
        private TaggedSection _parent;
        private byte[] _raw_body;
        private byte[] _raw__raw_body;

        public static SongStructureTag fromFile(String fileName) throws IOException {
            return new SongStructureTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SongStructureTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SongStructureTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public SongStructureTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            byte[] byArray;
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU2be();
            this._raw__raw_body = this._io.readBytesFull();
            if (this.isMasked().booleanValue()) {
                byArray = this.mask();
            } else {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 0;
            }
            this._raw_body = KaitaiStream.processXor((byte[])this._raw__raw_body, (byte[])byArray);
            ByteBufferKaitaiStream _io__raw_body = new ByteBufferKaitaiStream(this._raw_body);
            this.body = new SongStructureBody((KaitaiStream)_io__raw_body, this, this._root);
        }

        public Integer c() {
            if (this.c != null) {
                return this.c;
            }
            int _tmp = this.lenEntries();
            this.c = _tmp;
            return this.c;
        }

        public byte[] mask() {
            if (this.mask != null) {
                return this.mask;
            }
            this.mask = new byte[]{(byte)(203 + this.c()), (byte)(225 + this.c()), (byte)(238 + this.c()), (byte)(250 + this.c()), (byte)(229 + this.c()), (byte)(238 + this.c()), (byte)(173 + this.c()), (byte)(238 + this.c()), (byte)(233 + this.c()), (byte)(210 + this.c()), (byte)(233 + this.c()), (byte)(235 + this.c()), (byte)(225 + this.c()), (byte)(233 + this.c()), (byte)(243 + this.c()), (byte)(232 + this.c()), (byte)(233 + this.c()), (byte)(244 + this.c()), (byte)(225 + this.c())};
            return this.mask;
        }

        public Integer rawMood() {
            if (this.rawMood != null) {
                return this.rawMood;
            }
            long _pos = this._io.pos();
            this._io.seek(6);
            this.rawMood = this._io.readU2be();
            this._io.seek(_pos);
            return this.rawMood;
        }

        public Boolean isMasked() {
            if (this.isMasked != null) {
                return this.isMasked;
            }
            boolean _tmp = this.rawMood() > 20;
            this.isMasked = _tmp;
            return this.isMasked;
        }

        public long lenEntryBytes() {
            return this.lenEntryBytes;
        }

        public int lenEntries() {
            return this.lenEntries;
        }

        public SongStructureBody body() {
            return this.body;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }

        public byte[] _raw_body() {
            return this._raw_body;
        }

        public byte[] _raw__raw_body() {
            return this._raw__raw_body;
        }
    }

    public static class WaveScrollTag
    extends KaitaiStruct {
        private long lenEntryBytes;
        private long lenEntries;
        private long _unnamed2;
        private byte[] entries;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static WaveScrollTag fromFile(String fileName) throws IOException {
            return new WaveScrollTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public WaveScrollTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WaveScrollTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WaveScrollTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU4be();
            this._unnamed2 = this._io.readU4be();
            this.entries = this._io.readBytes(this.lenEntries() * this.lenEntryBytes());
        }

        public long lenEntryBytes() {
            return this.lenEntryBytes;
        }

        public long lenEntries() {
            return this.lenEntries;
        }

        public long _unnamed2() {
            return this._unnamed2;
        }

        public byte[] entries() {
            return this.entries;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class PhraseHigh
    extends KaitaiStruct {
        private MoodHighPhrase id;
        private RekordboxAnlz _root;
        private SongStructureEntry _parent;

        public static PhraseHigh fromFile(String fileName) throws IOException {
            return new PhraseHigh((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public PhraseHigh(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PhraseHigh(KaitaiStream _io, SongStructureEntry _parent) {
            this(_io, _parent, null);
        }

        public PhraseHigh(KaitaiStream _io, SongStructureEntry _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = MoodHighPhrase.byId(this._io.readU2be());
        }

        public MoodHighPhrase id() {
            return this.id;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public SongStructureEntry _parent() {
            return this._parent;
        }
    }

    public static class WaveColorPreviewTag
    extends KaitaiStruct {
        private long lenEntryBytes;
        private long lenEntries;
        private long _unnamed2;
        private byte[] entries;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static WaveColorPreviewTag fromFile(String fileName) throws IOException {
            return new WaveColorPreviewTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public WaveColorPreviewTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WaveColorPreviewTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WaveColorPreviewTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.lenEntryBytes = this._io.readU4be();
            this.lenEntries = this._io.readU4be();
            this._unnamed2 = this._io.readU4be();
            this.entries = this._io.readBytes(this.lenEntries() * this.lenEntryBytes());
        }

        public long lenEntryBytes() {
            return this.lenEntryBytes;
        }

        public long lenEntries() {
            return this.lenEntries;
        }

        public long _unnamed2() {
            return this._unnamed2;
        }

        public byte[] entries() {
            return this.entries;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class SongStructureBody
    extends KaitaiStruct {
        private TrackMood mood;
        private byte[] _unnamed1;
        private int endBeat;
        private byte[] _unnamed3;
        private TrackBank bank;
        private byte[] _unnamed5;
        private ArrayList<SongStructureEntry> entries;
        private RekordboxAnlz _root;
        private SongStructureTag _parent;

        public static SongStructureBody fromFile(String fileName) throws IOException {
            return new SongStructureBody((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SongStructureBody(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SongStructureBody(KaitaiStream _io, SongStructureTag _parent) {
            this(_io, _parent, null);
        }

        public SongStructureBody(KaitaiStream _io, SongStructureTag _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.mood = TrackMood.byId(this._io.readU2be());
            this._unnamed1 = this._io.readBytes(6L);
            this.endBeat = this._io.readU2be();
            this._unnamed3 = this._io.readBytes(2L);
            this.bank = TrackBank.byId(this._io.readU1());
            this._unnamed5 = this._io.readBytes(1L);
            this.entries = new ArrayList();
            for (int i = 0; i < this._parent().lenEntries(); ++i) {
                this.entries.add(new SongStructureEntry(this._io, this, this._root));
            }
        }

        public TrackMood mood() {
            return this.mood;
        }

        public byte[] _unnamed1() {
            return this._unnamed1;
        }

        public int endBeat() {
            return this.endBeat;
        }

        public byte[] _unnamed3() {
            return this._unnamed3;
        }

        public TrackBank bank() {
            return this.bank;
        }

        public byte[] _unnamed5() {
            return this._unnamed5;
        }

        public ArrayList<SongStructureEntry> entries() {
            return this.entries;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public SongStructureTag _parent() {
            return this._parent;
        }
    }

    public static class BeatGridTag
    extends KaitaiStruct {
        private long _unnamed0;
        private long _unnamed1;
        private long numBeats;
        private ArrayList<BeatGridBeat> beats;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static BeatGridTag fromFile(String fileName) throws IOException {
            return new BeatGridTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public BeatGridTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public BeatGridTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public BeatGridTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this._unnamed0 = this._io.readU4be();
            this._unnamed1 = this._io.readU4be();
            this.numBeats = this._io.readU4be();
            this.beats = new ArrayList();
            int i = 0;
            while ((long)i < this.numBeats()) {
                this.beats.add(new BeatGridBeat(this._io, this, this._root));
                ++i;
            }
        }

        public long _unnamed0() {
            return this._unnamed0;
        }

        public long _unnamed1() {
            return this._unnamed1;
        }

        public long numBeats() {
            return this.numBeats;
        }

        public ArrayList<BeatGridBeat> beats() {
            return this.beats;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class WavePreviewTag
    extends KaitaiStruct {
        private long lenData;
        private long _unnamed1;
        private byte[] data;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static WavePreviewTag fromFile(String fileName) throws IOException {
            return new WavePreviewTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public WavePreviewTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public WavePreviewTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public WavePreviewTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.lenData = this._io.readU4be();
            this._unnamed1 = this._io.readU4be();
            if (this._parent().lenTag() > this._parent().lenHeader()) {
                this.data = this._io.readBytes(this.lenData());
            }
        }

        public long lenData() {
            return this.lenData;
        }

        public long _unnamed1() {
            return this._unnamed1;
        }

        public byte[] data() {
            return this.data;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class PathTag
    extends KaitaiStruct {
        private long lenPath;
        private String path;
        private RekordboxAnlz _root;
        private TaggedSection _parent;

        public static PathTag fromFile(String fileName) throws IOException {
            return new PathTag((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public PathTag(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PathTag(KaitaiStream _io, TaggedSection _parent) {
            this(_io, _parent, null);
        }

        public PathTag(KaitaiStream _io, TaggedSection _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.lenPath = this._io.readU4be();
            if (this.lenPath() > 1L) {
                this.path = new String(this._io.readBytes(this.lenPath() - 2L), Charset.forName("utf-16be"));
            }
        }

        public long lenPath() {
            return this.lenPath;
        }

        public String path() {
            return this.path;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public TaggedSection _parent() {
            return this._parent;
        }
    }

    public static class PhraseMid
    extends KaitaiStruct {
        private MoodMidPhrase id;
        private RekordboxAnlz _root;
        private SongStructureEntry _parent;

        public static PhraseMid fromFile(String fileName) throws IOException {
            return new PhraseMid((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public PhraseMid(KaitaiStream _io) {
            this(_io, null, null);
        }

        public PhraseMid(KaitaiStream _io, SongStructureEntry _parent) {
            this(_io, _parent, null);
        }

        public PhraseMid(KaitaiStream _io, SongStructureEntry _parent, RekordboxAnlz _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = MoodMidPhrase.byId(this._io.readU2be());
        }

        public MoodMidPhrase id() {
            return this.id;
        }

        public RekordboxAnlz _root() {
            return this._root;
        }

        public SongStructureEntry _parent() {
            return this._parent;
        }
    }

    public static enum MoodLowPhrase {
        INTRO(1L),
        VERSE_1(2L),
        VERSE_1B(3L),
        VERSE_1C(4L),
        VERSE_2(5L),
        VERSE_2B(6L),
        VERSE_2C(7L),
        BRIDGE(8L),
        CHORUS(9L),
        OUTRO(10L);

        private final long id;
        private static final Map<Long, MoodLowPhrase> byId;

        private MoodLowPhrase(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static MoodLowPhrase byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, MoodLowPhrase>(10);
            for (MoodLowPhrase e : MoodLowPhrase.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum MoodMidPhrase {
        INTRO(1L),
        VERSE_1(2L),
        VERSE_2(3L),
        VERSE_3(4L),
        VERSE_4(5L),
        VERSE_5(6L),
        VERSE_6(7L),
        BRIDGE(8L),
        CHORUS(9L),
        OUTRO(10L);

        private final long id;
        private static final Map<Long, MoodMidPhrase> byId;

        private MoodMidPhrase(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static MoodMidPhrase byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, MoodMidPhrase>(10);
            for (MoodMidPhrase e : MoodMidPhrase.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum TrackMood {
        HIGH(1L),
        MID(2L),
        LOW(3L);

        private final long id;
        private static final Map<Long, TrackMood> byId;

        private TrackMood(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static TrackMood byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, TrackMood>(3);
            for (TrackMood e : TrackMood.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum SectionTags {
        CUES_2(1346588466L),
        CUES(1346588482L),
        PATH(1347441736L),
        BEAT_GRID(1347507290L),
        SONG_STRUCTURE(1347638089L),
        VBR(1347830354L),
        WAVE_PREVIEW(1347895638L),
        WAVE_TINY(1347900978L),
        WAVE_SCROLL(1347900979L),
        WAVE_COLOR_PREVIEW(1347900980L),
        WAVE_COLOR_SCROLL(1347900981L);

        private final long id;
        private static final Map<Long, SectionTags> byId;

        private SectionTags(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static SectionTags byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, SectionTags>(11);
            for (SectionTags e : SectionTags.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum CueEntryType {
        MEMORY_CUE(1L),
        LOOP(2L);

        private final long id;
        private static final Map<Long, CueEntryType> byId;

        private CueEntryType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static CueEntryType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, CueEntryType>(2);
            for (CueEntryType e : CueEntryType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum TrackBank {
        DEFAULT(0L),
        COOL(1L),
        NATURAL(2L),
        HOT(3L),
        SUBTLE(4L),
        WARM(5L),
        VIVID(6L),
        CLUB_1(7L),
        CLUB_2(8L);

        private final long id;
        private static final Map<Long, TrackBank> byId;

        private TrackBank(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static TrackBank byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, TrackBank>(9);
            for (TrackBank e : TrackBank.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum MoodHighPhrase {
        INTRO(1L),
        UP(2L),
        DOWN(3L),
        CHORUS(5L),
        OUTRO(6L);

        private final long id;
        private static final Map<Long, MoodHighPhrase> byId;

        private MoodHighPhrase(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static MoodHighPhrase byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, MoodHighPhrase>(5);
            for (MoodHighPhrase e : MoodHighPhrase.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum CueListType {
        MEMORY_CUES(0L),
        HOT_CUES(1L);

        private final long id;
        private static final Map<Long, CueListType> byId;

        private CueListType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static CueListType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, CueListType>(2);
            for (CueListType e : CueListType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum CueEntryStatus {
        DISABLED(0L),
        ENABLED(1L),
        ACTIVE_LOOP(4L);

        private final long id;
        private static final Map<Long, CueEntryStatus> byId;

        private CueEntryStatus(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static CueEntryStatus byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, CueEntryStatus>(3);
            for (CueEntryStatus e : CueEntryStatus.values()) {
                byId.put(e.id(), e);
            }
        }
    }
}

