/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.diff;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.deflaker.diff.ClassInfo;
import org.deflaker.diff.Edit;
import org.deflaker.diff.EditedFile;
import org.deflaker.diff.FieldInfo;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class LineAnalyzer {
    public static void main(String[] args) throws CorruptObjectException, MissingObjectException, IOException {
        HashMap<String, ClassInfo> edits = LineAnalyzer.getChanges("/Users/jon/Documents/GMU/Projects/surefire-diff-coverage/experiments/okhttp/.git", "d173c9e908a8ce1e9e02e79d16e12aa2905d724f");
        for (ClassInfo e : edits.values()) {
            System.out.println(e.className + e.hasStructuralProblems + ": " + e.edits);
        }
    }

    static boolean isEdited(LinkedList<Edit> edits, CompilationUnit root, ASTNode node) {
        int startLine = root.getLineNumber(node.getStartPosition());
        if (node instanceof BodyDeclaration && ((BodyDeclaration)node).getJavadoc() != null) {
            startLine = root.getLineNumber(node.getStartPosition() + ((BodyDeclaration)node).getJavadoc().getLength() + 1);
        }
        int endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
        for (Edit e : edits) {
            if (!e.isInRange(startLine, endLine)) continue;
            return true;
        }
        return false;
    }

    public static void collectStructuralElements(final EditedFile e, byte[] src, final LinkedList<Edit> edits, final boolean isNew) throws FileNotFoundException, UnsupportedEncodingException {
        ASTParser p = ASTParser.newParser((int)8);
        p.setBindingsRecovery(false);
        p.setResolveBindings(false);
        p.setUnitName("App.java");
        p.setEnvironment(new String[0], new String[0], new String[0], true);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        p.setCompilerOptions((Map)options);
        p.setKind(8);
        p.setSource(new String(src, "UTF-8").toCharArray());
        final CompilationUnit root = (CompilationUnit)p.createAST(null);
        for (IProblem prob : root.getProblems()) {
            System.out.println(prob);
        }
        final HashSet ret = new HashSet();
        root.accept(new ASTVisitor(){
            ClassInfo thisClass = null;
            HashSet<String> constructors = new HashSet();
            boolean constructorsRelevant;
            String packageName;

            public boolean visit(PackageDeclaration node) {
                this.packageName = node.getName().getFullyQualifiedName();
                return super.visit(node);
            }

            public void endVisit(CompilationUnit node) {
                if (this.constructorsRelevant) {
                    ret.addAll(this.constructors);
                }
            }

            public void endVisit(TypeDeclaration node) {
                this.thisClass = this.thisClass.parent;
                super.endVisit(node);
            }

            public boolean visit(AnonymousClassDeclaration node) {
                String name = this.thisClass.className + "$" + this.thisClass.anonCounter;
                ++this.thisClass.anonCounter;
                ClassInfo newThisClass = new ClassInfo();
                newThisClass.className = name;
                newThisClass.parent = this.thisClass;
                this.thisClass = newThisClass;
                LinkedList<Edit> editsThisType = new LinkedList<Edit>();
                int startLine = root.getLineNumber(node.getStartPosition());
                int endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                for (Edit e2 : edits) {
                    if (e2.editStart < startLine || e2.editEnd > endLine) continue;
                    editsThisType.add(e2);
                }
                this.thisClass.edits = editsThisType;
                this.thisClass.filterEditsFromParents();
                if (isNew) {
                    e.newClasses.put(name.replace('.', '/'), this.thisClass);
                } else {
                    e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                }
                return super.visit(node);
            }

            public void endVisit(AnonymousClassDeclaration node) {
                this.thisClass = this.thisClass.parent;
                super.endVisit(node);
            }

            public boolean visit(EnumDeclaration node) {
                String name = (this.packageName == null ? "" : this.packageName + ".") + node.getName().toString();
                if (this.thisClass == null) {
                    this.thisClass = new ClassInfo();
                    this.thisClass.edits = new LinkedList();
                    this.thisClass.className = name.replace('.', '/');
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                }
                if (this.thisClass.className == null) {
                    this.thisClass.className = name.replace('.', '/');
                }
                return super.visit(node);
            }

            public boolean visit(TypeDeclaration node) {
                String name = (this.packageName == null ? "" : this.packageName + ".") + node.getName().toString();
                name = name.replace('.', '/');
                if (this.thisClass == null) {
                    this.thisClass = new ClassInfo();
                    this.thisClass.edits = new LinkedList(edits);
                    this.thisClass.className = name;
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                }
                if (this.thisClass.className != null && !this.thisClass.className.equals(name)) {
                    ClassInfo newThisClass = new ClassInfo();
                    newThisClass.className = name = this.thisClass.className + "$" + node.getName().toString();
                    this.thisClass.innerClasses.add(newThisClass);
                    newThisClass.parent = this.thisClass;
                    this.thisClass = newThisClass;
                    LinkedList<Edit> editsThisType = new LinkedList<Edit>();
                    int startLine = root.getLineNumber(node.getStartPosition());
                    int endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                    for (Edit e2 : edits) {
                        if (e2.editStart < startLine || e2.editEnd > endLine) continue;
                        editsThisType.add(e2);
                    }
                    this.thisClass.edits = editsThisType;
                    this.thisClass.filterEditsFromParents();
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                }
                if (node.getSuperclassType() != null) {
                    this.thisClass.superName = node.getSuperclassType().toString();
                }
                this.thisClass.className = name;
                return super.visit(node);
            }

            private boolean visitAnnotation(Annotation node) {
                if (LineAnalyzer.isEdited(edits, root, (ASTNode)node)) {
                    this.thisClass.hasEditedAnnotation = true;
                }
                return true;
            }

            public boolean visit(MarkerAnnotation node) {
                return this.visitAnnotation((Annotation)node);
            }

            public boolean visit(SingleMemberAnnotation node) {
                return this.visitAnnotation((Annotation)node);
            }

            public boolean visit(NormalAnnotation node) {
                return this.visitAnnotation((Annotation)node);
            }

            public boolean visit(FieldDeclaration node) {
                for (Object c : node.fragments()) {
                    if (!(c instanceof VariableDeclarationFragment)) continue;
                    VariableDeclarationFragment f = (VariableDeclarationFragment)c;
                    Expression initializer = f.getInitializer();
                    FieldInfo fi = new FieldInfo();
                    fi.name = f.getName().toString();
                    fi.desc = node.getType().toString();
                    if (initializer != null) {
                        fi.init = initializer.toString();
                    }
                    this.thisClass.fields.add(fi);
                }
                return true;
            }

            String toDesc(String binaryName) {
                if (binaryName.length() == 1) {
                    return binaryName;
                }
                if (binaryName.charAt(0) == '[') {
                    return binaryName.replace('.', '/');
                }
                return "L" + binaryName.replace('.', '/') + ";";
            }

            public boolean visit(MethodDeclaration node) {
                StringBuffer fq = new StringBuffer();
                String name = node.isConstructor() ? "<init>" : node.getName().toString();
                fq.append('(');
                boolean hasParams = false;
                for (Object p : node.parameters()) {
                    SingleVariableDeclaration d = (SingleVariableDeclaration)p;
                    ITypeBinding b = d.getType().resolveBinding();
                    if (b != null) {
                        fq.append(this.toDesc(b.getBinaryName()));
                    } else {
                        fq.append(this.toDesc(d.getType().toString()));
                    }
                    hasParams = true;
                }
                if (hasParams) {
                    fq.deleteCharAt(fq.length() - 1);
                }
                fq.append(')');
                if (node.isConstructor()) {
                    fq.append('V');
                } else {
                    ITypeBinding b = node.getReturnType2().resolveBinding();
                    if (b != null) {
                        fq.append(this.toDesc(b.getBinaryName()));
                    } else {
                        fq.append(this.toDesc(node.getReturnType2().toString()));
                    }
                }
                this.thisClass.methods.add(new ClassInfo.MethodInfo(fq.toString(), name, this.thisClass.className));
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, ClassInfo> getChanges(String gitDir, String _commit) throws CorruptObjectException, MissingObjectException, IOException {
        HashMap<String, ClassInfo> ret = new HashMap<String, ClassInfo>();
        try (RevWalk revWalk = null;){
            Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(new File(gitDir))).build();
            ObjectId com = repo.resolve(_commit);
            revWalk = new RevWalk(repo);
            RevCommit commit = revWalk.parseCommit((AnyObjectId)com);
            CanonicalTreeParser thisCommParser = new CanonicalTreeParser();
            ObjectReader reader = repo.newObjectReader();
            RevCommit toDiff = null;
            if (System.getProperty("diffcov.parentCommit") != null) {
                ObjectId d = repo.resolve(System.getProperty("diffcov.parentCommit"));
                toDiff = revWalk.parseCommit((AnyObjectId)d);
            }
            if (toDiff == null) {
                toDiff = commit.getParent(0);
            }
            RevCommit p = toDiff;
            thisCommParser.reset(reader, (AnyObjectId)commit.getTree());
            p = revWalk.parseCommit((AnyObjectId)p.getId());
            CanonicalTreeParser parentParser = new CanonicalTreeParser();
            parentParser.reset(reader, (AnyObjectId)p.getTree());
            DiffFormatter f = new DiffFormatter((OutputStream)System.out);
            f.setRepository(repo);
            List entries = f.scan((AbstractTreeIterator)parentParser, (AbstractTreeIterator)thisCommParser);
            for (DiffEntry diff : entries) {
                if (diff.getChangeType() == DiffEntry.ChangeType.ADD && diff.getNewPath().endsWith(".java")) {
                    EditedFile ef = new EditedFile();
                    ef.fileName = Paths.get(gitDir, "../", diff.getNewPath()).toString();
                    AbbreviatedObjectId newId = diff.getNewId();
                    ObjectLoader loader = repo.open((AnyObjectId)newId.toObjectId());
                    LinkedList edits = new LinkedList();
                    LineAnalyzer.collectStructuralElements(ef, loader.getBytes(), edits, true);
                    for (ClassInfo ci : ef.newClasses.values()) {
                        ci.hasStructuralProblems = true;
                        ret.put(ci.className.replace('.', '/'), ci);
                    }
                    continue;
                }
                if (diff.getNewPath() != null && diff.getNewPath().endsWith(".java") || diff.getOldPath() != null && diff.getOldPath().endsWith(".java")) {
                    EditList el = f.toFileHeader(diff).toEditList();
                    String filePath = Paths.get(gitDir, "../", diff.getNewPath()).toString();
                    LinkedList<Edit> edits = new LinkedList<Edit>();
                    for (org.eclipse.jgit.diff.Edit e : el) {
                        edits.add(new Edit(e.getBeginB() + 1, e.getEndB()));
                    }
                    EditedFile ef = new EditedFile();
                    ef.fileName = filePath;
                    if (diff.getChangeType() != DiffEntry.ChangeType.MODIFY) continue;
                    AbbreviatedObjectId newId = diff.getNewId();
                    ObjectLoader loader = repo.open((AnyObjectId)newId.toObjectId());
                    LineAnalyzer.collectStructuralElements(ef, loader.getBytes(), edits, true);
                    edits = new LinkedList();
                    for (org.eclipse.jgit.diff.Edit e : el) {
                        edits.add(new Edit(e.getBeginA() + 1, e.getEndA()));
                    }
                    AbbreviatedObjectId oldId = diff.getOldId();
                    loader = repo.open((AnyObjectId)oldId.toObjectId());
                    LineAnalyzer.collectStructuralElements(ef, loader.getBytes(), edits, false);
                    for (String name : ef.newClasses.keySet()) {
                        ClassInfo newCI = ef.newClasses.get(name);
                        ClassInfo old = ef.oldClasses.get(name);
                        if (old == null) {
                            newCI.hasStructuralProblems = true;
                            continue;
                        }
                        if (newCI.hasEditedAnnotation) {
                            newCI.hasStructuralProblems = true;
                            continue;
                        }
                        if (newCI.equals((Object)old)) continue;
                        newCI.hasStructuralProblems = true;
                    }
                    for (ClassInfo ci : ef.newClasses.values()) {
                        ret.put(ci.className.replace('.', '/'), ci);
                    }
                    continue;
                }
                ret.put(diff.getNewPath(), null);
            }
            f.close();
            HashMap<String, ClassInfo> hashMap = ret;
            return hashMap;
        }
    }
}

