/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.diff;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.deflaker.diff.ClassInfo;
import org.deflaker.diff.Edit;
import org.deflaker.diff.EditedFile;
import org.deflaker.diff.FieldInfo;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class PreciseLineAnalyzer {
    public static boolean PRINT_DEBUG = System.getenv("DIFFCOV_DEBUG") != null;
    private static int version_id;
    private static boolean LOG_VERBOSE_MYSQL;
    private static Connection db;
    private static PreparedStatement getCoverageClass;
    private static PreparedStatement getCoverageMethod;
    private static PreparedStatement insertCoverageClass;
    private static PreparedStatement insertCoverageMethod;
    private static PreparedStatement insertDiff;
    private static HashMap<String, Integer> cachedClasses;
    private static HashMap<String, Integer> cachedMethods;

    private static int getCovClassId(String clazz) throws SQLException {
        if (!cachedClasses.containsKey(clazz = clazz.replace('/', '.'))) {
            getCoverageClass.setString(1, clazz);
            getCoverageClass.executeQuery();
            ResultSet rs = getCoverageClass.getResultSet();
            if (rs.next()) {
                int r = rs.getInt(1);
                cachedClasses.put(clazz, r);
                rs.close();
            } else {
                rs.close();
                insertCoverageClass.setString(1, clazz);
                insertCoverageClass.executeUpdate();
                rs = insertCoverageClass.getGeneratedKeys();
                rs.next();
                int r = rs.getInt(1);
                rs.close();
                cachedClasses.put(clazz, r);
            }
        }
        return cachedClasses.get(clazz);
    }

    private static int getCovNameId(String clazz) throws SQLException {
        if (!cachedClasses.containsKey(clazz)) {
            getCoverageClass.setString(1, clazz);
            getCoverageClass.executeQuery();
            ResultSet rs = getCoverageClass.getResultSet();
            if (rs.next()) {
                int r = rs.getInt(1);
                cachedClasses.put(clazz, r);
                rs.close();
            } else {
                rs.close();
                insertCoverageClass.setString(1, clazz);
                insertCoverageClass.executeUpdate();
                rs = insertCoverageClass.getGeneratedKeys();
                rs.next();
                int r = rs.getInt(1);
                rs.close();
                cachedClasses.put(clazz, r);
            }
        }
        return cachedClasses.get(clazz);
    }

    private static int getCovMethodId(String meth) throws SQLException {
        if (!cachedMethods.containsKey(meth = meth.replace('/', '.'))) {
            getCoverageMethod.setString(1, meth);
            getCoverageMethod.executeQuery();
            ResultSet rs = getCoverageMethod.getResultSet();
            if (rs.next()) {
                int r = rs.getInt(1);
                cachedMethods.put(meth, r);
                rs.close();
            } else {
                rs.close();
                insertCoverageMethod.setString(1, meth);
                insertCoverageMethod.executeUpdate();
                rs = insertCoverageMethod.getGeneratedKeys();
                rs.next();
                int r = rs.getInt(1);
                rs.close();
                cachedMethods.put(meth, r);
            }
        }
        return cachedMethods.get(meth);
    }

    public static void main(String[] args) throws CorruptObjectException, MissingObjectException, IOException {
        if (args.length == 3) {
            version_id = Integer.valueOf(args[0]);
            LOG_VERBOSE_MYSQL = true;
        }
        HashMap<String, ClassInfo> edits = null;
        if (LOG_VERBOSE_MYSQL) {
            String classname = "com.mysql.jdbc.Driver";
            try {
                Driver d = (Driver)Class.forName(classname).newInstance();
                DriverManager.registerDriver(d);
                db = DriverManager.getConnection("jdbc:mysql://diffcov2017.c5smcgnslo73.us-east-1.rds.amazonaws.com/diffcov?user=diffcov&password=sqFycTgL35H5yegbe&useServerPrepStmts=false&rewriteBatchedStatements=true");
                getCoverageClass = db.prepareStatement("SELECT id FROM java_class WHERE name=?");
                insertCoverageClass = db.prepareStatement("INSERT INTO java_class (name) VALUES (?)", 1);
                insertDiff = db.prepareStatement("INSERT INTO evo_project_version_diff (version_id,java_class_id,statement_start,method,non_java,method_added,method_removed,class_added,super_changed,statement_end,is_backup) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                getCoverageMethod = db.prepareStatement("SELECT id FROM java_method WHERE name=?");
                insertCoverageMethod = db.prepareStatement("INSERT INTO java_method (name) VALUES (?)", 1);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException ex) {
                ex.printStackTrace();
            }
            edits = PreciseLineAnalyzer.getChanges(args[1], args[2], new String[0], new String[0]);
        } else {
            String[] sourcePath = new String[]{"/Users/jon/Documents/GMU/Projects/surefire-diff-coverage/experiments/canaryTravisRepo/src/main/java", "/Users/jon/Documents/GMU/Projects/surefire-diff-coverage/experiments/canaryTravisRepo/src/test/java"};
            String[] cp = new String[]{};
            edits = PreciseLineAnalyzer.getChanges("/Users/jon/Documents/GMU/Projects/surefire-diff-coverage/experiments/canaryTravisRepo/.git", "head", sourcePath, cp);
        }
        for (ClassInfo e : edits.values()) {
            System.out.println(e.className + e.startLine + "-" + e.endLine + " " + e.hasStructuralProblems + ": " + e.edits + ", " + e.newMethods);
            if (!LOG_VERBOSE_MYSQL) continue;
            try {
                int cid = PreciseLineAnalyzer.getCovClassId(e.className);
                for (Edit ed : e.edits) {
                    insertDiff.setInt(1, version_id);
                    insertDiff.setInt(2, cid);
                    insertDiff.setInt(3, e.startLine > ed.editStart ? e.startLine : ed.editStart);
                    insertDiff.setInt(4, 0);
                    insertDiff.setInt(5, 0);
                    insertDiff.setInt(6, 0);
                    insertDiff.setInt(7, 0);
                    insertDiff.setInt(8, 0);
                    insertDiff.setInt(9, 0);
                    insertDiff.setInt(10, e.endLine > 0 && e.endLine < ed.editEnd ? e.endLine : ed.editEnd);
                    insertDiff.setInt(11, 0);
                    insertDiff.addBatch();
                }
                if (e.hasStructuralProblems) {
                    insertDiff.setInt(1, version_id);
                    insertDiff.setInt(2, cid);
                    insertDiff.setInt(3, 0);
                    insertDiff.setInt(4, 0);
                    insertDiff.setInt(5, 0);
                    insertDiff.setInt(6, 0);
                    insertDiff.setInt(7, 0);
                    insertDiff.setInt(8, 0);
                    insertDiff.setInt(9, 0);
                    insertDiff.setInt(10, 0);
                    insertDiff.setInt(11, 0);
                    insertDiff.addBatch();
                    continue;
                }
                insertDiff.setInt(1, version_id);
                insertDiff.setInt(2, cid);
                insertDiff.setInt(3, 0);
                insertDiff.setInt(4, 0);
                insertDiff.setInt(5, 0);
                insertDiff.setInt(6, 0);
                insertDiff.setInt(7, 0);
                insertDiff.setInt(8, 0);
                insertDiff.setInt(9, 0);
                insertDiff.setInt(10, 0);
                insertDiff.setInt(11, 1);
                insertDiff.addBatch();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        if (LOG_VERBOSE_MYSQL) {
            try {
                insertDiff.executeBatch();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    static boolean isEdited(LinkedList<Edit> edits, CompilationUnit root, ASTNode node) {
        int startLine = root.getLineNumber(node.getStartPosition());
        if (node instanceof BodyDeclaration && ((BodyDeclaration)node).getJavadoc() != null) {
            startLine = root.getLineNumber(node.getStartPosition() + ((BodyDeclaration)node).getJavadoc().getLength() + 1);
        }
        int endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
        for (Edit e : edits) {
            if (!e.isInRange(startLine, endLine)) continue;
            return true;
        }
        return false;
    }

    public static void collectStructuralElements(final EditedFile e, byte[] src, final LinkedList<Edit> edits, final boolean isNew, String[] sourcePath, String[] cp) throws FileNotFoundException, UnsupportedEncodingException {
        ASTParser p = ASTParser.newParser((int)8);
        p.setUnitName(new File(e.fileName).getName());
        String[] encodings = new String[sourcePath.length];
        for (int i = 0; i < sourcePath.length; ++i) {
            encodings[i] = "UTF-8";
        }
        p.setEnvironment(cp, sourcePath, encodings, true);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        p.setCompilerOptions((Map)options);
        p.setKind(8);
        p.setSource(new String(src, "UTF-8").toCharArray());
        final CompilationUnit root = (CompilationUnit)p.createAST(null);
        if (PRINT_DEBUG) {
            for (IProblem prob : root.getProblems()) {
                System.err.println("Problem: " + prob);
            }
        }
        final HashSet ret = new HashSet();
        root.accept(new ASTVisitor(){
            ClassInfo thisClass = null;
            HashSet<String> constructors = new HashSet();
            boolean constructorsRelevant;
            String packageName;

            public boolean visit(PackageDeclaration node) {
                this.packageName = node.getName().getFullyQualifiedName();
                return super.visit(node);
            }

            public void endVisit(CompilationUnit node) {
                if (this.constructorsRelevant) {
                    ret.addAll(this.constructors);
                }
            }

            public void endVisit(TypeDeclaration node) {
                this.thisClass = this.thisClass.parent;
                super.endVisit(node);
            }

            public void endVisit(EnumDeclaration node) {
                this.thisClass = this.thisClass.parent;
                super.endVisit(node);
            }

            public boolean visit(AnonymousClassDeclaration node) {
                String name = this.thisClass.className + "$" + this.thisClass.anonCounter;
                ++this.thisClass.anonCounter;
                ClassInfo newThisClass = new ClassInfo();
                newThisClass.className = name;
                newThisClass.parent = this.thisClass;
                this.thisClass = newThisClass;
                LinkedList<Edit> editsThisType = new LinkedList<Edit>();
                int startLine = root.getLineNumber(node.getStartPosition());
                int endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                for (Edit e2 : edits) {
                    if (e2.editStart < startLine || e2.editEnd > endLine) continue;
                    editsThisType.add(e2);
                }
                this.thisClass.startLine = root.getLineNumber(node.getStartPosition());
                this.thisClass.endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                this.thisClass.edits = editsThisType;
                this.thisClass.filterEditsFromParents();
                if (isNew) {
                    e.newClasses.put(name.replace('.', '/'), this.thisClass);
                } else {
                    e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                }
                return super.visit(node);
            }

            public void endVisit(AnonymousClassDeclaration node) {
                this.thisClass = this.thisClass.parent;
                super.endVisit(node);
            }

            public boolean visit(EnumDeclaration node) {
                String name = (this.packageName == null ? "" : this.packageName + ".") + node.getName().toString();
                if (this.thisClass == null) {
                    this.thisClass = new ClassInfo();
                    this.thisClass.edits = new LinkedList();
                    this.thisClass.className = name.replace('.', '/');
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                }
                if (this.thisClass.className != null && !this.thisClass.className.equals(name)) {
                    ClassInfo newThisClass = new ClassInfo();
                    newThisClass.className = name = this.thisClass.className + "$" + node.getName().toString();
                    this.thisClass.innerClasses.add(newThisClass);
                    newThisClass.parent = this.thisClass;
                    this.thisClass = newThisClass;
                    LinkedList<Edit> editsThisType = new LinkedList<Edit>();
                    int startLine = root.getLineNumber(node.getStartPosition());
                    int endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                    for (Edit e2 : edits) {
                        if (!e2.isInRange(startLine, endLine)) continue;
                        editsThisType.add(e2);
                    }
                    this.thisClass.edits = editsThisType;
                    this.thisClass.startLine = root.getLineNumber(node.getStartPosition());
                    this.thisClass.endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                    this.thisClass.filterEditsFromParents();
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                } else if (this.thisClass.className == null) {
                    this.thisClass.className = name.replace('.', '/');
                }
                this.thisClass.startLine = root.getLineNumber(node.getStartPosition());
                this.thisClass.endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                return super.visit(node);
            }

            String toDesc(String binaryName) {
                if (binaryName.length() == 1) {
                    return binaryName;
                }
                if (binaryName.charAt(0) == '[') {
                    return binaryName.replace('.', '/');
                }
                return "L" + binaryName.replace('.', '/') + ";";
            }

            HashSet<ClassInfo.MethodInfo> getSuperMethods(ITypeBinding node) {
                HashSet<ClassInfo.MethodInfo> ret2 = new HashSet<ClassInfo.MethodInfo>();
                for (IMethodBinding b : node.getDeclaredMethods()) {
                    if (Modifier.isAbstract(b.getModifiers()) || Modifier.isPrivate(b.getModifiers())) continue;
                    StringBuilder fq = new StringBuilder();
                    String name = b.isConstructor() ? "<init>" : b.getName();
                    fq.append('(');
                    for (ITypeBinding p : b.getParameterTypes()) {
                        fq.append(this.toDesc(p.getBinaryName()));
                    }
                    fq.append(')');
                    if (b.isConstructor()) {
                        fq.append('V');
                    } else {
                        fq.append(this.toDesc(b.getReturnType().getBinaryName()));
                    }
                    ret2.add(new ClassInfo.MethodInfo(fq.toString(), name, node.getBinaryName().replace('.', '/')));
                }
                ITypeBinding superT = node.getSuperclass();
                if (superT != null) {
                    ret2.addAll(this.getSuperMethods(superT));
                }
                return ret2;
            }

            public boolean visit(AnnotationTypeDeclaration node) {
                String name = (this.packageName == null ? "" : this.packageName + ".") + node.getName().toString();
                name = name.replace('.', '/');
                if (this.thisClass == null) {
                    this.thisClass = new ClassInfo();
                    this.thisClass.edits = new LinkedList(edits);
                    this.thisClass.className = name;
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                    this.thisClass.startLine = root.getLineNumber(node.getStartPosition());
                    this.thisClass.endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                }
                return super.visit(node);
            }

            public boolean visit(TypeDeclaration node) {
                String name = (this.packageName == null ? "" : this.packageName + ".") + node.getName().toString();
                name = name.replace('.', '/');
                if (this.thisClass == null) {
                    this.thisClass = new ClassInfo();
                    this.thisClass.edits = new LinkedList(edits);
                    this.thisClass.className = name;
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                    this.thisClass.startLine = root.getLineNumber(node.getStartPosition());
                    this.thisClass.endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                }
                if (this.thisClass.className != null && !this.thisClass.className.equals(name)) {
                    ClassInfo newThisClass = new ClassInfo();
                    newThisClass.className = name = this.thisClass.className + "$" + node.getName().toString();
                    this.thisClass.innerClasses.add(newThisClass);
                    newThisClass.parent = this.thisClass;
                    this.thisClass = newThisClass;
                    LinkedList<Edit> editsThisType = new LinkedList<Edit>();
                    int startLine = root.getLineNumber(node.getStartPosition());
                    int endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                    for (Edit e2 : edits) {
                        if (e2.editStart < startLine || e2.editEnd > endLine) continue;
                        editsThisType.add(e2);
                    }
                    this.thisClass.edits = editsThisType;
                    this.thisClass.startLine = root.getLineNumber(node.getStartPosition());
                    this.thisClass.endLine = root.getLineNumber(node.getStartPosition() + node.getLength());
                    this.thisClass.filterEditsFromParents();
                    if (isNew) {
                        e.newClasses.put(name.replace('.', '/'), this.thisClass);
                    } else {
                        e.oldClasses.put(name.replace('.', '/'), this.thisClass);
                    }
                }
                if (node.getSuperclassType() != null) {
                    ITypeBinding superT;
                    this.thisClass.superName = node.getSuperclassType().toString();
                    if (isNew && (superT = node.getSuperclassType().resolveBinding()) != null) {
                        this.thisClass.superMethods = this.getSuperMethods(superT);
                    }
                }
                this.thisClass.className = name;
                return super.visit(node);
            }

            private boolean visitAnnotation(Annotation node) {
                if (PreciseLineAnalyzer.isEdited(edits, root, (ASTNode)node) && this.thisClass != null) {
                    if (node.getParent() instanceof MethodDeclaration) {
                        this.thisClass.methodsWithChangedAnnotations.add(this.toMethodInfo((MethodDeclaration)node.getParent()));
                    } else {
                        this.thisClass.hasEditedAnnotation = true;
                    }
                }
                return true;
            }

            public boolean visit(MarkerAnnotation node) {
                return this.visitAnnotation((Annotation)node);
            }

            public boolean visit(SingleMemberAnnotation node) {
                return this.visitAnnotation((Annotation)node);
            }

            public boolean visit(NormalAnnotation node) {
                return this.visitAnnotation((Annotation)node);
            }

            public boolean visit(FieldDeclaration node) {
                for (Object c : node.fragments()) {
                    if (!(c instanceof VariableDeclarationFragment)) continue;
                    VariableDeclarationFragment f = (VariableDeclarationFragment)c;
                    Expression initializer = f.getInitializer();
                    FieldInfo fi = new FieldInfo();
                    fi.name = f.getName().toString();
                    fi.desc = node.getType().toString();
                    if (initializer != null) {
                        fi.init = initializer.toString();
                    }
                    this.thisClass.fields.add(fi);
                }
                return true;
            }

            private ClassInfo.MethodInfo toMethodInfo(MethodDeclaration node) {
                StringBuffer fq = new StringBuffer();
                String name = node.isConstructor() ? "<init>" : node.getName().toString();
                fq.append('(');
                boolean hasParams = false;
                for (Object p : node.parameters()) {
                    SingleVariableDeclaration d = (SingleVariableDeclaration)p;
                    ITypeBinding b = d.getType().resolveBinding();
                    if (b != null && b.getBinaryName() != null) {
                        fq.append(this.toDesc(b.getBinaryName()));
                    } else {
                        fq.append(this.toDesc(d.getType().toString()));
                    }
                    hasParams = true;
                }
                if (hasParams) {
                    fq.deleteCharAt(fq.length() - 1);
                }
                fq.append(')');
                if (node.isConstructor()) {
                    fq.append('V');
                } else {
                    ITypeBinding b = node.getReturnType2().resolveBinding();
                    if (b != null && b.getBinaryName() != null) {
                        fq.append(this.toDesc(b.getBinaryName()));
                    } else {
                        fq.append(this.toDesc(node.getReturnType2().toString()));
                    }
                }
                return new ClassInfo.MethodInfo(fq.toString(), name, this.thisClass.className);
            }

            public boolean visit(MethodDeclaration node) {
                this.thisClass.methods.add(this.toMethodInfo(node));
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, ClassInfo> getChanges(String gitDir, String _commit, String[] sourcePath, String[] cp) throws CorruptObjectException, MissingObjectException, IOException {
        RevWalk revWalk = null;
        HashMap<String, ClassInfo> ret = new HashMap<String, ClassInfo>();
        HashMap methodsToTrack = new HashMap();
        try {
            Repository repo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(new File(gitDir))).build();
            ObjectId com = repo.resolve(_commit);
            revWalk = new RevWalk(repo);
            RevCommit commit = revWalk.parseCommit((AnyObjectId)com);
            CanonicalTreeParser thisCommParser = new CanonicalTreeParser();
            ObjectReader reader = repo.newObjectReader();
            RevCommit toDiff = null;
            if (System.getProperty("diffcov.parentCommit") != null) {
                ObjectId d = repo.resolve(System.getProperty("diffcov.parentCommit"));
                toDiff = revWalk.parseCommit((AnyObjectId)d);
            }
            if (toDiff == null) {
                toDiff = commit.getParent(0);
            }
            RevCommit p = toDiff;
            System.out.println("Diff'ing " + commit.name() + " against: " + p.getName());
            thisCommParser.reset(reader, (AnyObjectId)commit.getTree());
            p = revWalk.parseCommit((AnyObjectId)p.getId());
            CanonicalTreeParser parentParser = new CanonicalTreeParser();
            parentParser.reset(reader, (AnyObjectId)p.getTree());
            DiffFormatter f = new DiffFormatter((OutputStream)System.out);
            f.setRepository(repo);
            List entries = f.scan((AbstractTreeIterator)parentParser, (AbstractTreeIterator)thisCommParser);
            for (DiffEntry diff : entries) {
                if (diff.getChangeType() == DiffEntry.ChangeType.ADD && diff.getNewPath().endsWith(".java")) {
                    EditedFile ef = new EditedFile();
                    ef.fileName = Paths.get(gitDir, "../", diff.getNewPath()).toString();
                    AbbreviatedObjectId newId = diff.getNewId();
                    ObjectLoader loader = repo.open((AnyObjectId)newId.toObjectId());
                    LinkedList edits = new LinkedList();
                    PreciseLineAnalyzer.collectStructuralElements(ef, loader.getBytes(), edits, true, sourcePath, cp);
                    for (ClassInfo ci : ef.newClasses.values()) {
                        ci.hasStructuralProblems = true;
                        ret.put(ci.className.replace('.', '/'), ci);
                        if (insertDiff == null) continue;
                        try {
                            insertDiff.setInt(1, version_id);
                            insertDiff.setInt(2, PreciseLineAnalyzer.getCovClassId(ci.className));
                            insertDiff.setInt(3, 0);
                            insertDiff.setInt(4, 0);
                            insertDiff.setInt(5, 0);
                            insertDiff.setInt(6, 0);
                            insertDiff.setInt(7, 0);
                            insertDiff.setInt(8, 1);
                            insertDiff.setInt(9, 0);
                            insertDiff.setInt(10, 0);
                            insertDiff.setInt(11, 0);
                            insertDiff.addBatch();
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                    }
                    continue;
                }
                if (diff.getNewPath() != null && diff.getNewPath().endsWith(".java") || diff.getOldPath() != null && diff.getOldPath().endsWith(".java")) {
                    EditList el = f.toFileHeader(diff).toEditList();
                    String filePath = Paths.get(gitDir, "../", diff.getNewPath()).toString();
                    LinkedList<Edit> edits = new LinkedList<Edit>();
                    for (org.eclipse.jgit.diff.Edit e : el) {
                        edits.add(new Edit(e.getBeginB() + 1, e.getEndB()));
                    }
                    EditedFile ef = new EditedFile();
                    ef.fileName = filePath;
                    if (diff.getChangeType() != DiffEntry.ChangeType.MODIFY) continue;
                    AbbreviatedObjectId newId = diff.getNewId();
                    ObjectLoader loader = repo.open((AnyObjectId)newId.toObjectId());
                    PreciseLineAnalyzer.collectStructuralElements(ef, loader.getBytes(), edits, true, sourcePath, cp);
                    edits = new LinkedList();
                    for (org.eclipse.jgit.diff.Edit e : el) {
                        if (e.getEndA() == e.getBeginA()) continue;
                        edits.add(new Edit(e.getBeginA() + 1, e.getEndA()));
                    }
                    AbbreviatedObjectId oldId = diff.getOldId();
                    loader = repo.open((AnyObjectId)oldId.toObjectId());
                    PreciseLineAnalyzer.collectStructuralElements(ef, loader.getBytes(), edits, false, sourcePath, cp);
                    for (String name : ef.newClasses.keySet()) {
                        ClassInfo newCI = ef.newClasses.get(name);
                        ClassInfo old = ef.oldClasses.get(name);
                        if (old == null) {
                            if (insertDiff != null) {
                                try {
                                    insertDiff.setInt(1, version_id);
                                    insertDiff.setInt(2, PreciseLineAnalyzer.getCovClassId(newCI.className));
                                    insertDiff.setInt(3, 0);
                                    insertDiff.setInt(4, 0);
                                    insertDiff.setInt(5, 0);
                                    insertDiff.setInt(6, 0);
                                    insertDiff.setInt(7, 0);
                                    insertDiff.setInt(8, 1);
                                    insertDiff.setInt(9, 0);
                                    insertDiff.setInt(10, 0);
                                    insertDiff.setInt(11, 0);
                                    insertDiff.addBatch();
                                }
                                catch (SQLException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            newCI.hasStructuralProblems = true;
                            continue;
                        }
                        if (!PreciseLineAnalyzer.equals(newCI.superName, old.superName) && insertDiff != null) {
                            try {
                                insertDiff.setInt(1, version_id);
                                insertDiff.setInt(2, PreciseLineAnalyzer.getCovClassId(newCI.className));
                                insertDiff.setInt(3, 0);
                                insertDiff.setInt(4, 0);
                                insertDiff.setInt(5, 0);
                                insertDiff.setInt(6, 0);
                                insertDiff.setInt(7, 0);
                                insertDiff.setInt(8, 0);
                                insertDiff.setInt(9, 1);
                                insertDiff.setInt(10, 0);
                                insertDiff.setInt(11, 0);
                                insertDiff.addBatch();
                            }
                            catch (SQLException ex) {
                                ex.printStackTrace();
                            }
                        }
                        HashSet newMethods = new HashSet(newCI.methods);
                        newMethods.removeAll(old.methods);
                        HashSet removedMethods = new HashSet(old.methods);
                        removedMethods.removeAll(newCI.methods);
                        newCI.newMethods = new ArrayList();
                        newCI.methodsWithChangedAnnotations.removeAll(newMethods);
                        old.methodsWithChangedAnnotations.removeAll(removedMethods);
                        old.methodsWithChangedAnnotations.removeAll(newMethods);
                        if (newCI.equalsWithoutMethodsOrFields((Object)old) && !newCI.equals((Object)old)) {
                            if (PRINT_DEBUG) {
                                System.out.println("Examining " + newCI.className);
                                System.out.println("New methods: " + newMethods);
                                System.out.println("Removed methods: " + removedMethods);
                                System.out.println("Parent methods: " + newCI.superMethods);
                            }
                            if (LOG_VERBOSE_MYSQL) {
                                for (ClassInfo.MethodInfo s : newMethods) {
                                    try {
                                        insertDiff.setInt(1, version_id);
                                        insertDiff.setInt(2, PreciseLineAnalyzer.getCovClassId(newCI.className));
                                        insertDiff.setInt(3, 0);
                                        insertDiff.setInt(4, PreciseLineAnalyzer.getCovMethodId(s.name + s.desc));
                                        insertDiff.setInt(5, 0);
                                        insertDiff.setInt(6, 1);
                                        insertDiff.setInt(7, 0);
                                        insertDiff.setInt(8, 0);
                                        insertDiff.setInt(9, 0);
                                        insertDiff.setInt(10, 0);
                                        insertDiff.setInt(11, 0);
                                        insertDiff.addBatch();
                                    }
                                    catch (SQLException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                for (ClassInfo.MethodInfo s : removedMethods) {
                                    try {
                                        insertDiff.setInt(1, version_id);
                                        insertDiff.setInt(2, PreciseLineAnalyzer.getCovClassId(newCI.className));
                                        insertDiff.setInt(3, 0);
                                        insertDiff.setInt(4, PreciseLineAnalyzer.getCovMethodId(s.name + s.desc));
                                        insertDiff.setInt(5, 0);
                                        insertDiff.setInt(6, 0);
                                        insertDiff.setInt(7, 1);
                                        insertDiff.setInt(8, 0);
                                        insertDiff.setInt(9, 0);
                                        insertDiff.setInt(10, 0);
                                        insertDiff.setInt(11, 0);
                                        insertDiff.addBatch();
                                    }
                                    catch (SQLException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                            if (!removedMethods.isEmpty() && newCI.superMethods == null && newCI.superName != null || newCI.superName == null) continue;
                            for (ClassInfo.MethodInfo s : removedMethods) {
                                for (ClassInfo.MethodInfo m : newCI.superMethods) {
                                    if (!s.name.equals(m.name) || !s.desc.equals(m.desc)) continue;
                                    if (!methodsToTrack.containsKey(m.owner)) {
                                        methodsToTrack.put(m.owner, new HashSet());
                                    }
                                    ((HashSet)methodsToTrack.get(m.owner)).add(m);
                                    if (!PRINT_DEBUG) continue;
                                    System.out.println("Need to track: " + m);
                                }
                            }
                            continue;
                        }
                        if (newCI.equals((Object)old)) continue;
                        newCI.hasStructuralProblems = true;
                    }
                    for (ClassInfo ci : ef.newClasses.values()) {
                        ret.put(ci.className.replace('.', '/'), ci);
                    }
                    continue;
                }
                ret.put(diff.getNewPath(), null);
                if (!LOG_VERBOSE_MYSQL) continue;
                try {
                    insertDiff.setInt(1, version_id);
                    insertDiff.setInt(2, PreciseLineAnalyzer.getCovNameId(diff.getNewPath()));
                    insertDiff.setInt(3, 0);
                    insertDiff.setInt(4, 0);
                    insertDiff.setInt(5, 1);
                    insertDiff.setInt(6, 0);
                    insertDiff.setInt(7, 0);
                    insertDiff.setInt(8, 0);
                    insertDiff.setInt(9, 0);
                    insertDiff.setInt(10, 0);
                    insertDiff.setInt(11, 0);
                    insertDiff.addBatch();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            f.close();
            for (String c : methodsToTrack.keySet()) {
                if (ret.containsKey(c)) {
                    ((ClassInfo)ret.get((Object)c)).newMethods.addAll((Collection)methodsToTrack.get(c));
                    continue;
                }
                ClassInfo cl = new ClassInfo();
                cl.className = c;
                cl.edits = new LinkedList();
                cl.newMethods = new ArrayList((Collection)methodsToTrack.get(c));
                ret.put(c, cl);
            }
            HashSet<String> toRemove = new HashSet<String>();
            for (String s : ret.keySet()) {
                ClassInfo ci = (ClassInfo)ret.get(s);
                if (ci != null && (ci.edits != null || ci.edits.size() != 0 || ci.hasEditedAnnotation || ci.hasStructuralProblems)) continue;
                toRemove.add(s);
            }
            for (String s : toRemove) {
                ret.remove(s);
            }
            HashMap<String, ClassInfo> hashMap = ret;
            return hashMap;
        }
        finally {
            if (revWalk != null) {
                revWalk.close();
            }
        }
    }

    private static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    static {
        cachedClasses = new HashMap();
        cachedMethods = new HashMap();
    }
}

