/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.deflaker.diff.ClassInfo;
import org.deflaker.diff.Edit;
import org.deflaker.diff.LineAnalyzer;
import org.deflaker.diff.PreciseLineAnalyzer;
import org.deflaker.maven.FirebaseLogger;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

@Mojo(name="diff", defaultPhase=LifecyclePhase.VERIFY)
public class DeflakerDiffingMojo
extends AbstractMojo {
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector artifactCollector;
    @Component
    private DependencyTreeBuilder treeBuilder;
    @Component
    private ArtifactResolver resolver;
    @Component
    private MavenProject project;
    @Parameter(readonly=true, required=true)
    private String diffFile;
    @Parameter(readonly=true, required=true)
    private String gitDir;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    public static final boolean NO_TYPE_RESOLUTION = System.getenv("diffcov.no_type_resolve") != null;
    HashSet<MavenProject> visited = new HashSet();
    HashSet<String> dependenciesWithSourceDirs = new HashSet();
    HashSet<String> dependenciesWithoutSourceDirs = new HashSet();
    public static FirebaseLogger firebase;
    Log consoleLogger;
    PreparedStatement getCoverageClass;
    PreparedStatement insertCoverageClass;
    PreparedStatement getCoverageMethod;
    PreparedStatement insertCoverageMethod;
    PreparedStatement insertDiff;
    private HashMap<String, Integer> cachedClasses = new HashMap();
    private HashMap<String, Integer> cachedMethods = new HashMap();
    public static final boolean ALL_COVERAGE;
    private Connection db;

    private static boolean equals(Artifact o1, Artifact o2) {
        return o1.getGroupId().equals(o2.getGroupId()) && o1.getArtifactId().equals(o2.getArtifactId()) && o1.getVersion().equals(o2.getVersion()) && o1.getType().equals(o2.getType());
    }

    private void collectDependencies(MavenProject project) throws DependencyTreeBuilderException {
        if (this.visited.contains(project)) {
            return;
        }
        this.visited.add(project);
        this.dependenciesWithSourceDirs.add(project.getBuild().getOutputDirectory());
        this.dependenciesWithSourceDirs.add(project.getBuild().getTestOutputDirectory());
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter(null);
        DependencyNode rootNode = this.treeBuilder.buildDependencyTree(project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.artifactCollector);
        CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
        rootNode.accept((DependencyNodeVisitor)visitor);
        List nodes = visitor.getNodes();
        for (DependencyNode dependencyNode : nodes) {
            int state = dependencyNode.getState();
            Artifact artifact = dependencyNode.getArtifact();
            boolean found = false;
            for (MavenProject p : this.reactorProjects) {
                if (!DeflakerDiffingMojo.equals(p.getArtifact(), artifact)) continue;
                this.collectDependencies(p);
                found = true;
            }
            if (found) continue;
            try {
                ArtifactResolutionResult res = this.resolver.resolveTransitively(Collections.singleton(artifact), project.getArtifact(), this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
                for (Object r : res.getArtifacts()) {
                    File f = ((Artifact)r).getFile();
                    this.dependenciesWithSourceDirs.add(f.getAbsolutePath());
                    this.dependenciesWithoutSourceDirs.add(f.getAbsolutePath());
                }
            }
            catch (ArtifactResolutionException e) {
                e.printStackTrace();
            }
            catch (ArtifactNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private int getCovClassId(String clazz) throws SQLException {
        if (!this.cachedClasses.containsKey(clazz = clazz.replace('/', '.'))) {
            this.getCoverageClass.setString(1, clazz);
            this.getCoverageClass.executeQuery();
            ResultSet rs = this.getCoverageClass.getResultSet();
            if (rs.next()) {
                int r = rs.getInt(1);
                this.cachedClasses.put(clazz, r);
                rs.close();
            } else {
                rs.close();
                this.insertCoverageClass.setString(1, clazz);
                this.insertCoverageClass.executeUpdate();
                rs = this.insertCoverageClass.getGeneratedKeys();
                rs.next();
                int r = rs.getInt(1);
                rs.close();
                this.cachedClasses.put(clazz, r);
            }
        }
        return this.cachedClasses.get(clazz);
    }

    private int getCovMethodId(String meth) throws SQLException {
        if (!this.cachedMethods.containsKey(meth = meth.replace('/', '.'))) {
            this.getCoverageMethod.setString(1, meth);
            this.getCoverageMethod.executeQuery();
            ResultSet rs = this.getCoverageMethod.getResultSet();
            if (rs.next()) {
                int r = rs.getInt(1);
                this.cachedMethods.put(meth, r);
                rs.close();
            } else {
                rs.close();
                this.insertCoverageMethod.setString(1, meth);
                this.insertCoverageMethod.executeUpdate();
                rs = this.insertCoverageMethod.getGeneratedKeys();
                rs.next();
                int r = rs.getInt(1);
                rs.close();
                this.cachedMethods.put(meth, r);
            }
        }
        return this.cachedMethods.get(meth);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.consoleLogger = this.getLog();
        File diffFileFile = new File(this.diffFile);
        if (!diffFileFile.exists()) {
            int testExecId = -1;
            boolean toMysql = false;
            if (System.getProperty("diffcov.mysql") != null) {
                testExecId = Integer.valueOf(System.getProperty("diffcov.studyid"));
                toMysql = true;
                String classname = "com.mysql.jdbc.Driver";
                try {
                    Driver d = (Driver)Class.forName(classname).newInstance();
                    DriverManager.registerDriver(d);
                    this.db = DriverManager.getConnection("jdbc:mysql://diffcov2017.c5smcgnslo73.us-east-1.rds.amazonaws.com/diffcov?user=diffcov&password=sqFycTgL35H5yegbe&useServerPrepStmts=false&rewriteBatchedStatements=true");
                    this.getCoverageClass = this.db.prepareStatement("SELECT id FROM java_class WHERE name=?");
                    this.insertCoverageClass = this.db.prepareStatement("INSERT INTO java_class (name) VALUES (?)", 1);
                    this.insertDiff = this.db.prepareStatement("INSERT INTO test_execution_diff (test_execution_id,java_class_id,statement,method,non_java) VALUES (?,?,?,?,?)");
                    this.getCoverageMethod = this.db.prepareStatement("SELECT id FROM java_method WHERE name=?");
                    this.insertCoverageMethod = this.db.prepareStatement("INSERT INTO java_method (name) VALUES (?)", 1);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException ex) {
                    ex.printStackTrace();
                    throw new MojoFailureException(ex.getMessage());
                }
            }
            if (ALL_COVERAGE) {
                try {
                    LinkedList<String> classes = new LinkedList<String>();
                    Scanner s = new Scanner(new File(diffFileFile.getAbsolutePath() + ".builddirs"));
                    while (s.hasNextLine()) {
                        classes.addAll(DeflakerDiffingMojo.collectJavaFiles(s.nextLine()));
                    }
                    s.close();
                    File javaFile = new File(this.diffFile + ".javafiles");
                    if (javaFile.exists()) {
                        javaFile.delete();
                    }
                    FileWriter fw = new FileWriter(javaFile);
                    for (String c : classes) {
                        fw.write(c + "\n");
                    }
                    fw.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                String commit = System.getProperty("commit");
                if (commit == null) {
                    commit = System.getenv("diffcommit");
                }
                if (commit == null) {
                    commit = "HEAD";
                }
                System.out.println(this.gitDir + " DIFF'ing to " + commit);
                if (System.getenv("TRAVIS") != null && firebase == null) {
                    firebase = new FirebaseLogger();
                }
                HashMap<String, ClassInfo> diffs = !NO_TYPE_RESOLUTION ? PreciseLineAnalyzer.getChanges(this.gitDir, commit, new String[0], new String[0]) : LineAnalyzer.getChanges(this.gitDir, commit);
                boolean doInsert = false;
                for (String k : diffs.keySet()) {
                    int id;
                    ClassInfo e = diffs.get(k);
                    if (e == null) {
                        if (!toMysql) continue;
                        id = this.getCovClassId(k);
                        doInsert = true;
                        this.insertDiff.setInt(1, testExecId);
                        this.insertDiff.setInt(2, id);
                        this.insertDiff.setNull(3, 4);
                        this.insertDiff.setNull(4, 4);
                        this.insertDiff.setInt(5, 1);
                        this.insertDiff.addBatch();
                        continue;
                    }
                    if (firebase != null) {
                        firebase.log(e.className, e.hasStructuralProblems, e.edits);
                    }
                    System.out.println(e.className + " " + (e.hasStructuralProblems ? "Structural diff" : "") + ": " + e.edits);
                    if (!NO_TYPE_RESOLUTION && e.newMethods != null) {
                        System.out.println("\t Methods to watch:" + e.newMethods);
                    }
                    if (!toMysql) continue;
                    id = this.getCovClassId(e.className);
                    doInsert = true;
                    if (e.hasStructuralProblems) {
                        this.insertDiff.setInt(1, testExecId);
                        this.insertDiff.setInt(2, id);
                        this.insertDiff.setNull(3, 4);
                        this.insertDiff.setNull(4, 4);
                        this.insertDiff.setNull(5, 4);
                        this.insertDiff.addBatch();
                    } else {
                        for (Edit ed : e.edits) {
                            for (int i = ed.getEditStart(); i <= ed.getEditEnd(); ++i) {
                                this.insertDiff.setInt(1, testExecId);
                                this.insertDiff.setInt(2, id);
                                this.insertDiff.setInt(3, i);
                                this.insertDiff.setNull(4, 4);
                                this.insertDiff.setNull(5, 4);
                                this.insertDiff.addBatch();
                            }
                        }
                    }
                    if (e.newMethods == null) continue;
                    for (ClassInfo.MethodInfo i : e.newMethods) {
                        this.insertDiff.setInt(1, testExecId);
                        this.insertDiff.setInt(2, id);
                        this.insertDiff.setNull(3, 4);
                        this.insertDiff.setInt(4, this.getCovMethodId(i.name + i.desc));
                        this.insertDiff.setNull(5, 4);
                        this.insertDiff.addBatch();
                    }
                }
                if (doInsert) {
                    this.insertDiff.executeBatch();
                }
                FileOutputStream fos = new FileOutputStream(diffFileFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(diffs);
                oos.close();
                if (firebase != null) {
                    firebase.awaitExit();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new MojoFailureException("Couldn't calculate diff");
            }
        }
    }

    private static LinkedList<String> collectJavaFiles(String rootDir) {
        final LinkedList<String> ret = new LinkedList<String>();
        try {
            Files.walkFileTree(Paths.get(rootDir, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.toString().endsWith(".java")) {
                        return FileVisitResult.CONTINUE;
                    }
                    ASTParser p = ASTParser.newParser((int)8);
                    p.setBindingsRecovery(false);
                    p.setResolveBindings(false);
                    p.setUnitName("App.java");
                    p.setEnvironment(new String[0], new String[0], new String[0], true);
                    Hashtable options = JavaCore.getOptions();
                    JavaCore.setComplianceOptions((String)"1.8", (Map)options);
                    p.setCompilerOptions((Map)options);
                    p.setKind(8);
                    Scanner sc = new Scanner(file);
                    String content = sc.useDelimiter("\\Z").next();
                    sc.close();
                    p.setSource(content.toCharArray());
                    CompilationUnit root = (CompilationUnit)p.createAST(null);
                    root.accept(new ASTVisitor(){
                        String packageName;
                        ClassInfo thisClass = null;

                        public void endVisit(TypeDeclaration node) {
                            this.thisClass = this.thisClass.parent;
                            super.endVisit(node);
                        }

                        public boolean visit(AnonymousClassDeclaration node) {
                            String name = this.thisClass.className + "$" + this.thisClass.anonCounter;
                            ++this.thisClass.anonCounter;
                            ClassInfo newThisClass = new ClassInfo();
                            newThisClass.className = name;
                            ret.add(name);
                            newThisClass.parent = this.thisClass;
                            this.thisClass = newThisClass;
                            return super.visit(node);
                        }

                        public void endVisit(AnonymousClassDeclaration node) {
                            this.thisClass = this.thisClass.parent;
                            super.endVisit(node);
                        }

                        public boolean visit(EnumDeclaration node) {
                            String name = (this.packageName == null ? "" : this.packageName + ".") + node.getName().toString();
                            if (this.thisClass == null) {
                                this.thisClass = new ClassInfo();
                                this.thisClass.edits = new LinkedList();
                                this.thisClass.className = name.replace('.', '/');
                            }
                            if (this.thisClass.className == null) {
                                this.thisClass.className = name.replace('.', '/');
                            }
                            ret.add(this.thisClass.className);
                            return super.visit(node);
                        }

                        public boolean visit(PackageDeclaration node) {
                            this.packageName = node.getName().getFullyQualifiedName();
                            return super.visit(node);
                        }

                        public boolean visit(TypeDeclaration node) {
                            String name = (this.packageName == null ? "" : this.packageName + ".") + node.getName().toString();
                            name = name.replace('.', '/');
                            if (this.thisClass == null) {
                                this.thisClass = new ClassInfo();
                                this.thisClass.className = name;
                            }
                            if (this.thisClass.className != null && !this.thisClass.className.equals(name)) {
                                ClassInfo newThisClass = new ClassInfo();
                                newThisClass.className = name = this.thisClass.className + "$" + node.getName().toString();
                                this.thisClass.innerClasses.add(newThisClass);
                                newThisClass.parent = this.thisClass;
                                this.thisClass = newThisClass;
                            }
                            if (node.getSuperclassType() != null) {
                                this.thisClass.superName = node.getSuperclassType().toString();
                            }
                            this.thisClass.className = name;
                            ret.add(this.thisClass.className);
                            return super.visit(node);
                        }
                    });
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println(DeflakerDiffingMojo.collectJavaFiles("/Users/jon/Documents/GMU/Projects/surefire-diff-coverage/experiments/hbc/hbc-core/src/main/java"));
    }

    static {
        ALL_COVERAGE = Boolean.valueOf(System.getProperty("diffcov.allCoverage", "false"));
    }

    class LazyDependencyResolver {
        String[] cpArray;

        LazyDependencyResolver() {
        }

        public String[] getCP() throws MojoExecutionException {
            if (this.cpArray == null) {
                try {
                    for (MavenProject p : DeflakerDiffingMojo.this.reactorProjects) {
                        DeflakerDiffingMojo.this.collectDependencies(p);
                    }
                }
                catch (DependencyTreeBuilderException e) {
                    e.printStackTrace();
                    throw new MojoExecutionException("", (Exception)((Object)e));
                }
                this.cpArray = new String[DeflakerDiffingMojo.this.dependenciesWithoutSourceDirs.size()];
                DeflakerDiffingMojo.this.dependenciesWithoutSourceDirs.toArray(this.cpArray);
            }
            return this.cpArray;
        }
    }
}

