/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.deflaker.diff.ClassInfo;
import org.deflaker.diff.Edit;
import org.deflaker.listener.TestLineHit;
import org.deflaker.maven.Base64;
import org.deflaker.maven.DeflakerDiffingMojo;
import org.deflaker.maven.FirebaseLogger;
import org.deflaker.maven.FlakySurefireReportParser;

@Mojo(name="report", defaultPhase=LifecyclePhase.VERIFY)
public class DeflakerReportingMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(readonly=true, required=true, property="debugCovFile")
    private String covFile;
    @Parameter(readonly=true, required=true)
    private String reportedTestsFile;
    @Parameter(readonly=true, required=true, property="maven.test.failure.ignore", defaultValue="true")
    private boolean testFailureIgnore;
    @Parameter(readonly=true, required=true, property="debugGitDir")
    private String gitDir;
    @Parameter(readonly=true, required=true, property="debugDiffFile")
    private String diffFile;
    @Parameter(readonly=true, required=false, defaultValue="false")
    private boolean isFailsafe;
    Log consoleLogger;
    HashSet<String> knownFlakes;
    PrintWriter fw;
    PreparedStatement insertCoverage;
    PreparedStatement getCoverageClass;
    PreparedStatement insertCoverageClass;
    PreparedStatement getCoverageMethod;
    PreparedStatement insertCoverageMethod;
    private HashMap<String, Integer> cachedClasses = new HashMap();
    private HashMap<String, Integer> cachedMethods = new HashMap();
    public static final boolean ALL_COVERAGE = Boolean.valueOf(System.getProperty("diffcov.allCoverage", "false"));
    public static final boolean LAZY_COV = System.getProperty("diffcov.lazycov") != null;
    private FlakySurefireReportParser parser;

    private void logInfo(String str) {
        this.consoleLogger.info((CharSequence)str);
        if (this.fw != null) {
            this.fw.println("[INFO] " + str);
        }
    }

    private void logWarn(String str) {
        this.consoleLogger.warn((CharSequence)str);
        if (this.fw != null) {
            this.fw.println("[WARN] " + str);
        }
    }

    private int getCovClassId(String clazz) throws SQLException {
        if (!this.cachedClasses.containsKey(clazz = clazz.replace('/', '.'))) {
            this.getCoverageClass.setString(1, clazz);
            this.getCoverageClass.executeQuery();
            ResultSet rs = this.getCoverageClass.getResultSet();
            if (rs.next()) {
                int r = rs.getInt(1);
                this.cachedClasses.put(clazz, r);
                rs.close();
            } else {
                rs.close();
                this.insertCoverageClass.setString(1, clazz);
                this.insertCoverageClass.executeUpdate();
                rs = this.insertCoverageClass.getGeneratedKeys();
                rs.next();
                int r = rs.getInt(1);
                rs.close();
                this.cachedClasses.put(clazz, r);
            }
        }
        return this.cachedClasses.get(clazz);
    }

    private int getCovMethodId(String meth) throws SQLException {
        int idx = meth.lastIndexOf(46);
        if (idx > 0) {
            meth = meth.substring(idx + 1);
        }
        if (!this.cachedMethods.containsKey(meth = meth.replace('/', '.'))) {
            this.getCoverageMethod.setString(1, meth);
            this.getCoverageMethod.executeQuery();
            ResultSet rs = this.getCoverageMethod.getResultSet();
            if (rs.next()) {
                int r = rs.getInt(1);
                this.cachedMethods.put(meth, r);
                rs.close();
            } else {
                rs.close();
                this.insertCoverageMethod.setString(1, meth);
                this.insertCoverageMethod.executeUpdate();
                rs = this.insertCoverageMethod.getGeneratedKeys();
                rs.next();
                int r = rs.getInt(1);
                rs.close();
                this.cachedMethods.put(meth, r);
            }
        }
        return this.cachedMethods.get(meth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        block106: {
            Connection db = null;
            FirebaseLogger firebase = null;
            if (System.getenv("TRAVIS") != null) {
                if (DeflakerDiffingMojo.firebase == null) {
                    DeflakerDiffingMojo.firebase = new FirebaseLogger();
                }
                firebase = DeflakerDiffingMojo.firebase;
                System.out.println("Reporter using firebase");
            }
            List<ReportTestSuite> tests = null;
            try {
                int testExecId;
                HashSet<String> poisonDiffs;
                HashMap backupCovByTestClass;
                HashMap covByTestClass;
                HashMap covByDiffedClass;
                int uncoveredMethods;
                int uncoveredLines;
                int uncoveredClasses;
                HashMap<String, Integer> testClassToId;
                PreparedStatement insertDiffData;
                boolean toMysql;
                block105: {
                    this.consoleLogger = this.getLog();
                    toMysql = false;
                    insertDiffData = null;
                    testClassToId = null;
                    uncoveredClasses = 0;
                    uncoveredLines = 0;
                    uncoveredMethods = 0;
                    if (System.getProperty("diffCov.report") != null) {
                        try {
                            this.fw = new PrintWriter(new FileWriter(System.getProperty("diffCov.report")));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.logInfo("------------------------------------------------------------------------");
                    this.logInfo("TEST DIFFCOV ANALYSIS");
                    this.logInfo(this.project.getName() + this.project.getArtifactId());
                    this.logInfo("------------------------------------------------------------------------");
                    if (System.getProperty("diffCov.knownFlakes") != null) {
                        this.knownFlakes = new HashSet();
                        for (String s : System.getProperty("diffCov.knownFlakes").split(",")) {
                            this.knownFlakes.add(s);
                        }
                        this.logInfo("Using list of known flakes: " + this.knownFlakes);
                    }
                    covByDiffedClass = new HashMap();
                    covByTestClass = new HashMap();
                    backupCovByTestClass = new HashMap();
                    poisonDiffs = new HashSet<String>();
                    this.consoleLogger.info((CharSequence)("Using covFile: " + this.covFile));
                    this.consoleLogger.info((CharSequence)("Using difFile: " + this.diffFile));
                    testExecId = -1;
                    if (new File(this.diffFile).exists() && new File(this.covFile).exists()) break block105;
                    this.logInfo("No test data found");
                    return;
                }
                if (System.getProperty("diffcov.mysql") != null) {
                    Object[] d;
                    testExecId = Integer.valueOf(System.getProperty("diffcov.studyid"));
                    toMysql = true;
                    testClassToId = new HashMap<String, Integer>();
                    if (new File(this.covFile + ".testToId").exists()) {
                        Scanner s = new Scanner(new File(this.covFile + ".testToId"));
                        while (s.hasNextLine()) {
                            d = s.nextLine().split("#");
                            try {
                                if (d.length == 2) {
                                    testClassToId.put(Base64.fromBase64(d[0]), Integer.valueOf((String)d[1]));
                                    continue;
                                }
                                testClassToId.put(Base64.fromBase64((String)d[0]) + "#" + Base64.fromBase64((String)d[1]), Integer.valueOf((String)d[2]));
                            }
                            catch (Throwable t) {
                                System.out.println("Bad line>>> " + Arrays.toString(d));
                                t.printStackTrace();
                            }
                        }
                        s.close();
                    }
                    String classname = "com.mysql.jdbc.Driver";
                    try {
                        d = (Object[])Class.forName(classname).newInstance();
                        DriverManager.registerDriver((Driver)d);
                        db = DriverManager.getConnection("jdbc:mysql://diffcov2017.c5smcgnslo73.us-east-1.rds.amazonaws.com/diffcov?user=diffcov&password=sqFycTgL35H5yegbe&useServerPrepStmts=false&rewriteBatchedStatements=true");
                        this.getCoverageClass = db.prepareStatement("SELECT id FROM java_class WHERE name=?");
                        this.insertCoverageClass = db.prepareStatement("INSERT INTO java_class (name) VALUES (?)", 1);
                        this.getCoverageMethod = db.prepareStatement("SELECT id FROM java_method WHERE name=?");
                        this.insertCoverageMethod = db.prepareStatement("INSERT INTO java_method (name) VALUES (?)", 1);
                        this.insertCoverage = db.prepareStatement("INSERT INTO test_result_coverage (test_method_id,java_class_id,statement, method, is_backup_coverage) VALUES (?,?,?,?,?)");
                        insertDiffData = db.prepareStatement("UPDATE test_result_test SET nFlaky=? WHERE id=?");
                    }
                    catch (IllegalAccessException | InstantiationException | SQLException ex) {
                        ex.printStackTrace();
                        throw new MojoFailureException(ex.getMessage());
                    }
                }
                FileInputStream fis = new FileInputStream(this.diffFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                HashMap diffs = (HashMap)ois.readObject();
                ois.close();
                for (String s : diffs.keySet()) {
                    if (diffs.get(s) != null) continue;
                    poisonDiffs.add(s);
                }
                Scanner covScanner = new Scanner(new File(this.covFile));
                while (covScanner.hasNextLine()) {
                    try {
                        TestLineHit h = TestLineHit.fromString((String)covScanner.nextLine());
                        if (!covByDiffedClass.containsKey(h.probeClass)) {
                            covByDiffedClass.put(h.probeClass, new LinkedList());
                        }
                        ((LinkedList)covByDiffedClass.get(h.probeClass)).add(h);
                        if (h.isBackupClassLevel) {
                            if (!backupCovByTestClass.containsKey(h.testClass + "." + h.testMethod)) {
                                backupCovByTestClass.put(h.testClass + "." + h.testMethod, new LinkedList());
                            }
                            ((LinkedList)backupCovByTestClass.get(h.testClass + "." + h.testMethod)).add(h);
                            continue;
                        }
                        if (!covByTestClass.containsKey(h.testClass + "." + h.testMethod)) {
                            covByTestClass.put(h.testClass + "." + h.testMethod, new LinkedList());
                        }
                        ((LinkedList)covByTestClass.get(h.testClass + "." + h.testMethod)).add(h);
                    }
                    catch (ArrayIndexOutOfBoundsException h) {}
                }
                covScanner.close();
                if (toMysql && testClassToId != null) {
                    try {
                        boolean doInsert = false;
                        this.insertCoverage.clearBatch();
                        for (String diffedClass : covByDiffedClass.keySet()) {
                            int probeId = this.getCovClassId(diffedClass);
                            for (TestLineHit t : (LinkedList)covByDiffedClass.get(diffedClass)) {
                                doInsert = true;
                                if (testClassToId.get(t.testClass + "#" + t.testMethod) == null) {
                                    System.err.println(">>> Could not find test method " + t.testClass + "#" + t.testMethod);
                                    continue;
                                }
                                int tId = (Integer)testClassToId.get(t.testClass + "#" + t.testMethod);
                                this.insertCoverage.setInt(1, tId);
                                this.insertCoverage.setInt(2, probeId);
                                this.insertCoverage.setInt(3, t.isClassLevel ? 0 : t.line);
                                this.insertCoverage.setInt(4, t.methName == null ? 0 : this.getCovMethodId(t.methName));
                                this.insertCoverage.setInt(5, t.isBackupClassLevel ? 1 : 0);
                                this.insertCoverage.addBatch();
                            }
                        }
                        if (doInsert) {
                            this.insertCoverage.executeBatch();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (!LAZY_COV) {
                    for (ClassInfo f : diffs.values()) {
                        if (f == null) continue;
                        if (f.hasStructuralProblems) {
                            if (covByDiffedClass.containsKey(f.className)) continue;
                            this.logUntested(f.className, true, null);
                            if (firebase != null) {
                                firebase.logUntestedStructural(f.className);
                            }
                            ++uncoveredClasses;
                            continue;
                        }
                        HashSet<Integer> linesDiffed = new HashSet<Integer>();
                        if (f.codeLinesEdited.isEmpty()) {
                            for (Edit e : f.edits) {
                                for (int i = e.getEditStart(); i <= e.getEditEnd(); ++i) {
                                    linesDiffed.add(i);
                                }
                            }
                        } else {
                            linesDiffed.addAll(f.codeLinesEdited);
                        }
                        if (covByDiffedClass.containsKey(f.className)) {
                            for (TestLineHit h : (LinkedList)covByDiffedClass.get(f.className)) {
                                linesDiffed.remove(h.line);
                            }
                        }
                        if (linesDiffed.isEmpty()) continue;
                        ArrayList<Integer> unCovered = new ArrayList<Integer>(linesDiffed);
                        Collections.sort(unCovered);
                        this.logUntested(f.className, false, unCovered.toString());
                        if (firebase != null) {
                            firebase.logUntestedLines(f.className, unCovered);
                        }
                        uncoveredLines += linesDiffed.size();
                    }
                }
                for (String s : poisonDiffs) {
                    this.logUntested(s, false, " (non-java files are not tracked; keep this in mind if any flaky tests are detected, they may have been impacted by this change!)");
                    if (firebase == null) continue;
                    firebase.logUntestedStructural(s);
                }
                tests = this.isFailsafe ? this.getParser("failsafe-reports").parseXMLReportFiles() : this.getParser("surefire-reports").parseXMLReportFiles();
                this.filterReportedTests(tests);
                HashMap<Object, TestResult> groupedTestCases = new HashMap<Object, TestResult>();
                if (tests.size() == 0) {
                    this.logWarn("No tests found!");
                    return;
                }
                if (toMysql && (testClassToId == null || testClassToId.size() == 0)) {
                    this.logWarn("Tests found, but cov data not!");
                    return;
                }
                try {
                    File forkResults = new File(this.project.getBasedir().getAbsolutePath() + "/target/" + (this.isFailsafe ? "failsafe" : "surefire") + "-reports-isolated-reruns/rerunResults");
                    if (forkResults.exists()) {
                        Scanner s = new Scanner(forkResults);
                        while (s.hasNextLine()) {
                            String[] d = s.nextLine().split("\t");
                            String n = d[0].replace('#', '.');
                            TestResult tr = (TestResult)groupedTestCases.get(n);
                            if (tr == null) {
                                tr = new TestResult();
                                groupedTestCases.put(n, tr);
                            }
                            if ("FAILED".equals(d[1])) {
                                ++tr.nFailedFreshJVM;
                                continue;
                            }
                            ++tr.nPassedFreshJVM;
                        }
                        s.close();
                    }
                    for (ReportTestSuite s : tests) {
                        for (ReportTestCase c : s.getTestCases()) {
                            TestResult tr = (TestResult)groupedTestCases.get(c.getFullName());
                            if (tr == null) {
                                tr = new TestResult();
                                groupedTestCases.put(c.getFullName(), tr);
                            }
                            if ("flaky".equals(c.getFailureType())) {
                                ++tr.nFailedOriginalJVM;
                                ++tr.nPassedOriginalJVM;
                                continue;
                            }
                            if (c.hasFailure()) {
                                ++tr.nFailedOriginalJVM;
                                continue;
                            }
                            ++tr.nPassedOriginalJVM;
                        }
                    }
                    boolean haveFailures = false;
                    HashSet reported = new HashSet();
                    HashSet<String> reportedFromCov = new HashSet<String>();
                    for (ReportTestSuite s : tests) {
                        int nFlakes = 0;
                        String testKey = s.getFullClassName();
                        for (ReportTestCase c : s.getTestCases()) {
                            testKey = c.getFullName();
                            TestResult tr = (TestResult)groupedTestCases.remove(c.getFullName());
                            if (tr == null || tr.nFailedOriginalJVM == 0) continue;
                            if (tr.nPassedFreshJVM > 0 && tr.nPassedOriginalJVM > 0) {
                                this.logWarn("FLAKY>> Test " + testKey + " was found to be flaky by rerunning it in both the same and also a fresh JVM! It failed the first time, then eventually passed (both in the same, and in the fresh JVM).");
                                if (firebase != null) {
                                    firebase.logFlaky(testKey);
                                }
                            } else if (tr.nPassedFreshJVM > 0) {
                                this.logWarn("FLAKY>> Test " + testKey + " was found to be flaky by rerunning it in a fresh JVM! It failed the first time, then eventually passed.");
                                if (firebase != null) {
                                    firebase.logFlaky(testKey);
                                }
                            } else if (tr.nPassedOriginalJVM > 0) {
                                this.logWarn("FLAKY>> Test " + testKey + " was found to be flaky by rerunning it in the same JVM! It failed the first time, then eventually passed.");
                                if (firebase != null) {
                                    firebase.logFlaky(testKey);
                                }
                            }
                            if (!this.isKnownFlaky(testKey) && (!c.hasFailure() || "skipped".equals(c.getFailureType()))) continue;
                            if (!covByTestClass.containsKey(testKey)) {
                                ++nFlakes;
                                if (backupCovByTestClass.containsKey(testKey)) {
                                    this.logFlaky(testKey, (LinkedList)backupCovByTestClass.get(testKey));
                                    if (firebase != null) {
                                        firebase.logFlaky(testKey, (LinkedList)backupCovByTestClass.get(testKey));
                                    }
                                } else {
                                    if (reportedFromCov.add(testKey)) {
                                        this.logFlaky(testKey);
                                    }
                                    if (firebase != null) {
                                        firebase.logFlaky(testKey);
                                    }
                                }
                            } else {
                                StringBuilder sb = new StringBuilder();
                                if (!ALL_COVERAGE) {
                                    for (TestLineHit h : (LinkedList)covByTestClass.get(testKey)) {
                                        sb.append('\t');
                                        sb.append(h.probeClass.replace('/', '.'));
                                        if (h.isClassLevel) {
                                            sb.append(" (structural changes)");
                                        } else {
                                            sb.append(':');
                                            sb.append(h.line);
                                        }
                                        sb.append('\n');
                                    }
                                }
                                if (firebase != null) {
                                    firebase.logNotFlakyFailure(testKey, (LinkedList)covByTestClass.get(testKey));
                                }
                                this.logFailed(testKey, sb.toString());
                            }
                            haveFailures = true;
                        }
                        if (!toMysql || nFlakes <= 0) continue;
                        try {
                            if (testClassToId.get(s.getFullClassName()) == null) {
                                System.err.println("Can't find test class ID>>>" + s.getFullClassName());
                                continue;
                            }
                            insertDiffData.setInt(1, nFlakes);
                            insertDiffData.setInt(2, (Integer)testClassToId.get(s.getFullClassName()));
                            insertDiffData.executeUpdate();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (toMysql) {
                        try {
                            PreparedStatement ps = db.prepareStatement("UPDATE test_execution set uncovered_lines=uncovered_lines+?, uncovered_classes=uncovered_classes+?, uncovered_methods=? WHERE id=?");
                            ps.setInt(1, uncoveredLines);
                            ps.setInt(2, uncoveredClasses);
                            ps.setInt(3, uncoveredMethods);
                            ps.setInt(4, Integer.valueOf(System.getProperty("diffcov.studyid")));
                            ps.executeUpdate();
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                            throw new MojoFailureException("mysql!");
                        }
                    }
                    if (!haveFailures) break block106;
                    if (this.testFailureIgnore) {
                        this.logWarn("\nThere are test failures!\n");
                        break block106;
                    }
                    throw new MojoFailureException("There were test failures!");
                }
                catch (IOException | ClassNotFoundException | MavenReportException e) {
                    e.printStackTrace();
                    throw new MojoFailureException(e.getMessage());
                }
            }
            finally {
                if (tests != null) {
                    this.logReportedTests(tests);
                }
                if (firebase != null) {
                    firebase.awaitExit();
                }
                if (this.fw != null) {
                    this.fw.close();
                }
                if (db != null) {
                    try {
                        db.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logReportedTests(List<ReportTestSuite> tests) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.reportedTestsFile, true);
            for (ReportTestSuite s : tests) {
                fw.write(s.getFullClassName());
                fw.write(10);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReportTestSuite> filterReportedTests(List<ReportTestSuite> tests) {
        try (Scanner s = null;){
            File f = new File(this.reportedTestsFile);
            if (f.exists()) {
                s = new Scanner(f);
                HashSet<String> testsToFilter = new HashSet<String>();
                LinkedList<ReportTestSuite> ret = new LinkedList<ReportTestSuite>();
                while (s.hasNextLine()) {
                    testsToFilter.add(s.nextLine());
                }
                for (ReportTestSuite t : tests) {
                    if (testsToFilter.contains(t.getFullClassName())) continue;
                    ret.add(t);
                }
                LinkedList<ReportTestSuite> linkedList = ret;
                return linkedList;
            }
        }
        return tests;
    }

    private void logFlaky(String fullClassName, LinkedList<TestLineHit> backupCov) {
        LinkedList<String> l = new LinkedList<String>();
        for (TestLineHit h : backupCov) {
            l.add(h.probeClass);
        }
        this.logWarn("FLAKY>> Test " + fullClassName + " failed, but did not appear to run any changed code. It did touch some changed files though: " + l);
    }

    private void logFailed(String fullClassName, String debug) {
        this.logWarn("Test " + fullClassName + " failed, perhaps due to relevant changed code:\n" + debug);
    }

    private void logFlaky(String fullClassName) {
        this.logWarn("FLAKY>> Test " + fullClassName + " failed, but did not appear to run any changed code");
    }

    private void logUntested(String className, boolean isStructural, String extra) {
        if (isStructural) {
            this.logWarn("Diff has gone untested: " + className + " has structural changes!");
        } else {
            this.logWarn("Diff has gone untested: " + className + " has uncovered changes " + extra);
        }
    }

    private boolean isKnownFlaky(String s) {
        if (this.knownFlakes == null) {
            return false;
        }
        return this.knownFlakes.contains(s);
    }

    public FlakySurefireReportParser getParser(String dir) {
        if (this.parser == null) {
            this.parser = new FlakySurefireReportParser(Collections.singletonList(new File(this.project.getBasedir().getAbsolutePath() + "/target/" + dir)), Locale.US);
        }
        return this.parser;
    }

    private static class TestResult {
        int nPassedOriginalJVM;
        int nFailedOriginalJVM;
        int nFailedFreshJVM;
        int nPassedFreshJVM;

        private TestResult() {
        }
    }
}

