/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.maven;

import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.deflaker.diff.Edit;
import org.deflaker.listener.TestLineHit;

public class FirebaseLogger {
    FirebaseDatabase database;
    DatabaseReference buildRef;
    Object initLatch = new Object();
    static AtomicInteger pendingFirebaseRequests = new AtomicInteger();

    public FirebaseLogger() {
        ByteArrayInputStream serviceAccount = new ByteArrayInputStream(System.getenv("FIREBASE_KEY").getBytes());
        FirebaseOptions options = new FirebaseOptions.Builder().setDatabaseUrl("https://flakytests.firebaseio.com").setServiceAccount((InputStream)serviceAccount).build();
        FirebaseApp.initializeApp((FirebaseOptions)options);
        this.database = FirebaseDatabase.getInstance();
        String repo_name = System.getenv("TRAVIS_REPO_SLUG");
        String build_number = System.getenv("TRAVIS_BUILD_ID");
        String commit = System.getenv("TRAVIS_COMMIT");
        String commit_range = System.getenv("TRAVIS_COMMIT_RANGE");
        String job_id = System.getenv("TRAVIS_JOB_ID");
        this.buildRef = this.database.getReference("builds/" + repo_name + "/" + build_number + "/" + job_id);
        pendingFirebaseRequests.incrementAndGet();
        pendingFirebaseRequests.incrementAndGet();
        this.buildRef.child("commit").setValue((Object)commit, new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
            }
        });
        this.buildRef.child("commit_range").setValue((Object)commit_range, new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitExit() {
        while (pendingFirebaseRequests.get() > 0) {
            Object object = this.initLatch;
            synchronized (object) {
                try {
                    this.initLatch.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void log(String className, boolean hasStructuralProblems, LinkedList<Edit> edits) {
        pendingFirebaseRequests.incrementAndGet();
        className = className.replace('.', '-');
        className = className.replace('/', '-');
        className = className.replace("$", "-INNER-");
        this.buildRef.child("diff/" + className + "/structural").setValue((Object)(hasStructuralProblems ? "true" : "false"), new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
                if (arg0 != null) {
                    throw arg0.toException();
                }
            }
        });
        if (!edits.isEmpty()) {
            pendingFirebaseRequests.incrementAndGet();
            this.buildRef.child("diff/" + className + "/edits").setValue(edits, new DatabaseReference.CompletionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                    pendingFirebaseRequests.decrementAndGet();
                    Object object = FirebaseLogger.this.initLatch;
                    synchronized (object) {
                        FirebaseLogger.this.initLatch.notify();
                    }
                    if (arg0 != null) {
                        throw arg0.toException();
                    }
                }
            });
        }
    }

    public void logUntestedStructural(String className) {
        pendingFirebaseRequests.incrementAndGet();
        this.buildRef.child("untestedClass/").push().setValue((Object)className, new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
                if (arg0 != null) {
                    throw arg0.toException();
                }
            }
        });
    }

    public void logUntestedLines(String className, ArrayList<Integer> unCovered) {
        pendingFirebaseRequests.incrementAndGet();
        className = className.replace('.', '-');
        className = className.replace('/', '-');
        className = className.replace("$", "-INNER-");
        this.buildRef.child("untestedLines/" + className).setValue(unCovered, new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
                if (arg0 != null) {
                    throw arg0.toException();
                }
            }
        });
    }

    public void logUntestedMethods(String className, ArrayList<String> unCovered) {
        pendingFirebaseRequests.incrementAndGet();
        className = className.replace('.', '-');
        className = className.replace('/', '-');
        className = className.replace("$", "-INNER-");
        this.buildRef.child("untestedMethods/" + className).setValue(unCovered, new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
                if (arg0 != null) {
                    throw arg0.toException();
                }
            }
        });
    }

    public void logFlaky(String className) {
        this.logFlaky(className, null);
    }

    public void logNotFlakyFailure(String fullClassName, LinkedList<TestLineHit> linkedList) {
        pendingFirebaseRequests.incrementAndGet();
        this.buildRef.child("failures/notflaky").push().setValue((Object)fullClassName, new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
                if (arg0 != null) {
                    throw arg0.toException();
                }
            }
        });
    }

    public void logFlaky(String className, LinkedList<TestLineHit> linkedList) {
        pendingFirebaseRequests.incrementAndGet();
        this.buildRef.child("failures/flaky").push().setValue((Object)className, new DatabaseReference.CompletionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                pendingFirebaseRequests.decrementAndGet();
                Object object = FirebaseLogger.this.initLatch;
                synchronized (object) {
                    FirebaseLogger.this.initLatch.notify();
                }
                if (arg0 != null) {
                    throw arg0.toException();
                }
            }
        });
        if (linkedList != null && linkedList.size() > 0) {
            pendingFirebaseRequests.incrementAndGet();
            this.buildRef.child("failures/maybeflaky").push().setValue((Object)className, new DatabaseReference.CompletionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete(DatabaseError arg0, DatabaseReference arg1) {
                    pendingFirebaseRequests.decrementAndGet();
                    Object object = FirebaseLogger.this.initLatch;
                    synchronized (object) {
                        FirebaseLogger.this.initLatch.notify();
                    }
                    if (arg0 != null) {
                        throw arg0.toException();
                    }
                }
            });
        }
    }
}

