/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.maven;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.DirectoryScanner;
import org.deflaker.maven.TestSuiteXmlParser;
import org.xml.sax.SAXException;

public final class FlakySurefireReportParser {
    private static final String INCLUDES = "*.xml";
    private static final String EXCLUDES = "*.txt, testng-failed.xml, testng-failures.xml, testng-results.xml, failsafe-summary*.xml";
    private static final int PCENT = 100;
    private final List<ReportTestSuite> testSuites = new ArrayList<ReportTestSuite>();
    private final NumberFormat numberFormat;
    private List<File> reportsDirectories;

    public FlakySurefireReportParser(List<File> reportsDirectoriesFiles, Locale locale) {
        this.reportsDirectories = reportsDirectoriesFiles;
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public List<ReportTestSuite> parseXMLReportFiles() throws MavenReportException {
        ArrayList<File> xmlReportFiles = new ArrayList<File>();
        for (File reportsDirectory : this.reportsDirectories) {
            if (!reportsDirectory.exists()) continue;
            for (String xmlReportFile : FlakySurefireReportParser.getIncludedFiles(reportsDirectory, INCLUDES, EXCLUDES)) {
                xmlReportFiles.add(new File(reportsDirectory, xmlReportFile));
            }
        }
        TestSuiteXmlParser parser = new TestSuiteXmlParser();
        for (File aXmlReportFileList : xmlReportFiles) {
            try {
                this.testSuites.addAll(parser.parse(aXmlReportFileList.getAbsolutePath()));
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.testSuites;
    }

    protected String parseTestSuiteName(String lineString) {
        return lineString.substring(lineString.lastIndexOf(".") + 1, lineString.length());
    }

    protected String parseTestSuitePackageName(String lineString) {
        return lineString.substring(lineString.indexOf(":") + 2, lineString.lastIndexOf("."));
    }

    protected String parseTestCaseName(String lineString) {
        return lineString.substring(0, lineString.indexOf("("));
    }

    public Map<String, String> getSummary(List<ReportTestSuite> suites) {
        HashMap<String, String> totalSummary = new HashMap<String, String>();
        int totalNumberOfTests = 0;
        int totalNumberOfErrors = 0;
        int totalNumberOfFailures = 0;
        int totalNumberOfSkipped = 0;
        float totalElapsedTime = 0.0f;
        for (ReportTestSuite suite : suites) {
            totalNumberOfTests += suite.getNumberOfTests();
            totalNumberOfErrors += suite.getNumberOfErrors();
            totalNumberOfFailures += suite.getNumberOfFailures();
            totalNumberOfSkipped += suite.getNumberOfSkipped();
            totalElapsedTime += suite.getTimeElapsed();
        }
        String totalPercentage = this.computePercentage(totalNumberOfTests, totalNumberOfErrors, totalNumberOfFailures, totalNumberOfSkipped);
        totalSummary.put("totalTests", Integer.toString(totalNumberOfTests));
        totalSummary.put("totalErrors", Integer.toString(totalNumberOfErrors));
        totalSummary.put("totalFailures", Integer.toString(totalNumberOfFailures));
        totalSummary.put("totalSkipped", Integer.toString(totalNumberOfSkipped));
        totalSummary.put("totalElapsedTime", this.numberFormat.format(totalElapsedTime));
        totalSummary.put("totalPercentage", totalPercentage);
        return totalSummary;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectories = Collections.singletonList(reportsDirectory);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public Map<String, List<ReportTestSuite>> getSuitesGroupByPackage(List<ReportTestSuite> testSuitesList) {
        HashMap<String, List<ReportTestSuite>> suitePackage = new HashMap<String, List<ReportTestSuite>>();
        for (ReportTestSuite suite : testSuitesList) {
            List<Object> suiteList = new ArrayList<ReportTestSuite>();
            if (suitePackage.get(suite.getPackageName()) != null) {
                suiteList = (List)suitePackage.get(suite.getPackageName());
            }
            suiteList.add(suite);
            suitePackage.put(suite.getPackageName(), suiteList);
        }
        return suitePackage;
    }

    public String computePercentage(int tests, int errors, int failures, int skipped) {
        float percentage = tests == 0 ? 0.0f : (float)(tests - errors - failures - skipped) / (float)tests * 100.0f;
        return this.numberFormat.format(percentage);
    }

    public List<ReportTestCase> getFailureDetails(List<ReportTestSuite> testSuites) {
        ArrayList<ReportTestCase> failureDetailList = new ArrayList<ReportTestCase>();
        for (ReportTestSuite suite : testSuites) {
            List testCases = suite.getTestCases();
            if (testCases == null) continue;
            for (ReportTestCase tCase : testCases) {
                if (!tCase.hasFailure()) continue;
                failureDetailList.add(tCase);
            }
        }
        return failureDetailList;
    }

    public static boolean hasReportFiles(File directory) {
        return directory != null && directory.isDirectory() && FlakySurefireReportParser.getIncludedFiles(directory, INCLUDES, EXCLUDES).length != 0;
    }

    private static String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

