/*
 * Decompiled with CFR 0.152.
 */
package org.deflaker.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.shared.utils.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TestSuiteXmlParser
extends DefaultHandler {
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    private ReportTestSuite defaultSuite;
    private ReportTestSuite currentSuite;
    private Map<String, Integer> classesToSuitesIndex;
    private List<ReportTestSuite> suites;
    private StringBuilder currentElement;
    private ReportTestCase testCase;
    private boolean valid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportTestSuite> parse(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream fileInputStream = new FileInputStream(new File(xmlPath));
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        try {
            List<ReportTestSuite> list = this.parse(inputStreamReader);
            return list;
        }
        finally {
            inputStreamReader.close();
            fileInputStream.close();
        }
    }

    public List<ReportTestSuite> parse(InputStreamReader stream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        this.valid = true;
        this.classesToSuitesIndex = new HashMap<String, Integer>();
        this.suites = new ArrayList<ReportTestSuite>();
        saxParser.parse(new InputSource(stream), (DefaultHandler)this);
        if (this.currentSuite != this.defaultSuite && this.defaultSuite.getNumberOfTests() == 0) {
            this.suites.remove(this.classesToSuitesIndex.get(this.defaultSuite.getFullClassName()));
        }
        return this.suites;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block21: {
            if (this.valid) {
                try {
                    if ("testsuite".equals(qName)) {
                        this.currentSuite = this.defaultSuite = new ReportTestSuite();
                        try {
                            Number time = this.numberFormat.parse(attributes.getValue("time"));
                            this.defaultSuite.setTimeElapsed(time.floatValue());
                        }
                        catch (NullPointerException e) {
                            System.err.println("WARNING: no time attribute found on testsuite element");
                        }
                        String name = attributes.getValue("name");
                        String group = attributes.getValue("group");
                        this.defaultSuite.setFullClassName(StringUtils.isBlank((String)group) ? name : group + "." + name);
                        this.suites.add(this.defaultSuite);
                        this.classesToSuitesIndex.put(this.defaultSuite.getFullClassName(), this.suites.size() - 1);
                        break block21;
                    }
                    if ("testcase".equals(qName)) {
                        String timeAsString;
                        this.currentElement = new StringBuilder();
                        this.testCase = new ReportTestCase().setName(attributes.getValue("name"));
                        String fullClassName = attributes.getValue("classname");
                        if (fullClassName != null) {
                            Integer currentSuiteIndex = this.classesToSuitesIndex.get(fullClassName);
                            if (currentSuiteIndex == null) {
                                this.currentSuite = new ReportTestSuite().setFullClassName(fullClassName);
                                this.suites.add(this.currentSuite);
                                this.classesToSuitesIndex.put(fullClassName, this.suites.size() - 1);
                            } else {
                                this.currentSuite = this.suites.get(currentSuiteIndex);
                            }
                        }
                        Integer time = StringUtils.isBlank((String)(timeAsString = attributes.getValue("time"))) ? (Number)0 : (Number)this.numberFormat.parse(timeAsString);
                        this.testCase.setFullClassName(this.currentSuite.getFullClassName()).setClassName(this.currentSuite.getName()).setFullName(this.currentSuite.getFullClassName() + "." + this.testCase.getName()).setTime(((Number)time).floatValue());
                        if (this.currentSuite != this.defaultSuite) {
                            this.currentSuite.setTimeElapsed(this.testCase.getTime() + this.currentSuite.getTimeElapsed());
                        }
                    } else if ("failure".equals(qName)) {
                        this.testCase.setFailure(attributes.getValue("message"), attributes.getValue("type"));
                        this.currentSuite.incrementNumberOfFailures();
                    } else if ("error".equals(qName)) {
                        this.testCase.setFailure(attributes.getValue("message"), attributes.getValue("type"));
                        this.currentSuite.incrementNumberOfErrors();
                    } else if ("skipped".equals(qName)) {
                        String message = attributes.getValue("message");
                        this.testCase.setFailure(message != null ? message : "skipped", "skipped");
                        this.currentSuite.incrementNumberOfSkipped();
                    } else if ("flakyFailure".equals(qName) || "flakyError".equals(qName)) {
                        this.testCase.setFailure(null, "flaky");
                        this.currentSuite.incrementNumberOfFlakes();
                    } else if ("failsafe-summary".equals(qName)) {
                        this.valid = false;
                    }
                }
                catch (ParseException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("testcase".equals(qName)) {
            this.currentSuite.getTestCases().add(this.testCase);
        } else if ("failure".equals(qName) || "error".equals(qName)) {
            this.testCase.setFailureDetail(this.currentElement.toString()).setFailureErrorLine(TestSuiteXmlParser.parseErrorLine(this.currentElement, this.testCase.getFullClassName()));
        } else if ("time".equals(qName)) {
            try {
                this.defaultSuite.setTimeElapsed(this.numberFormat.parse(this.currentElement.toString()).floatValue());
            }
            catch (ParseException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        assert (start >= 0);
        assert (length >= 0);
        if (this.valid && TestSuiteXmlParser.isNotBlank(start, length, ch)) {
            this.currentElement.append(ch, start, length);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    static boolean isNotBlank(int from, int len, char ... s) {
        assert (from >= 0);
        assert (len >= 0);
        if (s != null) {
            for (int i = 0; i < len; ++i) {
                char c;
                if ((c = s[from++]) == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') continue;
                return true;
            }
        }
        return false;
    }

    static boolean isNumeric(StringBuilder s, int from, int to) {
        assert (from >= 0);
        assert (from <= to);
        int i = from;
        while (i != to) {
            if (Character.isDigit(s.charAt(i++))) continue;
            return false;
        }
        return from != to;
    }

    static String parseErrorLine(StringBuilder currentElement, String fullClassName) {
        String[] linePatterns = new String[]{"at " + fullClassName + '.', "at " + fullClassName + '$'};
        int[] indexes = TestSuiteXmlParser.lastIndexOf(currentElement, linePatterns);
        int patternStartsAt = indexes[0];
        if (patternStartsAt != -1) {
            int searchTo;
            int searchFrom = patternStartsAt + linePatterns[indexes[1]].length();
            return TestSuiteXmlParser.isNumeric(currentElement, searchFrom = 1 + currentElement.indexOf(":", searchFrom), searchTo = currentElement.indexOf(")", searchFrom)) ? currentElement.substring(searchFrom, searchTo) : "";
        }
        return "";
    }

    static int[] lastIndexOf(StringBuilder source, String ... linePatterns) {
        int end = source.indexOf("Caused by:");
        if (end == -1) {
            end = source.length();
        }
        int startsAt = -1;
        int pattern = -1;
        for (int i = 0; i < linePatterns.length; ++i) {
            String linePattern = linePatterns[i];
            int currentStartsAt = source.lastIndexOf(linePattern, end);
            if (currentStartsAt <= startsAt) continue;
            startsAt = currentStartsAt;
            pattern = i;
        }
        return new int[]{startsAt, pattern};
    }
}

