/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.client.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.defne.service.Message;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;

public class DefneServletClient
{
    private static final ILogger logger = LoggerProvider.getLogProvider(DefneServletClient.class);
    
    private static final HttpClient client = new HttpClient(new MultiThreadedHttpConnectionManager());
    private static ResourceBundle rb;
    
    private static final String HOST = "server_host";
    private static final String PORT = "server_port";
    private static final String PROTOCOL = "server_protocol";
    private static final String CONTEXT_PATH = "context_path";
    private static final String SERVER_TIMEOUT = "server_timeout";

    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_PROTOCOL = "http";
    private static String DEFAULT_CONTEXT = "/Defne/DefneSerializeServlet";
    private static final int DEFAULT_TIMEOUT = 5000;
    
    static 
    {
        try
        {
            rb = ResourceBundle.getBundle("defne-client");
            if(rb == null)
            {
                rb = ResourceBundle.getBundle("defne-client-default");
            }
            
            if(rb != null)
            {
                String temp = rb.getString(CONTEXT_PATH);
                if(temp != null && !temp.equals("") )
                {
                    DEFAULT_CONTEXT = temp;
                }
                
                temp = rb.getString(SERVER_TIMEOUT);
                if(temp != null && !temp.equals("") )
                {
                    client.getHttpConnectionManager().getParams().setConnectionTimeout(Integer.parseInt(temp));
                }
                
                client.getHostConfiguration().setHost(rb.getString(HOST), Integer.parseInt(rb.getString(PORT)), rb.getString(PROTOCOL));                
            }
                
                        
        }
        catch(Exception e)
        {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(DEFAULT_TIMEOUT);
            client.getHostConfiguration().setHost(DEFAULT_HOST, DEFAULT_PORT, DEFAULT_PROTOCOL); 
        }
    }

    public static Message execute(Message message) throws Exception
    {
        PostMethod post = null;
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try
        {
            oos.writeObject(message);
            oos.flush();
            byte[] buffer = bos.toByteArray();
            bis = new ByteArrayInputStream(buffer, 0, buffer.length);
            
            post = new PostMethod(DEFAULT_CONTEXT);
            RequestEntity entity = new InputStreamRequestEntity(bis);
            
            //Set body
            post.setRequestEntity(entity);
            
            //Execute
            int status = client.executeMethod(post);
            if(status == 200)
            {
                InputStream is = post.getResponseBodyAsStream();
                ObjectInputStream ois = new ObjectInputStream(is);
                Object output = ois.readObject();
                if(output instanceof Exception)
                {
                    throw (Exception)output;
                }
                
                return (Message)output;
            }
            else
            {
                throw new Exception("Status code is : " + status + ". Error is occured, please see log files on server side");
            }
            
            
        }catch(Exception e)
        {
            String error = "Error is occured while calling server side";
            logger.error(error,e);
            throw e;
        }
        finally
        {
            if(oos != null)
            {
                oos.close();
            }
            
            post.releaseConnection();
        }        
    }
}
