/*
 * Decompiled with CFR 0.152.
 */
package org.defne.client.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.defne.service.Message;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;

public class DefneServletClient {
    private static final ILogger logger = LoggerProvider.getLogProvider(DefneServletClient.class);
    private static final HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    private static ResourceBundle rb;
    private static final String HOST = "server_host";
    private static final String PORT = "server_port";
    private static final String PROTOCOL = "server_protocol";
    private static final String CONTEXT_PATH = "context_path";
    private static final String SERVER_TIMEOUT = "server_timeout";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_PROTOCOL = "http";
    private static String DEFAULT_CONTEXT;
    private static final int DEFAULT_TIMEOUT = 5000;

    public static Message execute(Message message) throws Exception {
        PostMethod post = null;
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject(message);
            oos.flush();
            byte[] buffer = bos.toByteArray();
            bis = new ByteArrayInputStream(buffer, 0, buffer.length);
            post = new PostMethod(DEFAULT_CONTEXT);
            InputStreamRequestEntity entity = new InputStreamRequestEntity((InputStream)bis);
            post.setRequestEntity((RequestEntity)entity);
            int status = client.executeMethod((HttpMethod)post);
            if (status == 200) {
                InputStream is = post.getResponseBodyAsStream();
                ObjectInputStream ois = new ObjectInputStream(is);
                Object output = ois.readObject();
                if (output instanceof Exception) {
                    throw (Exception)output;
                }
                Message message2 = (Message)output;
                return message2;
            }
            try {
                throw new Exception("Status code is : " + status + ". Error is occured, please see log files on server side");
            }
            catch (Exception e) {
                String error = "Error is occured while calling server side";
                logger.error(error, (Throwable)e);
                throw e;
            }
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            post.releaseConnection();
        }
    }

    static {
        DEFAULT_CONTEXT = "/Defne/DefneSerializeServlet";
        try {
            rb = ResourceBundle.getBundle("defne-client");
            if (rb == null) {
                rb = ResourceBundle.getBundle("defne-client-default");
            }
            if (rb != null) {
                String temp = rb.getString(CONTEXT_PATH);
                if (temp != null && !temp.equals("")) {
                    DEFAULT_CONTEXT = temp;
                }
                if ((temp = rb.getString(SERVER_TIMEOUT)) != null && !temp.equals("")) {
                    client.getHttpConnectionManager().getParams().setConnectionTimeout(Integer.parseInt(temp));
                }
                client.getHostConfiguration().setHost(rb.getString(HOST), Integer.parseInt(rb.getString(PORT)), rb.getString(PROTOCOL));
            }
        }
        catch (Exception e) {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            client.getHostConfiguration().setHost(DEFAULT_HOST, 8080, DEFAULT_PROTOCOL);
        }
    }
}

