/*
 * @Copyright 2010, MechSoft 
 * MechSoft, Mechanical and Software Solutions 
 * 
 * Licensed under the Apache License, Version 2.0 (the 
 * "License"); you may not use this file except in compliance 
 * with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.defne.server.json;

import java.io.Serializable;

import org.defne.service.Message;

/**
 * Service definition for JSON.
 * @author gurkanerdogdu
 * @version $Rev$ $Date$
 */
public class JsonServiceMessage implements IJsonAdaptor,Serializable
{
    private static final long serialVersionUID = 1L;
    
    protected String service;
    protected String method;
    protected String adaptorClass;
    
    public JsonServiceMessage()
    {
        
    }

    public String getAdaptorClass()
    {
        return adaptorClass;
    }



    public void setAdaptorClass(String adaptorClass)
    {
        this.adaptorClass = adaptorClass;
    }

    public String getService()
    {
        return service;
    }

    public void setService(String service)
    {
        this.service = service;
    }

    public String getMethod()
    {
        return method;
    }

    public void setMethod(String method)
    {
        this.method = method;
    }
    
    @Override
    public Object fromOutputMessage(Message message)
    {
        return null;
    }

    @Override
    public Message toInputMessage()
    {
        return null;
    }

}
