/*
 * Decompiled with CFR 0.152.
 */
package org.defne.server.json;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.defne.server.json.JsonServiceAdaptor;
import org.defne.server.json.JsonServiceMessage;
import org.defne.utility.log.ILogger;
import org.defne.utility.log.LoggerProvider;
import org.defne.utility.reflection.ReflectionUtils;

public class DefneJsonServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final ILogger logger = LoggerProvider.getLogProvider(DefneJsonServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405, "Get is not supported");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BufferedReader reader = req.getReader();
        StringBuffer buf = new StringBuffer();
        String s = null;
        while ((s = reader.readLine()) != null) {
            buf.append(s);
        }
        String jsonString = buf.toString();
        if (jsonString.equals("")) {
            resp.sendError(400, "JSON payload is not found in the request");
            return;
        }
        Gson gson = new Gson();
        try {
            String adaptorClass;
            String methodNameName;
            Object result = null;
            HashMap<String, String> arguments = new HashMap<String, String>();
            JsonServiceMessage jsonObj = (JsonServiceMessage)gson.fromJson(jsonString, JsonServiceMessage.class);
            String serviceName = jsonObj.getService();
            StringBuffer error = new StringBuffer();
            if (serviceName == null || serviceName.equals("")) {
                error.append("No service name");
            }
            if ((methodNameName = jsonObj.getMethod()) == null || methodNameName.equals("")) {
                error.append("No method name");
            }
            if ((adaptorClass = jsonObj.getAdaptorClass()) == null || adaptorClass.equals("")) {
                error.append("No adaptror class name");
            }
            if (error.length() > 0) {
                arguments.put("ERROR", error.toString());
            } else {
                Class clazz = ReflectionUtils.getClassFromName((String)adaptorClass);
                jsonObj = (JsonServiceMessage)gson.fromJson(jsonString, clazz);
                result = JsonServiceAdaptor.execute(jsonObj);
            }
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("max-age", "0");
            resp.setHeader("must-revalidate", "true");
            resp.setHeader("Content-Type", "application/json;charset=utf-8");
            if (error.length() > 0) {
                resp.getWriter().write(gson.toJson(arguments));
            } else {
                resp.getWriter().write(gson.toJson(result));
            }
        }
        catch (Exception e) {
            String error = "Error is occured while parsing JSON";
            logger.error(error, (Throwable)e);
            resp.sendError(500, error + ". See log for the details");
        }
    }
}

