/*
 * Decompiled with CFR 0.152.
 */
package org.delia.api;

import java.util.ArrayList;
import java.util.List;
import org.delia.api.Delia;
import org.delia.api.DeliaOptions;
import org.delia.api.DeliaSession;
import org.delia.api.DeliaSessionImpl;
import org.delia.compiler.DeliaCompiler;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.core.FactoryService;
import org.delia.db.DBInterface;
import org.delia.db.schema.MigrationPlan;
import org.delia.db.schema.MigrationService;
import org.delia.error.DeliaError;
import org.delia.error.SimpleErrorTracker;
import org.delia.log.Log;
import org.delia.runner.DeliaException;
import org.delia.runner.InternalCompileState;
import org.delia.runner.ResultValue;
import org.delia.runner.Runner;
import org.delia.runner.RunnerImpl;
import org.delia.runner.TypeRunner;
import org.delia.runner.TypeSpec;
import org.delia.typebuilder.FutureDeclError;
import org.delia.util.DeliaExceptionHelper;

public class DeliaImpl
implements Delia {
    private Log log;
    private DBInterface dbInterface;
    private FactoryService factorySvc;
    private DeliaOptions deliaOptions = new DeliaOptions();
    private MigrationService migrationSvc;

    public DeliaImpl(DBInterface dbInterface, Log log, FactoryService factorySvc) {
        this.log = log;
        this.dbInterface = dbInterface;
        this.factorySvc = factorySvc;
        this.migrationSvc = new MigrationService(dbInterface, factorySvc);
    }

    @Override
    public ResultValue execute(String src) {
        DeliaCompiler compiler = this.createCompiler();
        List<Exp> expL = compiler.parse(src);
        Runner runner = this.createRunner(null);
        this.execTypes(runner, expL);
        ResultValue migrationPlanRes = this.doPass3AndDBMigration(src, expL, runner, null);
        if (migrationPlanRes != null) {
            return migrationPlanRes;
        }
        return this.doExecute(runner, expL);
    }

    private ResultValue doExecute(Runner runner, List<Exp> expL) {
        ResultValue res = null;
        if (!this.deliaOptions.enableExecution) {
            res = new ResultValue();
            res.ok = true;
            return res;
        }
        res = runner.executeProgram(expL);
        if (res != null && !res.ok) {
            throw new DeliaException(res.errors);
        }
        return res;
    }

    @Override
    public DeliaCompiler createCompiler() {
        return this.doCreateCompiler(null);
    }

    private DeliaCompiler doCreateCompiler(InternalCompileState execCtx) {
        DeliaCompiler compiler = new DeliaCompiler(this.factorySvc, execCtx);
        return compiler;
    }

    protected Runner createRunner(DeliaSession dbsess) {
        SimpleErrorTracker et = new SimpleErrorTracker(this.log);
        RunnerImpl runner = new RunnerImpl(this.factorySvc, this.dbInterface);
        boolean b = dbsess == null ? runner.init(null) : runner.init(dbsess.getExecutionContext());
        if (!b) {
            DeliaError err = et.add("runner-init-failed", "runner init failed");
            throw new DeliaException(err);
        }
        this.dbInterface.init(this.factorySvc);
        return runner;
    }

    @Override
    public DeliaSession beginSession(String src) {
        return this.doBeginExecution(src, null);
    }

    private DeliaSession doBeginExecution(String src, MigrationPlan plan) {
        DeliaCompiler compiler = this.createCompiler();
        compiler.setDoPass3Flag(false);
        List<Exp> expL = compiler.parse(src);
        Runner mainRunner = this.createRunner(null);
        this.execTypes(mainRunner, expL);
        ResultValue migrationPlanRes = this.doPass3AndDBMigration(src, expL, mainRunner, plan);
        if (migrationPlanRes != null) {
            DeliaSessionImpl session = new DeliaSessionImpl();
            session.execCtx = mainRunner.getExecutionState();
            session.ok = true;
            session.res = migrationPlanRes;
            session.expL = expL;
            return session;
        }
        ResultValue res = this.doExecute(mainRunner, expL);
        DeliaSessionImpl session = new DeliaSessionImpl();
        session.execCtx = mainRunner.getExecutionState();
        session.ok = true;
        session.res = res;
        session.expL = expL;
        return session;
    }

    @Override
    public DeliaSession executeMigrationPlan(String src, MigrationPlan plan) {
        return this.doBeginExecution(src, plan);
    }

    protected void execTypes(Runner mainRunner, List<Exp> extL) {
        ArrayList<DeliaError> allErrors = new ArrayList<DeliaError>();
        TypeRunner typeRunner = mainRunner.createTypeRunner();
        typeRunner.executeStatements(extL, allErrors);
        if (allErrors.isEmpty()) {
            return;
        }
        if (this.numFutureDeclErrors(allErrors) != allErrors.size()) {
            throw new DeliaException(this.getNonFutureDeclErrors(allErrors));
        }
        this.log.log("%d forward decls found - re-executing.", this.numFutureDeclErrors(allErrors));
        allErrors.clear();
        typeRunner.executeStatements(extL, allErrors);
        if (allErrors.isEmpty()) {
            return;
        }
        throw new DeliaException(allErrors);
    }

    private ResultValue doPass3AndDBMigration(String src, List<Exp> extL, Runner mainRunner, MigrationPlan plan) {
        InternalCompileState execCtx = mainRunner.getCompileState();
        for (Exp exp : extL) {
            if (!(exp instanceof TypeStatementExp)) continue;
            TypeStatementExp typeExp = (TypeStatementExp)exp;
            TypeSpec tt = execCtx.compiledTypeMap.get(typeExp.typeName);
            if (tt == null) continue;
            tt.typeExp = typeExp;
        }
        DeliaCompiler compiler = this.doCreateCompiler(execCtx);
        compiler.executePass3(src, extL);
        compiler.executePass4(src, extL, mainRunner.getRegistry());
        if (this.dbInterface.getCapabilities().requiresSchemaMigration()) {
            this.migrationSvc.initPolicy(this.deliaOptions.useSafeMigrationPolicy, this.deliaOptions.enableAutomaticMigrations);
            switch (this.deliaOptions.migrationAction) {
                case MIGRATE: {
                    boolean b;
                    if (this.deliaOptions.disableSQLLoggingDuringSchemaMigration) {
                        boolean prev = this.dbInterface.isSQLLoggingEnabled();
                        this.dbInterface.enableSQLLogging(false);
                        b = this.migrationSvc.autoMigrateDbIfNeeded(mainRunner.getRegistry(), mainRunner);
                        this.dbInterface.enableSQLLogging(prev);
                    } else {
                        b = this.migrationSvc.autoMigrateDbIfNeeded(mainRunner.getRegistry(), mainRunner);
                    }
                    if (b) break;
                    DeliaExceptionHelper.throwError("migration-failed-due-to-policy", "migration needed but not run - can't start", new Object[0]);
                    break;
                }
                case GENERATE_MIGRATION_PLAN: {
                    ResultValue res = new ResultValue();
                    res.ok = true;
                    res.val = this.migrationSvc.createMigrationPlan(mainRunner.getRegistry(), mainRunner);
                    return res;
                }
                case RUN_MIGRATION_PLAN: {
                    ResultValue res = new ResultValue();
                    res.ok = true;
                    res.val = this.migrationSvc.runMigrationPlan(mainRunner.getRegistry(), plan, mainRunner);
                    return res;
                }
            }
        }
        return null;
    }

    public int numFutureDeclErrors(List<DeliaError> errL) {
        int count = 0;
        for (DeliaError err : errL) {
            if (!(err instanceof FutureDeclError)) continue;
            ++count;
        }
        return count;
    }

    public List<DeliaError> getNonFutureDeclErrors(List<DeliaError> errL) {
        ArrayList<DeliaError> filteredL = new ArrayList<DeliaError>();
        for (DeliaError err : errL) {
            if (err instanceof FutureDeclError) continue;
            filteredL.add(err);
        }
        return filteredL;
    }

    @Override
    public ResultValue continueExecution(String src, DeliaSession dbsess) {
        DeliaCompiler compiler = this.createCompiler();
        List<Exp> extL = compiler.parse(src);
        for (Exp exp : extL) {
            if (!(exp instanceof TypeStatementExp)) continue;
            String msg = String.format("'type' statements not allowed in continueExecution - %s", exp.strValue());
            DeliaError err = new DeliaError("type-statement-not-allowed", msg, null);
            throw new DeliaException(err);
        }
        Runner runner = this.createRunner(dbsess);
        ResultValue res = this.doExecute(runner, extL);
        return res;
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public FactoryService getFactoryService() {
        return this.factorySvc;
    }

    @Override
    public DeliaOptions getOptions() {
        return this.deliaOptions;
    }

    @Override
    public DBInterface getDBInterface() {
        return this.dbInterface;
    }
}

