/*
 * Decompiled with CFR 0.152.
 */
package org.delia.builder;

import org.delia.api.Delia;
import org.delia.api.DeliaFactory;
import org.delia.builder.ConnectionInfo;
import org.delia.core.FactoryService;
import org.delia.core.FactoryServiceImpl;
import org.delia.error.SimpleErrorTracker;
import org.delia.log.Log;
import org.delia.log.SimpleLog;

public class DeliaBuilder {
    private static DeliaBuilder theSingleton;
    private ConnectionInfo info;
    private Log log;

    public static DeliaBuilder withConnection(ConnectionInfo info) {
        theSingleton = new DeliaBuilder();
        DeliaBuilder.theSingleton.info = info;
        return theSingleton;
    }

    public DeliaBuilder log(Log log) {
        this.log = log;
        return this;
    }

    public Delia build() {
        if (this.log == null) {
            this.log = new SimpleLog();
        }
        SimpleErrorTracker et = new SimpleErrorTracker(this.log);
        FactoryServiceImpl factorySvc = new FactoryServiceImpl(this.log, et);
        Delia delia = DeliaFactory.create(this.info, this.log, (FactoryService)factorySvc);
        return delia;
    }
}

