/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler;

import java.util.List;
import org.codehaus.jparsec.error.ParserException;
import org.delia.compiler.CompilerResults;
import org.delia.compiler.ErrorLineFinder;
import org.delia.compiler.Pass2Compiler;
import org.delia.compiler.Pass3Compiler;
import org.delia.compiler.Pass4Compiler;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.parser.FullParser;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.error.DeliaError;
import org.delia.runner.DeliaException;
import org.delia.runner.InternalCompileState;
import org.delia.type.DTypeRegistry;

public class DeliaCompiler
extends ServiceBase {
    private InternalCompileState execCtx;
    private boolean doPass3Flag = true;

    public DeliaCompiler(FactoryService factorySvc) {
        super(factorySvc);
    }

    public DeliaCompiler(FactoryService factorySvc, InternalCompileState execCtx) {
        super(factorySvc);
        this.execCtx = execCtx;
    }

    public List<Exp> parse(String input) {
        Pass3Compiler pass3;
        CompilerResults pass3Res;
        Pass2Compiler pass2;
        CompilerResults pass2Res;
        List<Exp> list = null;
        ErrorLineFinder errorLineFinder = new ErrorLineFinder(input);
        try {
            list = FullParser.parse(input);
        }
        catch (ParserException e) {
            this.log.logError("ERR: %s", input);
            DeliaError err = this.et.add("parse-error", e.getMessage());
            throw new DeliaException(err);
        }
        catch (Exception e) {
            DeliaError err = this.et.add("pass2-error", e.getMessage());
            throw new DeliaException(err);
        }
        if (list != null && !(pass2Res = (pass2 = new Pass2Compiler(this.factorySvc, errorLineFinder, this.execCtx)).process(list)).success()) {
            throw new DeliaException(pass2Res.errors);
        }
        if (list != null && this.doPass3Flag && !(pass3Res = (pass3 = new Pass3Compiler(this.factorySvc, errorLineFinder, this.execCtx)).process(list)).success()) {
            throw new DeliaException(pass3Res.errors);
        }
        return list;
    }

    public void executePass3(String input, List<Exp> list) {
        ErrorLineFinder errorLineFinder = new ErrorLineFinder(input);
        if (list != null && this.doPass3Flag) {
            Pass3Compiler pass3 = new Pass3Compiler(this.factorySvc, errorLineFinder, this.execCtx);
            pass3.setBuildTypeMapFlag(false);
            CompilerResults pass3Res = pass3.process(list);
            if (!pass3Res.success()) {
                throw new DeliaException(pass3Res.errors);
            }
        }
    }

    public void executePass4(String input, List<Exp> list, DTypeRegistry registry) {
        Pass4Compiler pass4;
        CompilerResults pass3Res;
        ErrorLineFinder errorLineFinder = new ErrorLineFinder(input);
        if (list != null && !(pass3Res = (pass4 = new Pass4Compiler(this.factorySvc, errorLineFinder, this.execCtx, registry)).process(list)).success()) {
            throw new DeliaException(pass3Res.errors);
        }
    }

    public boolean isDoPass3Flag() {
        return this.doPass3Flag;
    }

    public void setDoPass3Flag(boolean doPass3Flag) {
        this.doPass3Flag = doPass3Flag;
    }
}

