/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.delia.compiler.CompilerPassBase;
import org.delia.compiler.CompilerResults;
import org.delia.compiler.ErrorLineFinder;
import org.delia.compiler.Pass3RuleCompiler;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.LetStatementExp;
import org.delia.compiler.ast.StructFieldExp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.compiler.ast.UserFnCallExp;
import org.delia.compiler.ast.UserFunctionDefStatementExp;
import org.delia.core.FactoryService;
import org.delia.error.DeliaError;
import org.delia.runner.InternalCompileState;
import org.delia.runner.ResultValue;
import org.delia.runner.TypeSpec;
import org.delia.type.BuiltInTypes;

public class Pass3Compiler
extends CompilerPassBase {
    private Map<String, TypeSpec> typeMap = new HashMap<String, TypeSpec>();
    private Map<String, ResultValue> varMap = new HashMap<String, ResultValue>();
    private Map<String, UserFunctionDefStatementExp> userFnMap = new HashMap<String, UserFunctionDefStatementExp>();
    private boolean buildTypeMapFlag = true;
    private Pass3RuleCompiler ruleCompiler;

    public Pass3Compiler(FactoryService factorySvc, ErrorLineFinder errorLineFinder, InternalCompileState execCtx) {
        super(factorySvc, errorLineFinder, execCtx);
        this.ruleCompiler = new Pass3RuleCompiler(factorySvc, errorLineFinder, execCtx);
        if (execCtx != null) {
            this.typeMap.putAll(execCtx.compiledTypeMap);
            this.varMap.putAll(execCtx.delcaredVarMap);
            this.userFnMap.putAll(execCtx.declaredUserFnMap);
        }
    }

    @Override
    public CompilerResults process(List<Exp> list) {
        TypeStatementExp typeExp;
        CompilerResults results = new CompilerResults();
        results.list = list;
        for (Exp exp : list) {
            DeliaError err;
            String msg;
            if (exp instanceof TypeStatementExp) {
                typeExp = (TypeStatementExp)exp;
                if (this.buildTypeMapFlag) {
                    if (this.typeMap.containsKey(typeExp.typeName)) {
                        msg = String.format("type '%s' already defined. Cannot redefine", typeExp.typeName);
                        err = this.createError("type-duplicate", msg, exp);
                        results.errors.add(err);
                    }
                    this.otherTypeChecks(typeExp, results);
                    this.typeMap.put(typeExp.typeName, this.buildFieldList(typeExp));
                    continue;
                }
                this.otherTypeChecks(typeExp, results);
                continue;
            }
            if (exp instanceof LetStatementExp) {
                LetStatementExp letExp = (LetStatementExp)exp;
                if (this.varMap.containsKey(letExp.varName)) {
                    msg = String.format("var '%s' already defined. Cannot redefine", letExp.varName);
                    err = this.createError("var-duplicate", msg, exp);
                    results.errors.add(err);
                }
                this.varMap.put(letExp.varName, null);
                if (!letExp.isType("userFunc")) continue;
                this.checkFuncArgs(letExp, results);
                continue;
            }
            if (!(exp instanceof UserFunctionDefStatementExp)) continue;
            UserFunctionDefStatementExp funcExp = (UserFunctionDefStatementExp)exp;
            if (this.userFnMap.containsKey(funcExp.funcName)) {
                msg = String.format("function '%s' already defined. Cannot redefine", funcExp.funcName);
                err = this.createError("user-func-duplicate", msg, exp);
                results.errors.add(err);
            }
            this.userFnMap.put(funcExp.funcName, funcExp);
        }
        for (Exp exp : list) {
            if (!(exp instanceof TypeStatementExp)) continue;
            typeExp = (TypeStatementExp)exp;
            this.finalTypeChecks(typeExp, results);
        }
        return results;
    }

    private TypeSpec buildFieldList(TypeStatementExp typeExp) {
        TypeSpec spec = new TypeSpec();
        spec.fieldL = new ArrayList<String>();
        spec.typeExp = typeExp;
        String string = spec.baseTypeName = typeExp.baseTypeName.equals("struct") ? null : typeExp.baseTypeName;
        if (typeExp.structExp != null) {
            for (StructFieldExp sfe : typeExp.structExp.argL) {
                spec.fieldL.add(sfe.fieldName);
            }
        }
        return spec;
    }

    private void otherTypeChecks(TypeStatementExp typeExp, CompilerResults results) {
        if (this.isScalarType(typeExp, results, false)) {
            this.checkRules(typeExp, null, results);
            return;
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        this.buildFieldMap(typeExp.baseTypeName, fieldMap);
        this.checkRules(typeExp, fieldMap, results);
        if (typeExp.structExp != null) {
            for (StructFieldExp sfe : typeExp.structExp.argL) {
                DeliaError err;
                String msg;
                StructFieldExp otherSideExp;
                DeliaError err2;
                String msg2;
                if (fieldMap.containsKey(sfe.fieldName)) {
                    msg2 = String.format("field '%s' already defined in type '%s' or its base type(s)", sfe.fieldName, typeExp.typeName);
                    err2 = this.createError("type-field-already-defined-in-base-type", msg2, typeExp);
                    results.errors.add(err2);
                }
                if (this.isStructType(sfe, results, typeExp.typeName, false) && !sfe.isRelation) {
                    msg2 = String.format("struct fields must use 'relation' - field '%s'", sfe.fieldName);
                    err2 = this.createError("missing-relation-decl", msg2, sfe);
                    results.errors.add(err2);
                    continue;
                }
                if (!this.isStructType(sfe, results, typeExp.typeName, false) || !sfe.isRelation) continue;
                if (!sfe.isOne && !sfe.isMany) {
                    msg2 = String.format("type '%s' - relation field '%s' must specify 'primaryKey' or 'one' or 'many'", typeExp.typeName, sfe.fieldName);
                    err2 = this.createError("relation-missing-one-or-many", msg2, typeExp);
                    results.errors.add(err2);
                }
                if ((otherSideExp = this.findOtherSide(typeExp, sfe)) == null) {
                    if (!sfe.isParent) continue;
                    msg = String.format("type '%s' - one-sided relation field '%s' cannot use 'parent'", typeExp.typeName, sfe.fieldName);
                    err = this.createError("relation-parent-not-allowed", msg, typeExp);
                    results.errors.add(err);
                    continue;
                }
                if (!sfe.isOptional && !otherSideExp.isOptional) {
                    msg = String.format("type '%s' - relation field '%s'. M-M relations are not supported", typeExp.typeName, sfe.fieldName);
                    err = this.createError("relation-mandatory-mandatory-not-allowed", msg, typeExp);
                    results.errors.add(err);
                }
                if (!sfe.isParent) continue;
                if (otherSideExp.isParent) {
                    msg = String.format("type '%s' - relation field '%s'. Only one side of relation can use 'parent'", typeExp.typeName, sfe.fieldName);
                    err = this.createError("relation-parent-not-allowed", msg, typeExp);
                    results.errors.add(err);
                }
                if (sfe.isMany) {
                    msg = String.format("type '%s' - relation field '%s' many. Cannot use 'parent'", typeExp.typeName, sfe.fieldName);
                    err = this.createError("relation-parent-not-allowed", msg, typeExp);
                    results.errors.add(err);
                    continue;
                }
                if (!sfe.isOne || sfe.isOptional) continue;
                msg = String.format("type '%s' - relation field '%s'. Child-side cannot use 'parent'", typeExp.typeName, sfe.fieldName);
                err = this.createError("relation-parent-not-allowed", msg, typeExp);
                results.errors.add(err);
            }
        }
    }

    private void checkRules(TypeStatementExp typeExp, Map<String, String> fieldMap, CompilerResults results) {
        if (!this.buildTypeMapFlag) {
            this.ruleCompiler.processTypeExp(typeExp, fieldMap, results);
        }
    }

    private StructFieldExp findOtherSide(TypeStatementExp typeExp, StructFieldExp sfeTarget) {
        TypeSpec tt = this.typeMap.get(sfeTarget.typeName);
        if (tt == null) {
            return null;
        }
        if (tt.typeExp.structExp != null) {
            for (StructFieldExp sfe : tt.typeExp.structExp.argL) {
                if (!sfe.typeName.equals(typeExp.typeName)) continue;
                return sfe;
            }
        }
        return null;
    }

    private void finalTypeChecks(TypeStatementExp typeExp, CompilerResults results) {
        if (this.isScalarType(typeExp, results, true)) {
            return;
        }
        if (typeExp.baseTypeName.equals("struct")) {
            this.checkPrimaryKeys(typeExp, results);
        } else if (!this.typeMap.containsKey(typeExp.baseTypeName)) {
            String msg = String.format("type '%s' uses undefined base type '%s'", typeExp.typeName, typeExp.baseTypeName);
            DeliaError err = this.createError("type-unknown-base-type", msg, typeExp);
            results.errors.add(err);
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        this.buildFieldMap(typeExp.baseTypeName, fieldMap);
        if (typeExp.structExp != null) {
            for (StructFieldExp sfe : typeExp.structExp.argL) {
                this.isStructType(sfe, results, typeExp.typeName, true);
            }
        }
    }

    private void checkPrimaryKeys(TypeStatementExp typeExp, CompilerResults results) {
    }

    private boolean isScalarType(TypeStatementExp typeExp, CompilerResults results, boolean doTypeChecks) {
        TypeSpec tt;
        if (BuiltInTypes.isBuiltInScalarType(typeExp.baseTypeName)) {
            return true;
        }
        String typeName = typeExp.typeName;
        String baseTypeName = typeExp.baseTypeName;
        int runawayCount = 100;
        do {
            if (runawayCount-- == 0) {
                String msg = String.format("runaway on base type '%s'", baseTypeName);
                DeliaError err = this.createError("pass3-runaway", msg, typeExp);
                results.errors.add(err);
                return false;
            }
            if (BuiltInTypes.isBuiltInScalarType(baseTypeName)) {
                return true;
            }
            if (baseTypeName.equals("struct")) {
                return false;
            }
            if (this.isShapeType(baseTypeName)) {
                return true;
            }
            tt = this.typeMap.get(baseTypeName);
            if (tt == null && doTypeChecks) {
                String msg = String.format("type '%s' uses undefined base type '%s'", typeName, baseTypeName);
                DeliaError err = this.createError("type-unknown-base-type", msg, typeExp);
                results.errors.add(err);
                return false;
            }
            typeName = baseTypeName;
        } while ((baseTypeName = tt.baseTypeName) != null);
        return false;
    }

    private boolean isShapeType(String baseTypeName) {
        BuiltInTypes bit = null;
        try {
            bit = BuiltInTypes.valueOf(baseTypeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bit != null;
    }

    private boolean isStructType(StructFieldExp sfe, CompilerResults results, String typeName, boolean doTypeChecks) {
        if (BuiltInTypes.fromDeliaTypeName(sfe.typeName) != null) {
            return false;
        }
        TypeSpec spec = this.typeMap.get(sfe.typeName);
        if (spec == null) {
            if (doTypeChecks) {
                String msg = String.format("type '%s' uses undefined type '%s'", typeName, sfe.typeName);
                DeliaError err = this.createError("type-unknown-base-type", msg, sfe);
                results.errors.add(err);
            }
            return false;
        }
        if (spec.baseTypeName == null) {
            return true;
        }
        if (BuiltInTypes.valueOf(spec.baseTypeName) != null) {
            return false;
        }
        return false;
    }

    private void buildFieldMap(String baseTypeName, Map<String, String> fieldMap) {
        if (baseTypeName == null || baseTypeName.equals("struct")) {
            return;
        }
        TypeSpec spec = this.typeMap.get(baseTypeName);
        for (String s : spec.fieldL) {
            fieldMap.put(s, s);
        }
        this.buildFieldMap(spec.baseTypeName, fieldMap);
    }

    private void checkFuncArgs(LetStatementExp letExp, CompilerResults results) {
        int nPassed;
        UserFnCallExp callExp = (UserFnCallExp)letExp.value;
        UserFunctionDefStatementExp userFnExp = this.userFnMap.get(callExp.funcName);
        if (userFnExp == null) {
            String msg = String.format("can't find function '%s'", callExp.funcName);
            DeliaError err = this.createError("user-func-not-found", msg, callExp);
            results.errors.add(err);
            return;
        }
        int nDecl = userFnExp.argsL.size();
        if (nDecl != (nPassed = callExp.argL.size())) {
            String msg = String.format("function '%s' has %d args, but only %d args passed.", callExp.funcName, nDecl, nPassed);
            DeliaError err = this.createError("user-func-wrong-num-args", msg, callExp);
            results.errors.add(err);
        }
    }

    public boolean isBuildTypeMapFlag() {
        return this.buildTypeMapFlag;
    }

    public void setBuildTypeMapFlag(boolean buildTypeMapFlag) {
        this.buildTypeMapFlag = buildTypeMapFlag;
    }
}

