/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler;

import java.util.List;
import java.util.Map;
import org.delia.compiler.CompilerPassBase;
import org.delia.compiler.CompilerResults;
import org.delia.compiler.ErrorLineFinder;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.FilterOpExp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.RuleExp;
import org.delia.compiler.ast.StructFieldExp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.compiler.astx.XNAFMultiExp;
import org.delia.compiler.astx.XNAFSingleExp;
import org.delia.core.FactoryService;
import org.delia.error.DeliaError;
import org.delia.runner.InternalCompileState;
import org.delia.type.BuiltInTypes;
import org.delia.typebuilder.RuleFuncFactory;

public class Pass3RuleCompiler
extends CompilerPassBase {
    public Pass3RuleCompiler(FactoryService factorySvc, ErrorLineFinder errorLineFinder, InternalCompileState execCtx) {
        super(factorySvc, errorLineFinder, execCtx);
    }

    @Override
    public CompilerResults process(List<Exp> list) {
        throw new RuntimeException("not allowed");
    }

    public void processTypeExp(TypeStatementExp typeExp, Map<String, String> fieldMap, CompilerResults results) {
        if (typeExp.hasRules()) {
            for (RuleExp ruleExp : typeExp.ruleSetExp.ruleL) {
                this.checkRule(results, ruleExp, typeExp, fieldMap);
            }
        }
    }

    private void addError(CompilerResults results, String id, String msg, Exp exp) {
        DeliaError err = this.createError(id, msg, exp);
        results.errors.add(err);
    }

    private boolean isScalar(StructFieldExp qfe) {
        return BuiltInTypes.isBuiltInScalarType(qfe.typeName);
    }

    private void checkRule(CompilerResults results, RuleExp ruleExp, TypeStatementExp typeExp, Map<String, String> fieldMap) {
        if (ruleExp.opExpr instanceof FilterOpExp) {
            FilterOpExp foe = (FilterOpExp)ruleExp.opExpr;
            Exp exp = foe.op1;
            this.checkRuleOperand(results, exp, typeExp, ruleExp, fieldMap);
            exp = foe.op2;
            this.checkRuleOperand(results, exp, typeExp, ruleExp, fieldMap);
        }
    }

    private void checkRuleOperand(CompilerResults results, Exp exp, TypeStatementExp typeExp, RuleExp ruleExp, Map<String, String> fieldMap) {
        if (exp instanceof IdentExp) {
            if (!this.findField(exp.strValue(), typeExp, fieldMap)) {
                String ruleText = ruleExp.toString();
                String msg = String.format("Rule '%s' - can't find field '%s'", ruleText, exp.strValue());
                this.addError(results, "rule-op-not-found", msg, exp);
            }
        } else if (exp instanceof XNAFMultiExp) {
            XNAFMultiExp rfe = (XNAFMultiExp)exp;
            if (rfe.qfeL.size() == 1) {
                XNAFSingleExp qfe = rfe.qfeL.get(0);
                if (qfe.argL.size() == 0) {
                    if (!qfe.isRuleFn && this.findField(qfe.funcName, typeExp, fieldMap)) {
                        return;
                    }
                    RuleFuncFactory ruleFactory = new RuleFuncFactory(this.factorySvc);
                    if (ruleFactory.createRule(rfe, 0) != null) {
                        return;
                    }
                    String msg = String.format("unknown field or function: '%s'", qfe.funcName);
                    this.addError(results, "rule-unknown-field-or-fn", msg, qfe);
                }
            } else if (rfe.qfeL.size() == 2) {
                XNAFSingleExp qfe0 = rfe.qfeL.get(0);
                XNAFSingleExp qfe1 = rfe.qfeL.get(1);
                if (!qfe0.isRuleFn && qfe1.isRuleFn) {
                    RuleFuncFactory ruleFactory = new RuleFuncFactory(this.factorySvc);
                    if (ruleFactory.createRule(rfe, 0) != null) {
                        return;
                    }
                    String msg = String.format("unknown field or function: '%s'", qfe1.funcName);
                    this.addError(results, "rule-unknown-field-or-fn", msg, qfe1);
                }
            }
        }
    }

    private boolean findField(String targetFieldName, TypeStatementExp typeExp, Map<String, String> fieldMap) {
        if (fieldMap != null && fieldMap.containsKey(targetFieldName)) {
            return true;
        }
        for (StructFieldExp fieldExp : typeExp.structExp.argL) {
            if (!fieldExp.getFieldName().equals(targetFieldName)) continue;
            return true;
        }
        return false;
    }
}

