/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler;

import java.util.List;
import org.delia.compiler.CompilerPassBase;
import org.delia.compiler.CompilerResults;
import org.delia.compiler.ErrorLineFinder;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.core.FactoryService;
import org.delia.error.DeliaError;
import org.delia.runner.InternalCompileState;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.TypePair;
import org.delia.util.DValueHelper;

public class Pass4Compiler
extends CompilerPassBase {
    private DTypeRegistry registry;

    public Pass4Compiler(FactoryService factorySvc, ErrorLineFinder errorLineFinder, InternalCompileState execCtx, DTypeRegistry registry) {
        super(factorySvc, errorLineFinder, execCtx);
        this.registry = registry;
    }

    @Override
    public CompilerResults process(List<Exp> list) {
        CompilerResults results = new CompilerResults();
        results.list = list;
        for (Exp exp : list) {
            if (!(exp instanceof TypeStatementExp)) continue;
            TypeStatementExp typeExp = (TypeStatementExp)exp;
            this.checkPrimaryKeys(typeExp, results);
        }
        return results;
    }

    private void checkPrimaryKeys(TypeStatementExp typeExp, CompilerResults results) {
        DeliaError err;
        String msg;
        DType type = this.registry.getType(typeExp.typeName);
        if (!type.isStructShape()) {
            return;
        }
        DStructType structType = (DStructType)type;
        TypePair pair = DValueHelper.findPrimaryKeyFieldPair(structType);
        if (pair == null) {
            return;
        }
        if (!this.keyFieldIsAllowedType(pair)) {
            msg = String.format("type '%s': primary key type %s is not allowed in field '%s'", typeExp.typeName, pair.type.getName(), pair.name);
            err = this.createError("primary-key-type-not-allowed", msg, typeExp);
            results.errors.add(err);
        }
        if (!this.serialFieldIsAllowedType(pair, structType)) {
            msg = String.format("type '%s': serial %s is not allowed in field '%s'", typeExp.typeName, pair.type.getName(), pair.name);
            err = this.createError("primary-key-type-not-allowed", msg, typeExp);
            results.errors.add(err);
        }
    }

    private boolean keyFieldIsAllowedType(TypePair pair) {
        switch (pair.type.getShape()) {
            case INTEGER: 
            case LONG: 
            case BOOLEAN: 
            case STRING: 
            case DATE: {
                return true;
            }
        }
        return false;
    }

    private boolean serialFieldIsAllowedType(TypePair pair, DStructType structType) {
        if (!structType.fieldIsSerial(pair.name)) {
            return true;
        }
        switch (pair.type.getShape()) {
            case INTEGER: 
            case LONG: {
                return true;
            }
        }
        return false;
    }
}

