/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.LongExp;
import org.delia.compiler.ast.StringExp;
import org.delia.compiler.astx.XNAFMultiExp;

public abstract class ExpBase
implements Exp {
    public int pos = 0;

    public ExpBase(int pos) {
        this.pos = pos;
    }

    @Override
    public int getPos() {
        return this.pos;
    }

    protected String formatValue(Exp value) {
        if (value != null) {
            if (value instanceof LongExp) {
                return value.strValue();
            }
            if (value instanceof IntegerExp) {
                return value.strValue();
            }
            if (value instanceof StringExp) {
                return String.format("'%s'", value.strValue());
            }
            if (value instanceof XNAFMultiExp) {
                return String.format("%s", value.strValue());
            }
            return value.strValue();
        }
        return null;
    }
}

