/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.StringExp;
import org.delia.compiler.astx.XNAFMultiExp;
import org.delia.compiler.astx.XNAFNameExp;
import org.delia.compiler.astx.XNAFSingleExp;

public class FilterOpExp
extends ExpBase {
    public Exp op1;
    public String op;
    public Exp op2;

    public FilterOpExp(int pos, Exp op1, StringExp op, Exp op2) {
        super(pos);
        this.op1 = op1;
        this.op = op == null ? null : op.strValue();
        this.op2 = op2;
    }

    @Override
    public String strValue() {
        return this.op;
    }

    public String toString() {
        String s1 = this.formatValue(this.op1);
        String s2 = this.formatValue(this.op2);
        String s = String.format("%s %s %s", s1, this.op, s2);
        return s;
    }

    public Exp getFirstArg() {
        if (this.op1 instanceof XNAFMultiExp) {
            XNAFSingleExp inner;
            XNAFMultiExp multiexp = (XNAFMultiExp)this.op1;
            if (multiexp.qfeL.size() == 1 && (inner = multiexp.qfeL.get(0)) instanceof XNAFNameExp) {
                XNAFNameExp nameexp = (XNAFNameExp)inner;
                return new IdentExp(nameexp.funcName);
            }
        }
        return this.op1;
    }

    public Exp getSecondArg() {
        if (this.op2 instanceof XNAFMultiExp) {
            XNAFSingleExp inner;
            XNAFMultiExp multiexp = (XNAFMultiExp)this.op2;
            if (multiexp.qfeL.size() == 1 && (inner = multiexp.qfeL.get(0)) instanceof XNAFNameExp) {
                XNAFNameExp nameexp = (XNAFNameExp)inner;
                return new IdentExp(nameexp.funcName);
            }
        }
        return this.op2;
    }
}

