/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.FilterOpExp;
import org.delia.compiler.ast.QueryInExp;

public class FilterOpFullExp
extends ExpBase {
    public boolean negFlag;
    public Exp opexp1;
    public Exp opexp2;
    public boolean isAnd;

    public FilterOpFullExp(int pos, boolean negFlag, Exp opexp1, boolean isAnd, Exp opexp2) {
        super(pos);
        this.negFlag = negFlag;
        this.opexp1 = opexp1;
        this.opexp2 = opexp2;
        this.isAnd = isAnd;
    }

    public FilterOpFullExp(int pos, FilterOpExp opexp1) {
        super(pos);
        this.negFlag = false;
        this.opexp1 = opexp1;
        this.opexp2 = null;
        this.isAnd = false;
    }

    public FilterOpFullExp(int pos, QueryInExp opexp1) {
        super(pos);
        this.negFlag = false;
        this.opexp1 = opexp1;
        this.opexp2 = null;
        this.isAnd = false;
    }

    public FilterOpFullExp negate() {
        this.negFlag = !this.negFlag;
        return this;
    }

    public boolean isSingleFilterOpExp() {
        return this.opexp1 instanceof FilterOpExp && this.opexp2 == null;
    }

    public boolean isSingleQueryInExp() {
        return this.opexp1 instanceof QueryInExp && this.opexp2 == null;
    }

    @Override
    public String strValue() {
        return this.toString();
    }

    public String toString() {
        String s1 = this.negFlag ? "!" : "";
        String s2 = this.opexp1.toString();
        if (this.opexp2 == null) {
            String s = String.format("%s%s", s1, s2);
            return s;
        }
        String s3 = this.isAnd ? "and" : "or";
        String s4 = this.opexp2.toString();
        String s = String.format("%s%s %s %s", s1, s2, s3, s4);
        return s;
    }
}

