/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import java.util.StringJoiner;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.FilterOpExp;
import org.delia.compiler.astx.XNAFMultiExp;
import org.delia.compiler.astx.XNAFSingleExp;

public class RuleExp
extends ExpBase {
    public Exp opExpr;

    public RuleExp(int pos, Exp opExp) {
        super(pos);
        this.opExpr = opExp;
    }

    @Override
    public String strValue() {
        if (this.opExpr instanceof FilterOpExp) {
            FilterOpExp foe = (FilterOpExp)this.opExpr;
            String s1 = this.formatValue(foe.op1);
            String s2 = this.formatValue(foe.op2);
            String s = String.format("%s %s %s", s1, foe.op, s2);
            return s;
        }
        if (this.opExpr instanceof XNAFMultiExp) {
            XNAFMultiExp rfe = (XNAFMultiExp)this.opExpr;
            StringJoiner joiner = new StringJoiner(",");
            if (rfe.qfeL.size() == 2) {
                XNAFSingleExp qfe0 = rfe.qfeL.get(0);
                XNAFSingleExp qfe1 = rfe.qfeL.get(1);
                if (!qfe0.isRuleFn && qfe1.isRuleFn) {
                    String ss = String.format("%s.%s(", qfe0.funcName, qfe1.funcName);
                    StringJoiner j2 = new StringJoiner(",");
                    for (Exp x : qfe1.argL) {
                        j2.add(x.strValue());
                    }
                    ss = ss + j2.toString();
                    ss = ss + ")";
                    joiner.add(ss);
                }
            } else {
                for (XNAFSingleExp qfe : rfe.qfeL) {
                    joiner.add(qfe.funcName);
                    joiner.add("()");
                }
            }
            return joiner.toString();
        }
        return "";
    }

    public String toString() {
        return this.strValue();
    }
}

