/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.generate;

import org.delia.compiler.generate.GeneratorContext;
import org.delia.compiler.generate.ValueGenerator;
import org.delia.compiler.generate.ValuePlacement;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.type.DRelation;
import org.delia.type.DStructHelper;
import org.delia.type.DStructType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.TypePair;

public class DeliaGeneratePhase
extends ServiceBase {
    private DTypeRegistry registry;

    public DeliaGeneratePhase(FactoryService factorySvc, DTypeRegistry registry) {
        super(factorySvc);
        this.registry = registry;
    }

    public boolean generateValue(ValueGenerator visitor, DValue dval, String varName) {
        boolean b = false;
        try {
            b = this.doGenerateValue(visitor, dval, varName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    private boolean doGenerateValue(ValueGenerator visitor, DValue dval, String varName) throws Exception {
        this.doval(visitor, varName, dval, null, new GeneratorContext(), 0);
        if (!visitor.finish()) {
            this.et.add("value-visitor-finish-fail", "value-visitor finish() failed");
        }
        return this.areNoErrors();
    }

    private boolean areNoErrors() {
        return this.et.areNoErrors();
    }

    private void doval(ValueGenerator visitor, String varName, DValue dval, String name, GeneratorContext genctx, int indexParam) throws Exception {
        if (dval == null) {
            if (genctx.isEquals("S")) {
                visitor.structMemberValue(name, dval, genctx, indexParam);
            } else {
                visitor.scalarValue(varName, dval, genctx);
            }
        } else if (dval.getType().isStructShape()) {
            DStructType structType = (DStructType)dval.getType();
            ValuePlacement placement = new ValuePlacement(varName, name);
            visitor.startStruct(placement, dval, structType, genctx, indexParam);
            genctx.pushShapeCode("S");
            DStructHelper helper = dval.asStruct();
            int index = 0;
            for (TypePair pair : structType.getAllFields()) {
                String fieldName = pair.name;
                DValue inner = helper.getField(fieldName);
                this.doval(visitor, null, inner, fieldName, genctx, index);
                if (inner != null && inner.getType().isRelationShape()) {
                    this.doFetchedValues(visitor, inner, genctx);
                }
                ++index;
            }
            genctx.popShapeCode();
            visitor.endStruct(placement, dval, structType, genctx);
        } else if (genctx.isEquals("S")) {
            visitor.structMemberValue(name, dval, genctx, indexParam);
        } else {
            visitor.scalarValue(varName, dval, genctx);
        }
    }

    private void doFetchedValues(ValueGenerator visitor, DValue inner, GeneratorContext genctx) throws Exception {
        if (!genctx.expandSubOjectsFlag) {
            return;
        }
        genctx.expandSubOjectsFlag = false;
        genctx.indentLevel = 1;
        DRelation drel = inner.asRelation();
        if (!drel.haveFetched()) {
            return;
        }
        for (DValue dval : drel.getFetchedItems()) {
            this.doval(visitor, null, dval, null, genctx, 0);
        }
        genctx.expandSubOjectsFlag = true;
        genctx.indentLevel = 0;
        visitor.endSubValue(genctx);
    }
}

