/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.generate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.delia.compiler.generate.GeneratorContext;
import org.delia.compiler.generate.ValueGenerator;
import org.delia.compiler.generate.ValuePlacement;
import org.delia.type.BuiltInTypes;
import org.delia.type.DRelation;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DValue;
import org.delia.type.Shape;

public class SimpleFormatOutputGenerator
implements ValueGenerator {
    public boolean includeVPrefix = true;
    public List<String> outputL = new ArrayList<String>();

    @Override
    public void startStruct(ValuePlacement placement, DValue dval, DStructType structType, GeneratorContext genctx, int index) {
        if (placement.isTopLevelValue) {
            String typeName = this.getTypeName(dval.getType());
            String s = String.format("value:%s:%s {", placement.name, typeName);
            this.write(s, genctx);
        } else if (placement.name == null) {
            String s = String.format(" {", new Object[0]);
            this.write(s, genctx);
        } else {
            String typeName = this.getTypeName(dval.getType());
            String s = String.format("value:%s:%s {", placement.name, typeName);
            this.write(s, genctx);
        }
    }

    @Override
    public void endStruct(ValuePlacement placement, DValue dval, DStructType structType, GeneratorContext genctx) {
        this.write("}", genctx);
    }

    @Override
    public void structMemberValue(String fieldName, DValue dval, GeneratorContext genctx, int index) {
        String value = this.DValToString(dval);
        String s = this.includeVPrefix ? String.format(" v%s:%s", fieldName, value) : String.format(" %s:%s", fieldName, value);
        this.write(s, genctx);
    }

    @Override
    public void scalarValue(String varName, DValue dval, GeneratorContext genctx) {
        if (varName != null) {
            if (dval == null) {
                this.write("null", genctx);
            } else {
                String typeName = this.getTypeName(dval.getType());
                String value = this.DValToString(dval);
                String s = String.format("value:%s:%s:%s", varName, typeName, value);
                this.write(s, genctx);
            }
        }
    }

    private void addRules(DType dtype) {
    }

    private String getTypeName(DType dtype) {
        String typeName = dtype.getName();
        typeName = BuiltInTypes.convertDTypeNameToDeliaName(typeName);
        return typeName;
    }

    private String genIndent(int amount) {
        String space = "";
        for (int i = 0; i < amount; ++i) {
            space = space + " ";
        }
        return space;
    }

    private String DValToString(DValue dval) {
        if (dval == null) {
            return "null";
        }
        if (dval.getType().isShape(Shape.RELATION)) {
            DRelation rel = dval.asRelation();
            if (rel.isMultipleKey()) {
                return this.buildMultipleRef(rel);
            }
            String keyStr = rel.getForeignKey().asString();
            String suffix = rel.haveFetched() ? ":" : "}";
            return String.format("{%s%s", keyStr, suffix);
        }
        if (dval.getType().isShape(Shape.STRING)) {
            String s = dval.asString();
            return String.format("'%s'", s);
        }
        return dval.asString();
    }

    private String buildMultipleRef(DRelation rel) {
        StringJoiner joiner = new StringJoiner(",");
        for (DValue key : rel.getMultipleKeys()) {
            joiner.add(key.asString());
        }
        return String.format("{[%s]}", joiner.toString());
    }

    @Override
    public boolean finish() {
        return true;
    }

    private String createIndent(GeneratorContext genctx) {
        int len = genctx.indentLevel * 2;
        char[] charArray = new char[len];
        Arrays.fill(charArray, ' ');
        String str = new String(charArray);
        return str;
    }

    private void write(String s, GeneratorContext genctx) {
        String indent = this.createIndent(genctx);
        this.outputL.add(indent + s);
    }

    @Override
    public void endSubValue(GeneratorContext genctx) {
        this.write("}", genctx);
    }
}

