/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.parser;

import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.delia.compiler.ast.CrudExp;
import org.delia.compiler.ast.DeleteStatementExp;
import org.delia.compiler.ast.DsonExp;
import org.delia.compiler.ast.DsonFieldExp;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.InsertStatementExp;
import org.delia.compiler.ast.ListExp;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.UpdateStatementExp;
import org.delia.compiler.parser.LetParser;
import org.delia.compiler.parser.ParserBase;
import org.delia.compiler.parser.QueryParser;

public class CrudParser
extends ParserBase {
    public static Parser<Exp> singleFieldValue() {
        return Parsers.or(LetParser.explicitValue(), CrudParser.varName());
    }

    public static Parser<ListExp> multiFieldValue() {
        return Parsers.sequence(CrudParser.term("["), (Parser)CrudParser.singleFieldValue().many().sepBy(CrudParser.term(",")), CrudParser.term("]"), (t1, exps, t2) -> new ListExp(99, (List<List<Exp>>)exps));
    }

    public static Parser<Exp> fieldValue() {
        return Parsers.or(CrudParser.multiFieldValue(), CrudParser.singleFieldValue());
    }

    public static Parser<IdentExp> dsonFieldName() {
        return Parsers.sequence(CrudParser.ident(), CrudParser.term(":"), (fieldNameExp, tok) -> fieldNameExp);
    }

    public static Parser<Exp> dsonField() {
        return Parsers.sequence((Parser)CrudParser.dsonFieldName().optional(), CrudParser.fieldValue(), (fieldNameExp, exp) -> new DsonFieldExp(99, (IdentExp)fieldNameExp, (Exp)exp));
    }

    public static Parser<DsonExp> dsonObj() {
        return Parsers.sequence(CrudParser.term("{"), (Parser)CrudParser.dsonField().many().sepBy(CrudParser.term(",")), CrudParser.term("}"), (tok, arg, tok2) -> new DsonExp(tok.index(), (List<List<Exp>>)arg));
    }

    public static Parser<InsertStatementExp> insertStatement() {
        return Parsers.sequence(CrudParser.term("insert"), CrudParser.ident(), CrudParser.dsonObj(), (tok, typeName, dsonExp) -> new InsertStatementExp(99, (IdentExp)typeName, (DsonExp)dsonExp));
    }

    public static Parser<UpdateStatementExp> updateStatement() {
        return Parsers.sequence(CrudParser.term("update"), QueryParser.partialQuery(), CrudParser.dsonObj(), (tok, queryExp, dsonExp) -> new UpdateStatementExp(99, (QueryExp)queryExp, (DsonExp)dsonExp));
    }

    public static Parser<DeleteStatementExp> deleteStatement() {
        return Parsers.sequence(CrudParser.term("delete"), QueryParser.partialQuery(), (tok, queryExp) -> new DeleteStatementExp(99, queryExp.typeName, (QueryExp)queryExp));
    }

    public static Parser<CrudExp> allCrudStatements() {
        return Parsers.or(CrudParser.insertStatement(), CrudParser.updateStatement(), CrudParser.deleteStatement());
    }
}

