/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.parser;

import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Token;
import org.codehaus.jparsec.functors.Map;
import org.delia.compiler.ast.BooleanExp;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.LetStatementExp;
import org.delia.compiler.ast.LongExp;
import org.delia.compiler.ast.NullExp;
import org.delia.compiler.ast.NumberExp;
import org.delia.compiler.ast.StringExp;
import org.delia.compiler.ast.UserFnCallExp;
import org.delia.compiler.parser.ParserBase;
import org.delia.compiler.parser.QueryParser;
import org.delia.compiler.parser.TerminalParser;

public class LetParser
extends ParserBase {
    public static Parser<BooleanExp> booleanvalueassign() {
        return Parsers.or(TerminalParser.tokenExpT("true", new BooleanExp(true)), TerminalParser.tokenExpT("false", new BooleanExp(false)));
    }

    public static Parser<StringExp> stringvalueassign() {
        return Parsers.or((Parser[])new Parser[]{TerminalParser.stringSyntacticParser}).map((Map)new Map<String, StringExp>(){

            public StringExp map(String arg0) {
                return new StringExp(arg0);
            }
        });
    }

    public static Exp numberBuilder(int pos, Token negSign, String input) {
        if (input != null && input.contains(".")) {
            NumberExp exp = new NumberExp(pos, Double.parseDouble(input));
            if (negSign != null) {
                exp.val = -1.0 * exp.val;
            }
            return exp;
        }
        String tmpStr = negSign != null ? "-" + input : input;
        Long lvalue = Long.parseLong(tmpStr);
        Integer ivalue = lvalue.intValue();
        if (ivalue.longValue() == lvalue.longValue()) {
            IntegerExp exp = new IntegerExp(pos, lvalue.intValue());
            return exp;
        }
        LongExp exp = new LongExp(pos, lvalue);
        return exp;
    }

    public static Parser<Token> optionalNegSign() {
        return LetParser.term("-").optional();
    }

    public static Parser<Exp> someNumberValueassign() {
        return Parsers.sequence((Parser)Parsers.INDEX, LetParser.optionalNegSign(), TerminalParser.numberSyntacticParser, (pos, tok, s) -> LetParser.numberBuilder(pos, tok, s));
    }

    public static Parser<Exp> righthandside() {
        return Parsers.or(LetParser.explicitValue(), LetParser.userFnCall(), QueryParser.fullQuery(), LetParser.ident());
    }

    private static Parser<Exp> nullValue() {
        return Parsers.or((Parser[])new Parser[]{LetParser.term("null")}).map((Map)new Map<Token, NullExp>(){

            public NullExp map(Token arg0) {
                return new NullExp();
            }
        });
    }

    public static Parser<Exp> userFnCall() {
        return Parsers.sequence((Parser)Parsers.INDEX, LetParser.ident(), LetParser.term("("), (Parser)QueryParser.fnOperand().many().sepBy(LetParser.term(",")), LetParser.term(")"), (pos, fnName, tok1, list, tok2) -> new UserFnCallExp((int)pos, (IdentExp)fnName, (List<List<Exp>>)list));
    }

    public static Parser<Exp> explicitValue() {
        return Parsers.or(LetParser.booleanvalueassign(), LetParser.someNumberValueassign(), LetParser.stringvalueassign(), LetParser.nullValue());
    }

    public static Parser<Exp> letAssignment() {
        return Parsers.sequence(LetParser.term("let"), LetParser.varName(), (Parser)LetParser.ident().optional(), LetParser.term("="), LetParser.righthandside(), (tok, varName, typeName, eq, strexp) -> new LetStatementExp(tok.index(), (IdentExp)varName, (IdentExp)typeName, (Exp)strexp));
    }

    public static Parser<Exp> dollarDollarAssignment() {
        return Parsers.or((Parser[])new Parser[]{LetParser.righthandside()}).map((Map)new Map<Exp, LetStatementExp>(){

            public LetStatementExp map(Exp exp) {
                return new LetStatementExp(exp.getPos(), new IdentExp("$$"), null, exp);
            }
        });
    }
}

