/*
 * Decompiled with CFR 0.152.
 */
package org.delia.dao;

import org.delia.api.Delia;
import org.delia.api.DeliaFactory;
import org.delia.api.DeliaSession;
import org.delia.builder.ConnectionInfo;
import org.delia.builder.DeliaBuilder;
import org.delia.core.FactoryService;
import org.delia.core.FactoryServiceImpl;
import org.delia.db.DBInterface;
import org.delia.db.DBType;
import org.delia.db.sql.ConnectionString;
import org.delia.error.SimpleErrorTracker;
import org.delia.log.Log;
import org.delia.runner.ResultValue;
import org.delia.type.DTypeRegistry;
import org.delia.util.DeliaExceptionHelper;

public class DeliaDao {
    private Delia delia;
    private DBInterface dbInterface;
    private DeliaSession mostRecentSess;
    private FactoryService factorySvc;

    public DeliaDao(ConnectionInfo info) {
        this(DeliaBuilder.withConnection(info).build());
    }

    public DeliaDao(Delia delia) {
        this.dbInterface = delia.getDBInterface();
        this.factorySvc = delia.getFactoryService();
        this.delia = delia;
    }

    public DeliaDao(ConnectionString connString, DBType dbType, Log log) {
        SimpleErrorTracker et = new SimpleErrorTracker(log);
        this.factorySvc = new FactoryServiceImpl(log, et);
        this.delia = DeliaFactory.create(connString, dbType, log, this.factorySvc);
    }

    public boolean initialize(String src) {
        this.mostRecentSess = null;
        ResultValue res = new ResultValue();
        res = this.beginExecution(src);
        return res.ok;
    }

    protected ResultValue beginExecution(String src) {
        if (this.mostRecentSess != null) {
            DeliaExceptionHelper.throwError("dao-init-error", "can't start a Dao more than once", new Object[0]);
        }
        this.mostRecentSess = this.delia.beginSession(src);
        return this.mostRecentSess.getFinalResult();
    }

    public ResultValue execute(String src) {
        ResultValue res = this.delia.continueExecution(src, this.mostRecentSess);
        return res;
    }

    public ResultValue queryByPrimaryKey(String type, String primaryKey) {
        String src = String.format("let $$ = %s[%s]", type, primaryKey);
        return this.execute(src);
    }

    public ResultValue queryByFilter(String type, String filter) {
        String src = String.format("let $$ = %s[%s]", type, filter);
        return this.execute(src);
    }

    public ResultValue queryByStatement(String type, String filterEx) {
        String src = String.format("let $$ = %s%s", type, filterEx);
        return this.execute(src);
    }

    public ResultValue insertOne(String type, String fields) {
        String src = !fields.startsWith("{") ? String.format("insert %s {%s}", type, fields) : String.format("insert %s %s", type, fields);
        return this.execute(src);
    }

    public ResultValue updateOne(String type, String primaryKey, String fields) {
        String src = !fields.startsWith("{") ? String.format("update %s[%s] {%s}", type, primaryKey, fields) : String.format("update %s[%s] %s", type, primaryKey, fields);
        return this.execute(src);
    }

    public ResultValue deleteOne(String type, String primaryKey) {
        String src = String.format("delete %s[%s]", type, primaryKey);
        return this.execute(src);
    }

    public Delia getDelia() {
        return this.delia;
    }

    public DBInterface getDbInterface() {
        return this.dbInterface;
    }

    public DeliaSession getMostRecentSess() {
        return this.mostRecentSess;
    }

    public FactoryService getFactorySvc() {
        return this.factorySvc;
    }

    public DTypeRegistry getRegistry() {
        if (this.mostRecentSess == null) {
            DeliaExceptionHelper.throwError("dao-registry-not-created-yet", "you must call initialize() before calling this method", new Object[0]);
        }
        return this.mostRecentSess.getExecutionContext().registry;
    }
}

