/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringJoiner;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBAccessContext;
import org.delia.db.DBErrorConverter;
import org.delia.db.ResultSetHelper;
import org.delia.db.SqlExecuteContext;
import org.delia.db.ValueHelper;
import org.delia.db.h2.DBListingType;
import org.delia.db.sql.ConnectionFactory;
import org.delia.db.sql.prepared.PreparedStatementGenerator;
import org.delia.db.sql.prepared.SqlStatement;
import org.delia.log.Log;

public class DBConnectionBase
extends ServiceBase {
    protected Connection conn;
    protected ConnectionFactory connectionFactory;
    private ValueHelper valueHelper;
    private DBErrorConverter errorConverter;

    public DBConnectionBase(FactoryService factorySvc, ConnectionFactory connectionFactory, DBErrorConverter errorConverter) {
        super(factorySvc);
        this.connectionFactory = connectionFactory;
        this.valueHelper = new ValueHelper(factorySvc);
        this.errorConverter = errorConverter;
    }

    public void openDB() {
        if (this.conn != null) {
            return;
        }
        this.conn = this.connectionFactory.createConnection();
    }

    public boolean execStatement(SqlStatement statement, SqlExecuteContext sqlctx) {
        boolean b = false;
        try {
            PreparedStatement stm = this.createPrepStatement(statement, sqlctx);
            b = stm.execute();
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        return b;
    }

    public int executeInsertStatement(SqlStatement statement, SqlExecuteContext sqlctx) {
        if (sqlctx.getGeneratedKeys) {
            return this.executeInsertAndGenKeysx(statement, sqlctx);
        }
        boolean b = false;
        int affectedRows = 0;
        try {
            PreparedStatement stm = this.createPrepStatement(statement, sqlctx);
            affectedRows = stm.executeUpdate();
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        this.log.logDebug("b:%b %d", b, affectedRows);
        return affectedRows;
    }

    private int executeInsertAndGenKeysx(SqlStatement statement, SqlExecuteContext sqlctx) {
        boolean b = false;
        int affectedRows = 0;
        try {
            PreparedStatement stm = this.valueHelper.createPrepStatementWithGenKey(statement, this.conn);
            affectedRows = stm.executeUpdate();
            if (affectedRows > 0) {
                sqlctx.genKeys = stm.getGeneratedKeys();
            }
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        this.log.logDebug("b:%b %d", b, affectedRows);
        return affectedRows;
    }

    public int execUpdateStatement(SqlStatement statement, SqlExecuteContext sqlctx) {
        int updateCount = 0;
        try {
            PreparedStatement stm = this.createPrepStatement(statement, sqlctx);
            updateCount = stm.executeUpdate();
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        return updateCount;
    }

    public ResultSet execQueryStatement(SqlStatement statement, DBAccessContext dbctx) {
        ResultSet rs = null;
        try {
            PreparedStatement stm = this.createPrepStatement(statement, dbctx);
            rs = stm.executeQuery();
            return rs;
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
            return rs;
        }
    }

    private PreparedStatement createPrepStatement(SqlStatement statement, DBAccessContext dbctx) throws SQLException {
        return this.valueHelper.createPrepStatement(statement, this.conn);
    }

    public ResultSet execRawQuery(String sql) {
        ResultSet rs = null;
        try {
            Statement stm = this.conn.createStatement();
            rs = stm.executeQuery(sql);
            return rs;
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
            return rs;
        }
    }

    public int executeRawSql(String sql) {
        boolean b = false;
        int x = 0;
        try {
            Statement stm = this.conn.createStatement();
            b = stm.execute(sql);
            x = stm.getUpdateCount();
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        this.log.logDebug("b:%b %d", b, x);
        return x;
    }

    private void convertAndRethrowException(SQLException e) {
        this.errorConverter.convertAndRethrowException(e);
    }

    public boolean doesTableExist(String tableName, PreparedStatementGenerator sqlgen, boolean disableSqlLogging) {
        String sql = sqlgen.generateTableDetect(tableName);
        ResultSet rs = null;
        boolean tblExists = false;
        try {
            Statement stm;
            if (!disableSqlLogging) {
                this.log.log("SQL: %s", sql);
            }
            if ((rs = (stm = this.conn.createStatement()).executeQuery(sql)) != null && rs.next()) {
                Boolean b = rs.getBoolean(1);
                tblExists = b;
            }
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        return tblExists;
    }

    public boolean execFieldDetect(String tableName, String fieldName, PreparedStatementGenerator sqlgen, boolean disableSqlLogging) {
        String sql = sqlgen.generateFieldDetect(tableName, fieldName);
        ResultSet rs = null;
        boolean tblExists = false;
        try {
            Statement stm;
            if (!disableSqlLogging) {
                this.log.log("SQL: %s", sql);
            }
            if ((rs = (stm = this.conn.createStatement()).executeQuery(sql)) != null && rs.next()) {
                Boolean b = rs.getBoolean(1);
                tblExists = b;
            }
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        return tblExists;
    }

    public int enumerateDBSchema(PreparedStatementGenerator sqlgen, Log logToUse, DBListingType listingType) {
        String sql = sqlgen.generateSchemaListing(listingType);
        ResultSet rs = null;
        try {
            logToUse.log("SQL: %s", sql);
            Statement stm = this.conn.createStatement();
            rs = stm.executeQuery(sql);
            String title = listingType.name();
            if (rs != null) {
                logToUse.log("--- list of %s ---", title);
                int n = ResultSetHelper.getColumnCount(rs);
                while (rs.next()) {
                    StringJoiner joiner = new StringJoiner(",");
                    for (int i = 0; i < n; ++i) {
                        Object obj = rs.getObject(i + 1);
                        joiner.add(obj == null ? "null" : obj.toString());
                    }
                    this.log.log(joiner.toString(), new Object[0]);
                }
                logToUse.log("--- end list of %s ---", title);
            }
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        return 9999;
    }

    public String findConstraint(PreparedStatementGenerator sqlgen, String tableName, String fieldName, String constraintType) {
        String sql = sqlgen.generateSchemaListing(DBListingType.ALL_CONSTRAINTS);
        ResultSet rs = null;
        try {
            this.log.log("SQL: %s", sql);
            Statement stm = this.conn.createStatement();
            rs = stm.executeQuery(sql);
            if (rs != null) {
                int n = ResultSetHelper.getColumnCount(rs);
                int iConstrainName = 3;
                int iConstrainType = 4;
                int iTable = 7;
                int iColumn = 10;
                while (rs.next()) {
                    String cname = this.getRsValue(rs, iConstrainName);
                    String ctype = this.getRsValue(rs, iConstrainType);
                    String tbl = this.getRsValue(rs, iTable);
                    String field = this.getRsValue(rs, iColumn);
                    if (!tableName.equalsIgnoreCase(tbl) || !fieldName.equalsIgnoreCase(field) || !constraintType.equalsIgnoreCase(ctype)) continue;
                    return cname;
                }
            }
        }
        catch (SQLException e) {
            this.convertAndRethrowException(e);
        }
        return null;
    }

    private String getRsValue(ResultSet rs, int index) throws SQLException {
        Object obj = rs.getObject(index);
        return obj == null ? "" : obj.toString();
    }

    public void close() {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.log.logDebug("end.", new Object[0]);
    }
}

