/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringJoiner;
import org.delia.core.FactoryService;
import org.delia.core.ServiceBase;
import org.delia.db.DBAccessContext;
import org.delia.db.DBCapabilties;
import org.delia.db.DBErrorConverter;
import org.delia.db.DBException;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.db.DBType;
import org.delia.db.InsertContext;
import org.delia.db.QueryDetails;
import org.delia.db.ResultSetHelper;
import org.delia.db.SqlExecuteContext;
import org.delia.db.ValueHelper;
import org.delia.db.h2.SqlHelperFactory;
import org.delia.db.sql.ConnectionFactory;
import org.delia.db.sql.prepared.FKSqlGenerator;
import org.delia.db.sql.prepared.InsertStatementGenerator;
import org.delia.db.sql.prepared.PreparedStatementGenerator;
import org.delia.db.sql.prepared.SqlStatement;
import org.delia.db.sql.table.TableCreator;
import org.delia.db.sql.table.TableInfo;
import org.delia.error.DeliaError;
import org.delia.log.Log;
import org.delia.log.LogLevel;
import org.delia.log.SimpleLog;
import org.delia.runner.ValueException;
import org.delia.type.BuiltInTypes;
import org.delia.type.DRelation;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DValue;
import org.delia.type.Shape;
import org.delia.type.TypePair;
import org.delia.valuebuilder.RelationValueBuilder;
import org.delia.valuebuilder.ScalarValueBuilder;
import org.delia.valuebuilder.StructValueBuilder;

public abstract class DBInterfaceBase
extends ServiceBase
implements DBInterface {
    protected DBCapabilties capabilities;
    protected Log sqlLog;
    protected TableCreator tableCreator;
    protected ValueHelper valueHelper;
    protected SqlHelperFactory sqlHelperFactory;
    protected ConnectionFactory connFactory;
    protected DBType dbType;
    protected DBErrorConverter errorConverter;
    protected Random random = new Random();

    public DBInterfaceBase(DBType dbType, FactoryService factorySvc, ConnectionFactory connFactory, SqlHelperFactory sqlhelperFactory) {
        super(factorySvc);
        this.dbType = dbType;
        this.capabilities = new DBCapabilties(true, true, true, true);
        this.sqlLog = new SimpleLog();
        this.connFactory = connFactory;
        this.sqlHelperFactory = sqlhelperFactory;
        this.valueHelper = this.sqlHelperFactory.createValueHelper();
    }

    @Override
    public DBCapabilties getCapabilities() {
        return this.capabilities;
    }

    @Override
    public abstract DBExecutor createExector(DBAccessContext var1);

    @Override
    public void init(FactoryService factorySvc) {
        this.factorySvc = factorySvc;
        this.log = factorySvc.getLog();
        this.et = factorySvc.getErrorTracker();
    }

    protected DValue extractGeneratedKey(InsertContext ctx, SqlExecuteContext sqlctx) throws SQLException {
        ResultSet rs = sqlctx.genKeys;
        DValue genVal = this.valueHelper.extractGeneratedKey(rs, ctx.genKeytype.getShape(), sqlctx.registry);
        return genVal;
    }

    protected void logSql(String sql) {
        this.sqlLog.log("SQL: " + sql, new Object[0]);
    }

    protected List<DValue> buildDValueList(ResultSet rs, DStructType dtype, QueryDetails details, DBAccessContext dbctx) {
        List<DValue> list = null;
        try {
            list = this.doBuildDValueList(rs, dtype, dbctx);
            if (details.mergeRows) {
                list = this.mergeRows(list, dtype, details);
            }
        }
        catch (ValueException e) {
            DeliaError err = e.errL.get(0);
            throw new DBException(err);
        }
        catch (Exception e) {
            DeliaError err = new DeliaError("db-resultset-error", e.getMessage());
            throw new DBException(err);
        }
        return list;
    }

    protected List<DValue> buildScalarResult(ResultSet rs, DType selectResultType, QueryDetails details, DBAccessContext dbctx) {
        ArrayList<DValue> list = new ArrayList<DValue>();
        try {
            DValue dval = this.valueHelper.readIndexedField(selectResultType, 1, rs, dbctx);
            list.add(dval);
        }
        catch (ValueException e) {
            DeliaError err = e.errL.get(0);
            throw new DBException(err);
        }
        catch (Exception e) {
            DeliaError err = new DeliaError("db-resultset-error", e.getMessage());
            throw new DBException(err);
        }
        return list;
    }

    protected List<DValue> mergeRows(List<DValue> rawList, DStructType dtype, QueryDetails details) {
        ArrayList<DValue> list = new ArrayList<DValue>();
        ArrayList<DValue> foreignKeyL = new ArrayList<DValue>();
        DValue firstVal = null;
        int i = 0;
        for (DValue dval : rawList) {
            DValue inner = dval.asStruct().getField(details.mergeOnField);
            if (inner != null) {
                if (i == 0) {
                    firstVal = dval;
                }
                DRelation drel = inner.asRelation();
                foreignKeyL.add(drel.getForeignKey());
            }
            ++i;
        }
        if (firstVal != null) {
            DValue inner = firstVal.asStruct().getField(details.mergeOnField);
            if (inner != null) {
                DRelation drel = inner.asRelation();
                drel.getMultipleKeys().clear();
                drel.getMultipleKeys().addAll(foreignKeyL);
                list.add(firstVal);
            }
        } else if (!rawList.isEmpty()) {
            list.addAll(rawList);
        }
        return list;
    }

    protected List<DValue> doBuildDValueList(ResultSet rs, DStructType dtype, DBAccessContext dbctx) throws Exception {
        ArrayList<DValue> list = new ArrayList<DValue>();
        while (rs.next()) {
            StructValueBuilder structBuilder = new StructValueBuilder(dtype);
            for (TypePair pair : dtype.getAllFields()) {
                DValue inner;
                if (pair.type.isStructShape()) {
                    if (!ResultSetHelper.hasColumn(rs, pair.name)) continue;
                    inner = this.createRelation(dtype, pair, rs, dbctx);
                    structBuilder.addField(pair.name, inner);
                    continue;
                }
                inner = this.readField(pair, rs, dbctx);
                structBuilder.addField(pair.name, inner);
            }
            boolean b = structBuilder.finish();
            if (!b) {
                DeliaError err = structBuilder.getValidationErrors().get(0);
                throw new ValueException(err);
            }
            DValue dval = structBuilder.getDValue();
            list.add(dval);
        }
        return list;
    }

    protected DValue createRelation(DStructType structType, TypePair targetPair, ResultSet rs, DBAccessContext dbctx) throws SQLException {
        String s = rs.getString(targetPair.name);
        if (rs.wasNull()) {
            return null;
        }
        ScalarValueBuilder xbuilder = this.factorySvc.createScalarValueBuilder(dbctx.registry);
        DValue keyVal = xbuilder.buildInt(s);
        DType relType = dbctx.registry.getType(BuiltInTypes.RELATION_SHAPE);
        String typeName = targetPair.type.getName();
        RelationValueBuilder builder = new RelationValueBuilder(relType, typeName, dbctx.registry);
        builder.buildFromString(keyVal.asString());
        boolean b = builder.finish();
        if (!b) {
            return null;
        }
        return builder.getDValue();
    }

    protected DValue readField(TypePair pair, ResultSet rs, DBAccessContext dbctx) throws SQLException {
        return this.valueHelper.readField(pair, rs, dbctx);
    }

    protected PreparedStatementGenerator createPrepSqlGen(DBAccessContext dbctx) {
        return this.sqlHelperFactory.createPrepSqlGen(dbctx);
    }

    protected InsertStatementGenerator createPrepInsertSqlGen(DBAccessContext dbctx) {
        return this.sqlHelperFactory.createPrepInsertSqlGen(dbctx);
    }

    protected synchronized TableCreator createTableCreator(DBAccessContext dbctx) {
        if (this.tableCreator == null) {
            this.tableCreator = this.sqlHelperFactory.createTableCreator(dbctx);
        }
        return this.tableCreator;
    }

    protected FKSqlGenerator createFKSqlGen(List<TableInfo> tblinfoL, DBAccessContext dbctx) {
        return this.sqlHelperFactory.createFKSqlGen(tblinfoL, dbctx);
    }

    @Override
    public boolean isSQLLoggingEnabled() {
        return !LogLevel.OFF.equals((Object)this.sqlLog.getLevel());
    }

    @Override
    public void enableSQLLogging(boolean b) {
        if (b) {
            this.sqlLog.setLevel(LogLevel.INFO);
        } else {
            this.sqlLog.setLevel(LogLevel.OFF);
        }
    }

    protected void logSql(SqlStatement statement) {
        StringJoiner joiner = new StringJoiner(",");
        for (DValue dval : statement.paramL) {
            if (dval.getType().isShape(Shape.STRING)) {
                joiner.add(String.format("'%s'", dval.asString()));
                continue;
            }
            joiner.add(dval == null ? "null" : dval.asString());
        }
        String s = String.format("%s  -- (%s)", statement.sql, joiner.toString());
        this.logSql(s);
    }

    @Override
    public DBType getDBType() {
        return this.dbType;
    }

    protected String generateUniqueConstraintName() {
        int n = this.random.nextInt(0x7FFFFFF5);
        return String.format("DConstraint_%d", n);
    }
}

