/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.h2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.delia.core.FactoryService;
import org.delia.db.DBAccessContext;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterfaceBase;
import org.delia.db.DBInterfaceInternal;
import org.delia.db.DBType;
import org.delia.db.DBValidationException;
import org.delia.db.InsertContext;
import org.delia.db.QueryContext;
import org.delia.db.QueryDetails;
import org.delia.db.QuerySpec;
import org.delia.db.SqlExecuteContext;
import org.delia.db.h2.DBListingType;
import org.delia.db.h2.H2DBConnection;
import org.delia.db.h2.H2DBExecutor;
import org.delia.db.h2.H2ErrorConverter;
import org.delia.db.h2.SqlHelperFactory;
import org.delia.db.sql.ConnectionFactory;
import org.delia.db.sql.prepared.FKSqlGenerator;
import org.delia.db.sql.prepared.InsertStatementGenerator;
import org.delia.db.sql.prepared.PreparedStatementGenerator;
import org.delia.db.sql.prepared.SelectFuncHelper;
import org.delia.db.sql.prepared.SqlStatement;
import org.delia.db.sql.table.TableCreator;
import org.delia.log.Log;
import org.delia.runner.QueryResponse;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DValue;
import org.delia.util.DeliaExceptionHelper;

public class H2DBInterface
extends DBInterfaceBase
implements DBInterfaceInternal {
    public H2DBInterface(FactoryService factorySvc, ConnectionFactory connFactory) {
        super(DBType.H2, factorySvc, connFactory, new SqlHelperFactory(factorySvc));
        this.errorConverter = new H2ErrorConverter();
        this.connFactory.setErrorConverter(this.errorConverter);
    }

    @Override
    public DBExecutor createExector(DBAccessContext ctx) {
        H2DBConnection conn = new H2DBConnection(this.factorySvc, this.connFactory, this.errorConverter);
        H2DBExecutor dbexecutor = new H2DBExecutor(this, ctx, conn);
        ctx.connObject = conn;
        conn.openDB();
        return dbexecutor;
    }

    @Override
    public DValue executeInsert(DValue dval, InsertContext ctx, DBAccessContext dbctx) {
        this.createTableCreator(dbctx);
        SqlExecuteContext sqlctx = new SqlExecuteContext(dbctx);
        InsertStatementGenerator sqlgen = this.createPrepInsertSqlGen(dbctx);
        SqlStatement statement = sqlgen.generateInsert(dval, this.tableCreator.alreadyCreatedL);
        this.logSql(statement);
        H2DBConnection conn = (H2DBConnection)dbctx.connObject;
        try {
            sqlctx.getGeneratedKeys = ctx.extractGeneratedKeys;
            int n = conn.executeInsertStatement(statement, sqlctx);
        }
        catch (DBValidationException e) {
            this.convertAndRethrow(e, dbctx);
        }
        DValue genVal = null;
        if (ctx.extractGeneratedKeys && sqlctx.genKeys != null) {
            try {
                genVal = this.extractGeneratedKey(ctx, sqlctx);
            }
            catch (SQLException e) {
                DeliaExceptionHelper.throwError("extract-generated-key-failed", e.getMessage(), new Object[0]);
            }
        }
        return genVal;
    }

    @Override
    public QueryResponse executeQuery(QuerySpec spec, QueryContext qtx, DBAccessContext dbctx) {
        SqlStatement statement;
        QueryDetails details = new QueryDetails();
        if (qtx.loadFKs) {
            this.createTableCreator(dbctx);
            FKSqlGenerator smartgen = this.createFKSqlGen(this.tableCreator.alreadyCreatedL, dbctx);
            statement = smartgen.generateFKsQuery(spec, details);
        } else {
            PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
            statement = sqlgen.generateQuery(spec);
        }
        this.logSql(statement);
        H2DBConnection conn = (H2DBConnection)dbctx.connObject;
        ResultSet rs = conn.execQueryStatement(statement, dbctx);
        QueryResponse qresp = new QueryResponse();
        SelectFuncHelper sfhelper = this.sqlHelperFactory.createSelectFuncHelper(dbctx);
        DType selectResultType = sfhelper.getSelectResultType(spec);
        if (selectResultType.isScalarShape()) {
            qresp.dvalList = this.buildScalarResult(rs, selectResultType, details, dbctx);
            this.fixupForExist(spec, qresp.dvalList, sfhelper, dbctx);
            qresp.ok = true;
        } else {
            String typeName = spec.queryExp.getTypeName();
            DStructType dtype = dbctx.registry.findTypeOrSchemaVersionType(typeName);
            qresp.dvalList = this.buildDValueList(rs, dtype, details, dbctx);
            qresp.ok = true;
        }
        return qresp;
    }

    private void fixupForExist(QuerySpec spec, List<DValue> dvalList, SelectFuncHelper sfhelper, DBAccessContext dbctx) {
        if (sfhelper.isExistsPresent(spec)) {
            this.valueHelper.fixupForExist(dvalList, dbctx);
            DValue dValue = dvalList.get(0);
        }
    }

    @Override
    public boolean doesTableExist(String tableName, DBAccessContext dbctx) {
        H2DBConnection conn = (H2DBConnection)dbctx.connObject;
        PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
        return conn.newExecTableDetect(tableName, sqlgen, dbctx.disableSqlLogging);
    }

    @Override
    public boolean doesFieldExist(String tableName, String fieldName, DBAccessContext dbctx) {
        H2DBConnection conn = (H2DBConnection)dbctx.connObject;
        PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
        return conn.execFieldDetect(tableName, fieldName, sqlgen, dbctx.disableSqlLogging);
    }

    @Override
    public void executeDelete(QuerySpec spec, DBAccessContext dbctx) {
        PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
        SqlStatement statement = sqlgen.generateDelete(spec);
        this.logSql(statement);
        this.createTableCreator(dbctx);
        H2DBConnection conn = (H2DBConnection)dbctx.connObject;
        try {
            SqlExecuteContext sqlctx = new SqlExecuteContext(dbctx);
            boolean bl = conn.execStatement(statement, sqlctx);
        }
        catch (DBValidationException e) {
            this.convertAndRethrow(e, dbctx);
        }
    }

    @Override
    public int executeUpdate(QuerySpec spec, DValue dval, DBAccessContext dbctx) {
        this.createTableCreator(dbctx);
        PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
        SqlStatement statement = sqlgen.generateUpdate(dval, this.tableCreator.alreadyCreatedL, spec);
        if (statement.sql.isEmpty()) {
            return 0;
        }
        this.logSql(statement);
        H2DBConnection conn = (H2DBConnection)dbctx.connObject;
        int updateCount = 0;
        try {
            SqlExecuteContext sqlctx = new SqlExecuteContext(dbctx);
            updateCount = conn.execUpdateStatement(statement, sqlctx);
        }
        catch (DBValidationException e) {
            this.convertAndRethrow(e, dbctx);
        }
        return updateCount;
    }

    protected int executeSQL(String sql, DBAccessContext ctx) {
        this.logSql(sql);
        int updateCount = 0;
        try {
            H2DBConnection conn = (H2DBConnection)ctx.connObject;
            updateCount = conn.executeRawSql(sql);
        }
        catch (DBValidationException e) {
            this.convertAndRethrow(e, ctx);
        }
        return updateCount;
    }

    @Override
    public void createTable(String tableName, DBAccessContext dbctx) {
        DStructType dtype = dbctx.registry.findTypeOrSchemaVersionType(tableName);
        this.createTableCreator(dbctx);
        String sql = this.tableCreator.generateCreateTable(tableName, dtype);
        this.executeSQL(sql, dbctx);
    }

    @Override
    public void deleteTable(String tableName, DBAccessContext dbctx) {
        String sql = String.format("DROP TABLE IF EXISTS %s;", tableName);
        this.executeSQL(sql, dbctx);
    }

    @Override
    public void renameTable(String tableName, String newTableName, DBAccessContext dbctx) {
        String sql = String.format("ALTER TABLE %s RENAME TO %s", tableName, newTableName);
        this.executeSQL(sql, dbctx);
    }

    @Override
    public void createField(String typeName, String fieldName, DBAccessContext dbctx) {
        TableCreator creator = this.sqlHelperFactory.createTableCreator(dbctx);
        String sql = creator.generateCreateField(typeName, null, fieldName);
        this.executeSQL(sql, dbctx);
    }

    @Override
    public void deleteField(String typeName, String field, DBAccessContext dbctx) {
        String sql = String.format("ALTER TABLE %s DROP COLUMN %s", typeName, field);
        this.executeSQL(sql, dbctx);
    }

    private void convertAndRethrow(DBValidationException e, DBAccessContext ctx) {
        this.createTableCreator(ctx);
        this.errorConverter.convertAndRethrow(e, this.tableCreator.alreadyCreatedL);
    }

    @Override
    public void renameField(String typeName, String fieldName, String newName, DBAccessContext dbctx) {
        TableCreator creator = this.sqlHelperFactory.createTableCreator(dbctx);
        String sql = creator.generateRenameField(typeName, fieldName, newName);
        this.executeSQL(sql, dbctx);
    }

    @Override
    public void alterFieldType(String typeName, String fieldName, String newFieldType, DBAccessContext dbctx) {
        TableCreator creator = this.sqlHelperFactory.createTableCreator(dbctx);
        String sql = creator.generateAlterFieldType(typeName, fieldName, newFieldType);
        this.executeSQL(sql, dbctx);
    }

    @Override
    public void alterField(String typeName, String fieldName, String deltaFlags, DBAccessContext dbctx) {
        String constraintName = null;
        if (deltaFlags.contains("-U")) {
            H2DBConnection conn = (H2DBConnection)dbctx.connObject;
            PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
            constraintName = conn.findConstraint(sqlgen, typeName, fieldName, "UNIQUE");
        } else if (deltaFlags.contains("+U")) {
            constraintName = this.generateUniqueConstraintName();
        }
        TableCreator creator = this.sqlHelperFactory.createTableCreator(dbctx);
        String sql = creator.generateAlterField(typeName, fieldName, deltaFlags, constraintName);
        this.executeSQL(sql, dbctx);
    }

    @Override
    public String getConnectionSummary() {
        return this.connFactory.getConnectionSummary();
    }

    @Override
    public void enablePrintStackTrace(boolean b) {
        this.errorConverter.setPrintStackTraceEnabled(b);
    }

    @Override
    public void enumerateAllTables(Log logToUse) {
        DBAccessContext dbctx = new DBAccessContext(null, null);
        H2DBExecutor exec = (H2DBExecutor)this.createExector(dbctx);
        PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
        exec.getConn().enumerateDBSchema(sqlgen, logToUse, DBListingType.ALL_TABLES);
        exec.close();
    }

    @Override
    public void enumerateAllConstraints(Log logToUse) {
        DBAccessContext dbctx = new DBAccessContext(null, null);
        H2DBExecutor exec = (H2DBExecutor)this.createExector(dbctx);
        PreparedStatementGenerator sqlgen = this.createPrepSqlGen(dbctx);
        exec.getConn().enumerateDBSchema(sqlgen, logToUse, DBListingType.ALL_CONSTRAINTS);
        exec.close();
    }
}

