/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.delia.core.DateFormatService;
import org.delia.core.FactoryService;
import org.delia.db.DBAccessContext;
import org.delia.db.DBCapabilties;
import org.delia.db.DBException;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.db.DBInterfaceInternal;
import org.delia.db.DBType;
import org.delia.db.InsertContext;
import org.delia.db.InternalException;
import org.delia.db.QueryBuilderService;
import org.delia.db.QueryContext;
import org.delia.db.QuerySpec;
import org.delia.db.memdb.AllRowSelector;
import org.delia.db.memdb.MemDBExecutor;
import org.delia.db.memdb.MemDBTable;
import org.delia.db.memdb.OpRowSelector;
import org.delia.db.memdb.PrimaryKeyRowSelector;
import org.delia.db.memdb.RowSelector;
import org.delia.db.memdb.RowSelectorBase;
import org.delia.db.memdb.SerialProvider;
import org.delia.db.sql.QueryType;
import org.delia.db.sql.QueryTypeDetector;
import org.delia.error.DeliaError;
import org.delia.error.ErrorTracker;
import org.delia.log.Log;
import org.delia.runner.FetchRunnerImpl;
import org.delia.runner.FilterEvaluator;
import org.delia.runner.QueryResponse;
import org.delia.type.DStructType;
import org.delia.type.DValue;
import org.delia.type.TypePair;
import org.delia.util.DValueHelper;
import org.delia.validation.ValidationRuleRunner;

public class MemDBInterface
implements DBInterface,
DBInterfaceInternal {
    private Map<String, MemDBTable> tableMap = new ConcurrentHashMap<String, MemDBTable>();
    private Stuff stuff;
    DateFormatService fmtSvc;
    private FactoryService factorySvc;
    protected Log log;
    protected ErrorTracker et;
    private DBCapabilties capabilities = new DBCapabilties(false, false, false, false);
    public boolean createTablesAsNeededFlag = false;

    @Override
    public DBCapabilties getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void init(FactoryService factorySvc) {
        this.factorySvc = factorySvc;
        this.log = factorySvc.getLog();
        this.et = factorySvc.getErrorTracker();
        this.fmtSvc = factorySvc.getDateFormatService();
    }

    @Override
    public DValue executeInsert(DValue dval, InsertContext ctx, DBAccessContext dbctx) {
        String typeName = dval.getType().getName();
        MemDBTable tbl = this.tableMap.get(typeName);
        if (tbl == null) {
            tbl = this.handleUnknownTable(typeName, dbctx);
        }
        DValue generatedId = this.addSerialValuesIfNeeded(dval, tbl, dbctx);
        this.checkUniqueness(dval, tbl, typeName, null, false, dbctx);
        tbl.rowL.add(dval);
        return generatedId;
    }

    private DValue addSerialValuesIfNeeded(DValue dval, MemDBTable tbl, DBAccessContext dbctx) {
        if (!dval.getType().isStructShape()) {
            return null;
        }
        DValue generatedId = null;
        DStructType structType = (DStructType)dval.getType();
        for (TypePair pair : structType.getAllFields()) {
            if (!structType.fieldIsSerial(pair.name)) continue;
            if (dval.asStruct().getField(pair.name) != null) {
                DeliaError err = this.et.add("serial-value-cannot-be-provided", String.format("serial field '%s' must not have a value specified", pair.name));
                throw new DBException(err);
            }
            Stuff stuff = this.findOrCreateStuff(dbctx);
            DValue serialVal = stuff.serialProvider.generateSerialValue(structType, pair);
            dval.asMap().put(pair.name, serialVal);
            generatedId = serialVal;
            this.log.logDebug("serial id generated: %s", serialVal.asString());
        }
        return generatedId;
    }

    private Stuff findOrCreateStuff(DBAccessContext ctx) {
        if (this.stuff == null) {
            this.stuff = new Stuff();
            this.stuff.init(this.factorySvc, ctx);
        }
        return this.stuff;
    }

    private void checkUniqueness(DValue dval, MemDBTable tbl, String typeName, DValue existing, boolean allowMissing, DBAccessContext dbctx) {
        List<TypePair> candidates = DValueHelper.findAllUniqueFieldPair(dval.getType());
        if (CollectionUtils.isEmpty(candidates)) {
            return;
        }
        DStructType structType = (DStructType)dval.getType();
        for (TypePair pair : candidates) {
            String ss2;
            String ss1;
            DValue oldVal;
            String uniqueField = pair.name;
            DValue inner = DValueHelper.getFieldValue(dval, uniqueField);
            if (inner == null) {
                if (structType.fieldIsOptional(pair.name) || allowMissing) continue;
                DeliaError err = this.et.add("empty-key-value", String.format("primary key '%s' is null", uniqueField));
                throw new DBException(err);
            }
            if (existing != null && (oldVal = DValueHelper.getFieldValue(existing, uniqueField)) != null && (ss1 = inner.asString()).equals(ss2 = oldVal.asString())) continue;
            QuerySpec spec = new QuerySpec();
            QueryBuilderService builderSvc = this.factorySvc.getQueryBuilderService();
            spec.queryExp = builderSvc.createEqQuery(typeName, uniqueField, inner);
            spec.evaluator = new FilterEvaluator(this.factorySvc, dbctx.varEvaluator);
            spec.evaluator.init(spec.queryExp);
            QueryContext qtx = new QueryContext();
            QueryResponse qresp = this.executeQuery(spec, qtx, dbctx);
            if (!qresp.ok || qresp.emptyResults()) continue;
            DeliaError err = this.et.add("duplicate-unique-value", String.format("%s. row with unique field '%s' = '%s' already exists", structType.getName(), uniqueField, inner.asString()));
            throw new DBException(err);
        }
    }

    @Override
    public QueryResponse executeQuery(QuerySpec spec, QueryContext qtx, DBAccessContext dbctx) {
        QueryResponse qresp = new QueryResponse();
        try {
            qresp = this.doExecuteQuery(spec, qtx, dbctx);
        }
        catch (InternalException e) {
            qresp.ok = false;
            qresp.err = e.getLastError();
        }
        return qresp;
    }

    private QueryResponse doExecuteQuery(QuerySpec spec, QueryContext qtx, DBAccessContext dbctx) {
        QueryResponse qresp = new QueryResponse();
        RowSelector selector = this.createSelector(spec, dbctx);
        if (selector == null) {
            return qresp;
        }
        List<DValue> dvalList = selector.match(selector.getTbl().rowL);
        if (selector.wasError()) {
            qresp.ok = false;
            return qresp;
        }
        if (qtx.loadFKs) {
            for (DValue dval : dvalList) {
                this.addAnyFKs(dval, dbctx);
            }
        }
        qresp.dvalList = dvalList;
        qresp.ok = true;
        return qresp;
    }

    private void addAnyFKs(DValue dval, DBAccessContext dbctx) {
        DBExecutor dbexecutor = this.createExector(dbctx);
        FetchRunnerImpl fetchRunner = new FetchRunnerImpl(this.factorySvc, dbexecutor, dbctx.registry, dbctx.varEvaluator);
        ValidationRuleRunner ruleRunner = new ValidationRuleRunner(this.factorySvc, this.getCapabilities(), fetchRunner);
        ruleRunner.enableRelationModifier(true);
        ruleRunner.setPopulateFKsFlag(true);
        ruleRunner.validateRelationRules(dval);
    }

    private RowSelector createSelector(QuerySpec spec, DBAccessContext dbctx) {
        RowSelectorBase selector;
        String typeName = spec.queryExp.getTypeName();
        MemDBTable tbl = this.tableMap.get(typeName);
        if (tbl == null) {
            tbl = this.handleUnknownTable(typeName, dbctx);
        }
        Stuff stuff = this.findOrCreateStuff(dbctx);
        QueryType queryType = stuff.queryDetectorSvc.detectQueryType(spec);
        switch (queryType) {
            case ALL_ROWS: {
                selector = new AllRowSelector();
                break;
            }
            case OP: {
                selector = new OpRowSelector();
                break;
            }
            default: {
                selector = new PrimaryKeyRowSelector();
            }
        }
        selector.setTbl(tbl);
        DStructType dtype = this.findType(typeName, dbctx);
        selector.init(this.et, spec, dtype, dbctx.registry);
        if (selector.wasError()) {
            DeliaError err = this.et.add("row-selector-error", String.format("row selector failed for type '%s'", typeName));
            throw new DBException(err);
        }
        return selector;
    }

    private MemDBTable handleUnknownTable(String typeName, DBAccessContext dbctx) {
        if (this.createTablesAsNeededFlag) {
            this.createTable(typeName, dbctx);
            return this.tableMap.get(typeName);
        }
        DeliaError err = this.et.add("unknown-table-type", String.format("can't find type '%s'", typeName));
        throw new DBException(err);
    }

    private DStructType findType(String typeName, DBAccessContext dbctx) {
        return dbctx.registry.findTypeOrSchemaVersionType(typeName);
    }

    @Override
    public void executeDelete(QuerySpec spec, DBAccessContext dbctx) {
        QueryResponse qresp = new QueryResponse();
        try {
            qresp = this.doExecuteDelete(spec, dbctx);
        }
        catch (InternalException e) {
            throw new DBException(e.getLastError());
        }
    }

    private QueryResponse doExecuteDelete(QuerySpec spec, DBAccessContext dbctx) {
        QueryResponse qresp = new QueryResponse();
        RowSelector selector = this.createSelector(spec, dbctx);
        MemDBTable tbl = selector.getTbl();
        List<DValue> dvalList = selector.match(tbl.rowL);
        String typeName = spec.queryExp.getTypeName();
        if (selector.wasError()) {
            DeliaError err = this.et.add("row-selector-error", String.format("xrow selector failed for type '%s'", typeName));
            throw new DBException(err);
        }
        if (CollectionUtils.isEmpty(dvalList)) {
            qresp.dvalList = null;
            qresp.ok = true;
        }
        for (DValue dval : dvalList) {
            tbl.rowL.remove(dval);
        }
        qresp.dvalList = null;
        qresp.ok = true;
        return qresp;
    }

    @Override
    public boolean doesTableExist(String tableName, DBAccessContext dbctx) {
        return this.tableMap.containsKey(tableName);
    }

    @Override
    public boolean doesFieldExist(String tableName, String fieldName, DBAccessContext dbctx) {
        DStructType structType = this.findType(tableName, dbctx);
        if (structType == null) {
            return false;
        }
        return DValueHelper.fieldExists(structType, fieldName);
    }

    @Override
    public void createTable(String tableName, DBAccessContext dbctx) {
        this.tableMap.put(tableName, new MemDBTable());
    }

    @Override
    public void deleteTable(String tableName, DBAccessContext dbctx) {
        this.tableMap.remove(tableName);
    }

    @Override
    public void renameTable(String tableName, String newTableName, DBAccessContext dbctx) {
        MemDBTable tbl = this.tableMap.get(tableName);
        tbl.name = newTableName;
        this.tableMap.remove(tableName);
        this.tableMap.put(newTableName, tbl);
    }

    @Override
    public int executeUpdate(QuerySpec spec, DValue dvalUpdate, DBAccessContext dbctx) {
        int numRowsAffected = 0;
        try {
            numRowsAffected = this.doExecuteUpdate(spec, dvalUpdate, dbctx);
        }
        catch (InternalException e) {
            throw new DBException(e.getLastError());
        }
        return numRowsAffected;
    }

    private int doExecuteUpdate(QuerySpec spec, DValue dvalUpdate, DBAccessContext dbctx) {
        RowSelector selector = this.createSelector(spec, dbctx);
        MemDBTable tbl = selector.getTbl();
        List<DValue> dvalList = selector.match(tbl.rowL);
        String typeName = spec.queryExp.getTypeName();
        if (selector.wasError()) {
            DeliaError err = this.et.add("row-selector-error", String.format("xrow selector failed for type '%s'", typeName));
            throw new DBException(err);
        }
        if (CollectionUtils.isEmpty(dvalList)) {
            return 0;
        }
        for (DValue existing : dvalList) {
            this.checkUniqueness(dvalUpdate, tbl, typeName, existing, true, dbctx);
        }
        int numRowsAffected = dvalList.size();
        for (int i = 0; i < tbl.rowL.size(); ++i) {
            DValue dd = tbl.rowL.get(i);
            for (DValue tmp : dvalList) {
                if (tmp != dd) continue;
                DValue clone = DValueHelper.mergeOne(dvalUpdate, tmp);
                dvalList.remove(tmp);
                tbl.rowL.set(i, clone);
                break;
            }
            if (dvalList.isEmpty()) break;
        }
        return numRowsAffected;
    }

    @Override
    public boolean isSQLLoggingEnabled() {
        return true;
    }

    @Override
    public void enableSQLLogging(boolean b) {
    }

    @Override
    public void createField(String typeName, String field, DBAccessContext dbctx) {
    }

    @Override
    public void deleteField(String typeName, String field, DBAccessContext dbctx) {
    }

    @Override
    public DBExecutor createExector(DBAccessContext ctx) {
        return new MemDBExecutor(this, ctx);
    }

    @Override
    public void enablePrintStackTrace(boolean b) {
    }

    @Override
    public DBType getDBType() {
        return DBType.MEM;
    }

    @Override
    public String getConnectionSummary() {
        return "";
    }

    @Override
    public void renameField(String typeName, String fieldName, String newName, DBAccessContext dbctx) {
    }

    @Override
    public void alterFieldType(String typeName, String fieldName, String newFieldType, DBAccessContext dbctx) {
    }

    @Override
    public void alterField(String typeName, String fieldName, String deltaFlags, DBAccessContext dbctx) {
    }

    @Override
    public void enumerateAllTables(Log logToUse) {
    }

    @Override
    public void enumerateAllConstraints(Log logToUse) {
    }

    public static class Stuff {
        public SerialProvider serialProvider;
        public QueryTypeDetector queryDetectorSvc;

        public void init(FactoryService factorySvc, DBAccessContext dbctx) {
            this.queryDetectorSvc = new QueryTypeDetector(factorySvc, dbctx.registry);
            if (this.serialProvider == null) {
                this.serialProvider = new SerialProvider(factorySvc, dbctx.registry);
            } else {
                this.serialProvider.setRegistry(dbctx.registry);
            }
        }
    }
}

