/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb;

import java.util.ArrayList;
import java.util.List;
import org.delia.db.QuerySpec;
import org.delia.db.memdb.RowSelectorBase;
import org.delia.error.ErrorTracker;
import org.delia.type.DStructType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.type.TypePair;
import org.delia.util.DValueHelper;

public class PrimaryKeyRowSelector
extends RowSelectorBase {
    @Override
    public void init(ErrorTracker et, QuerySpec spec, DStructType dtype, DTypeRegistry registry) {
        super.init(et, spec, dtype, registry);
        TypePair pair = DValueHelper.findPrimaryKeyFieldPair(dtype);
        this.keyField = this.findKeyField(pair);
        if (this.keyField == null) {
            et.add("struct-missing-primary-key-field", "struct needs a unique or primaryKey field");
            this.wasError = true;
        }
        if (!this.keyFieldIsAllowedType(pair)) {
            String msg = String.format("type '%s' not allowed as primary key", pair.type.getName());
            et.add("struct-primary-key-field-wrong-type", msg);
            this.wasError = true;
        }
    }

    private boolean keyFieldIsAllowedType(TypePair pair) {
        switch (pair.type.getShape()) {
            case INTEGER: 
            case LONG: 
            case BOOLEAN: 
            case STRING: 
            case DATE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<DValue> match(List<DValue> list) {
        if (this.keyField == null) {
            this.wasError = true;
            return null;
        }
        ArrayList<DValue> resultL = new ArrayList<DValue>();
        for (DValue dval : list) {
            DValue key = dval.asStruct().getField(this.keyField);
            if (key == null) {
                this.wasError = true;
                return resultL;
            }
            if (!this.spec.evaluator.isEqualTo(key)) continue;
            resultL.add(dval);
            break;
        }
        return resultL;
    }

    private String findKeyField(TypePair pair) {
        if (pair == null) {
            return null;
        }
        return pair.name;
    }
}

