/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb.filter;

import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.LongExp;
import org.delia.compiler.ast.NullExp;
import org.delia.compiler.ast.NumberExp;
import org.delia.compiler.astx.XNAFMultiExp;
import org.delia.db.memdb.filter.BooleanOpEvaluator;
import org.delia.db.memdb.filter.DateOpEvaluator;
import org.delia.db.memdb.filter.IntOpEvaluator;
import org.delia.db.memdb.filter.LongOpEvaluator;
import org.delia.db.memdb.filter.NAFEvaluator;
import org.delia.db.memdb.filter.NullOpEvaluator;
import org.delia.db.memdb.filter.NumberOpEvaluator;
import org.delia.db.memdb.filter.OP;
import org.delia.db.memdb.filter.OpEvaluator;
import org.delia.db.memdb.filter.RelationOpEvaluator;
import org.delia.db.memdb.filter.StringOpEvaluator;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;

public class OpFactory {
    private DTypeRegistry registry;

    public OpFactory(DTypeRegistry registry) {
        this.registry = registry;
    }

    public OpEvaluator create(String opStr, Object op1, Object op2, DType op1HintType, DType op2HintType, boolean negFlag) {
        OpEvaluator eval = this.doCreate(opStr, op1, op2, op1HintType, op2HintType);
        if (eval != null) {
            eval.setNegFlag(negFlag);
        }
        return eval;
    }

    private OpEvaluator doCreate(String opStr, Object op1, Object op2, DType op1HintType, DType op2HintType) {
        OP op = OP.createFromString(opStr);
        if (op1 instanceof IdentExp) {
            IdentExp exp = (IdentExp)op1;
            String fieldName = exp.strValue();
            if (op1HintType != null) {
                return this.creatFromHint(op, fieldName, op1HintType);
            }
            OpEvaluator eval = this.createFromExp(op, op2, fieldName);
            return eval;
        }
        if (op1 instanceof XNAFMultiExp) {
            XNAFMultiExp multiexp = (XNAFMultiExp)op1;
            OpEvaluator inner = this.createFromExp(op, op2, "__SCALAR__");
            inner.setRightVar(op2);
            NAFEvaluator eval = new NAFEvaluator(multiexp, inner, this.registry);
            return eval;
        }
        if (op2 instanceof IdentExp) {
            IdentExp exp = (IdentExp)op2;
            String fieldName = exp.strValue();
            if (op2HintType != null) {
                return this.creatFromHint(op, fieldName, op2HintType);
            }
            OpEvaluator eval = this.createFromExp(op, op1, fieldName);
            return eval;
        }
        XNAFMultiExp multiexp = (XNAFMultiExp)op2;
        OpEvaluator inner = this.createFromExp(op, op1, "__SCALAR__");
        inner.setRightVar(op1);
        NAFEvaluator eval = new NAFEvaluator(multiexp, inner, this.registry);
        return eval;
    }

    private OpEvaluator createFromExp(OP op, Object op2, String fieldName) {
        if (op2 instanceof IntegerExp) {
            return new IntOpEvaluator(op, fieldName);
        }
        if (op2 instanceof LongExp) {
            return new LongOpEvaluator(op, fieldName);
        }
        if (op2 instanceof NumberExp) {
            return new NumberOpEvaluator(op, fieldName);
        }
        if (op2 instanceof NullExp) {
            return new NullOpEvaluator(op, fieldName);
        }
        return new StringOpEvaluator(op, fieldName);
    }

    private OpEvaluator creatFromHint(OP op, String fieldName, DType hintType) {
        switch (hintType.getShape()) {
            case INTEGER: {
                return new IntOpEvaluator(op, fieldName);
            }
            case LONG: {
                return new LongOpEvaluator(op, fieldName);
            }
            case NUMBER: {
                return new NumberOpEvaluator(op, fieldName);
            }
            case BOOLEAN: {
                return new BooleanOpEvaluator(op, fieldName);
            }
            case DATE: {
                return new DateOpEvaluator(op, fieldName);
            }
            case STRUCT: {
                return new RelationOpEvaluator(op, fieldName);
            }
        }
        return new StringOpEvaluator(op, fieldName);
    }
}

